/****************************************************************************/
/* KAD file routines                                                        */
/* Functions under DOS4Gw and PmodeW                                        */
/*--------------------------------------------------------------------------*/
/* Coded by Kodiak of The Apollo Project                                    */
/* AKA Charles Jones                                                        */
/*     1122 s 32nd St #2                                                    */
/*     Omaha, NE 68105                                                      */
/*     (402)-346-8974                                                       */
/*                                                                          */
/* Email: CAD@UnOmaha.edu                                                   */
/* IRC  : #Coders                                                           */
/*                                                                          */
/*                                                                          */
/* Copyright 1995 All Rights Reservered                                     */
/* Released to public domain, but hey if you use it greet me.               */
/****************************************************************************/
#include  <stdio.h>
#include  <stdlib.h>
#include  "lzc.h"              /* Compression system */
#include  "dir.stc"            /* KADfiles directory structure */
#include  "encrypt.h"

#define   MAXDIRS 10           /* Maximum # of Directory Entries. */
                               /* You should minimize this value. */
                               /* If the actual directory size is */
                               /* larger an Error message will inform you */


dir_struc directory[MAXDIRS];  /* KADfile's internal directory */
FILE      *kadfile;            /* KADfile's handle variable */
long int  numdirs;             /* Number of files in KADfile */
char      altstr[13];          /* Filename for error routines */
char      pathfile[50];        /* Buffer for Path+filename */

long int  kadfileinuse;        /* Flag 0=standard files, 1=Kadfile */
long int  currentkadx;         /* Current point to Directory entry */

/****************************************************************************/
/* Function : openkadfile                                                   */
/* IN : File name                                                           */
/* RETURNS:                                                                 */
/*          0 = no error                                                    */
/*          2 = file not found                                              */
/*          3 = not enough memory for directory                             */
/****************************************************************************/
/* Note :                                                                   */
/*      This routine will simply return if passed "None" for the filename   */
/*         which indicates that "true files" will be used, not a KADfile    */
/****************************************************************************/
int openkadfile(char *filename, char *password)
{
   int error, x, y, extra;

   kadfileinuse = strcmp(filename,"None");
   if (!kadfileinuse)
       return(0);

   strcpy(altstr,filename);
   
   extra = 0;
   
   error = 2;
   kadfile = fopen(filename,"r+b");
   if (strstr(filename,".exe") != NULL) 
       extra = 1;
       
   if (kadfile)
   {
      error = 0;
      fseek(kadfile, -sizeof(long int), SEEK_END);
      fread(&numdirs, sizeof(long int), 1, kadfile);
      fseek(kadfile, -(sizeof(dir_struc)*numdirs) - sizeof(long int)-extra, SEEK_END);
      numdirs--;
      strcpy(altstr,"");
      if (numdirs > MAXDIRS)
          error = 3;
      else
          {
             fread(&directory, sizeof(dir_struc)*numdirs, 1, kadfile);
             encryptdir((char *) directory, numdirs, password);
          }
   }
   return(error);
}


/****************************************************************************/
/* Function : loadfile                                                      */
/* IN : Size of the file to load, and where to put it.                      */
/* RETURNS:                                                                 */
/*          0 = no error                                                    */
/*          3 = file read error                                             */
/****************************************************************************/
/* Note : Loads a file from disk to a specified memory location.            */
/****************************************************************************/
int loadfile(int filesize,char *target)
{
    if (fread(target, filesize, 1, kadfile) == 1)
        return(0);
    return(5);
}


/****************************************************************************/
/* Function : handleloads                                                   */
/* IN : filename, memory location to load to, filesize                      */
/* RETURNS:                                                                 */
/*          result of appropiate routine                                    */
/*          6 = Unknown file type                                           */
/****************************************************************************/
/* Note : This is the guts of this whole thing.  Add any new files types to */
/*        this function. If you attemp to load an unknown file type and     */
/*        error will result.  This is the only routine you should need to   */
/*        change.                                                           */
/****************************************************************************/
int handleloads(char *filename, char *target, long int size)
{
    if (strstr(filename,".dat") != NULL)
        return(loadfile(size,target)); /* straight file */
    if (strstr(filename,".ari") != NULL)
        return(decompress(target,size)); /* compressed file */
    return(6);
}


/****************************************************************************/
/* Function : seekfile                                                      */
/* IN : filename                                                            */
/* RETURNS:                                                                 */
/*          0 : No error                                                    */
/*          1 : File not found withing KADfile                              */
/*          4 : Standard file not found in specified path                   */
/****************************************************************************/
/* Note : This function locates and opens the requested file.               */
/****************************************************************************/
int seekfile(char *filename)
{
    strcpy(altstr,filename);              /* record filename for later */

    if (!kadfileinuse) {                  /* Standard files */
       if (kadfile)
           fclose(kadfile);
       kadfile = fopen(filename,"r+b");
       if (kadfile)
           return(0);
       return(4);
    }

    currentkadx = 0;                      /* Scan internal directory */
    while ((strcmp(directory[currentkadx].name,filename))
            && (currentkadx <= numdirs)) 
                currentkadx++;
        
    if (currentkadx > numdirs)
       return(1);
    else {
        fseek(kadfile, directory[currentkadx].filepos, 0);
        return(0);
    }
}

/****************************************************************************/
/* Function : filesize                                                      */
/* IN : nothing                                                             */
/* RETURNS: filesize of the current file.                                   */
/****************************************************************************/
/* Note : Works for standard files only, file must be opened when called.   */
/****************************************************************************/
int filesize()
{
   long int temp1, temp2;
   temp1 = ftell(kadfile);
   fseek(kadfile,0,2);
   temp2 = ftell(kadfile);
   fseek(kadfile,temp1,0);
   return(temp2);
}

/****************************************************************************/
/* Function : getfile                                                       */
/* IN : Path, Filename, pointer to storage                                  */
/* RETURNS:                                                                 */
/*          Returns errors from subprocesses.                               */
/****************************************************************************/
/* Note : Main function for your use.                                       */
/****************************************************************************/
int getfile(char *path, char *filename, char *target)
{
    int error;

    if ((error = seekfile(filename)))
       return(error);

    if (!kadfileinuse) {
       strcpy(pathfile,path);
       strcat(pathfile,filename);
       return(handleloads(pathfile,target,filesize()));
    }

    return(handleloads(filename,target,directory[currentkadx].filesize));
}

/****************************************************************************/
/* Function : closekadfile                                                  */
/* IN : nothing                                                             */
/* RETURNS:                                                                 */
/*          Nothing                                                         */
/****************************************************************************/
/* Note : Hey, if I have to explain this one, your in trouble!              */
/****************************************************************************/
void closekadfile()
{
    if (kadfile)
        fclose(kadfile);
}
