/*
  Will read in a 320x200x256c pcx file

  These functions will work regardless of COMPILER_ setting
*/

#define BYTEMODE 0
#define RUNMODE  1
#define BUFLEN 1000
#define IMAGESIZE 64000L

char pcx_load(char *name,char *buf,char *pal);
char pcx_save(char *name,char *buf,char *pal);

typedef struct {
  char manufacturer;
  char version;
  char encoding;
  char bits_per_pixel;
  signed short int xmin,ymin;
  signed short int xmax,ymax;
  signed short int hres,vres;
  char palette16[48];
  char reserved;
  char color_planes;
  signed short int bytes_per_line;
  signed short int palette_type;
  char filler[58];
} PCX_HEADER;

char pcx_load(char *name,char *buf,char *pal)
{
  FILE *fp;
  signed short int mode,readlen,bufptr;
  char outbyte,bytecount,buffer[BUFLEN];
  long i;

  if((fp=fopen(name,"rb"))==NULL)
    return(0);

  if(buf!=NULL) {

    // Skip past the header
    fseek(fp,128L,SEEK_SET);

    // Read in the image
    mode=BYTEMODE;
    bufptr=0;
    readlen=0;
    for(i=0;i<IMAGESIZE;i++) {
      if(mode==BYTEMODE) {
        if(bufptr>=readlen) {
          bufptr=0;
          if((readlen=fread(buffer,1,BUFLEN,fp))==0)
            break;
        }
        outbyte=buffer[bufptr++];
        if(outbyte>0xbf) {
          bytecount=(signed short int)((signed short int)outbyte&0x3f);
          if(bufptr>=readlen) {
            bufptr=0;
            if((readlen=fread(buffer,1,BUFLEN,fp))==0)
              break;
          }
          outbyte=buffer[bufptr++];
          if(--bytecount>0)
            mode=RUNMODE;
        }
      } else if(--bytecount==0)
        mode=BYTEMODE;
      *buf++=outbyte;
    }
  }

  // Read in palette
  if(pal!=NULL) {
    fseek(fp,-768L,SEEK_END);
    fread(pal,1,768,fp);
  }
  fclose(fp);

  return(1);
}

char pcx_save(char *name,char *buf,char *pal)
{
  FILE *fp;
  signed short int i,j,t;
  signed short int vseg,voff;
  char *ptr,tpal[768];
  PCX_HEADER header= { 10,5,1,8,0,0,319,199,320,200,
                       0,0,0,0,0,0xaa,0,0xaa,0,0,0xaa,0xaa,0xaa,0,0,0xaa,
                       0,0xaa,0xaa,0x55,0,0xaa,0xaa,0xaa,0x55,0x55,0x55,0x55,0x55,0xff,0x55,0xff,
                       0x55,0x55,0xff,0xff,0xff,0x55,0x55,0xff,0x55,0xff,0xff,0xff,0x55,0xff,0xff,0xff,
                       0,1,320,0,
                       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };

  if(pal==NULL) {
    for(i=0;i<256;i++) {
      outp(0x3c7,i);
      tpal[i*3] = inp(0x3c9) <<2;
      tpal[i*3+1] = inp(0x3c9)<<2;
      tpal[i*3+2] = inp(0x3c9)<<2;
    }
  } else memcpy(tpal,pal,768);

  // open the file
  if((fp=fopen(name,"wb"))==NULL)
    return(0);

  // write the header
  fwrite(&header,1,sizeof(PCX_HEADER),fp);

  // encode the image
  i=0;
  t=0;
  for(j=0;j<200;j++) {
    ptr=&buf[320*j];
    t=0;
    do {
      i=0;
      while((ptr[t+i]==ptr[t+i+1]) && ((t+i)<320) && (i<63))
        i++;
      if(i>0) {
        fputc(i | 0xc0,fp);
        fputc(ptr[t],fp);
        t+=i;
      } else {
        if(((ptr[t]) & 0xc0)==0xc0)
          fputc(0xc1,fp);
        fputc(ptr[t++],fp);
      }
    } while(t<320);
  }

  //?? palette sig?
  fputc(0x0c,fp);

  // write the palette
  fwrite(tpal,1,768,fp);

  // close the file
  fclose(fp);

  // return ok
  return(1);
}
