/*  ERROR CHECK FOR DEFINES */
#ifdef COMPILER_BORLAND
  #ifdef COMPILER_WATCOM
    #error MUST USE ONLY ONE COMPILER_ OPTION
  #endif
#else
  #ifndef COMPILER_WATCOM
    #error MUST USE COMPILER_ OPTION
  #endif
#endif

#ifdef COMPILER_BORLAND

char key_press[128];
char key_lock[128];
char key_installed=0;

void key_trap();
void key_untrap();

void interrupt key_interrupt();
void interrupt (*key_old_interrupt)();

void key_trap()
{
  memset(key_press,0,128);
  memset(key_lock,0,128);

  if(key_installed)
    return;

  key_old_interrupt = _dos_getvect(9);
  _dos_setvect(9,key_interrupt);

  key_installed=1;
}

void key_untrap()
{
  if(key_installed)
    _dos_setvect(9,key_old_interrupt);
  key_installed=0;
}

void interrupt key_interrupt()
{
  char c;

  c=inp(0x60);

  // pressed or released a key?
  if(c<128) {
    if(!key_lock[c]) {
      key_press[c]=1;
    }
  } else {
    key_press[c-128]=0;
    key_lock[c-128]=0;
  }

  // clear the interrupt
  c=inp(0x61);
  outp(0x61,c | 0x80);
  outp(0x61,c);

  // and finally acknowledge the PIC
  outp(0x20,0x20);
}

keylock(signed short int n)
{
  key_lock[n]=1;
  key_press[n]=0;
}

#endif




#ifdef COMPILER_WATCOM

char key_press[128];
char key_lock[128];
char key_installed=0;

void key_trap();
void key_untrap();

void __interrupt __far key_interrupt();
void (__interrupt __far *key_old_interrupt)();

void key_trap()
{
  memset(key_press,0,128);
  memset(key_lock,0,128);

  if(key_installed)
    return;

  key_old_interrupt = _dos_getvect(0x09);
  _dos_setvect(9,key_interrupt);

  key_installed=1;
}

void key_untrap()
{
  if(key_installed)
    _dos_setvect(9,key_old_interrupt);
  key_installed=0;
}

void __interrupt __far key_interrupt()
{
  char c,t;

  c=inp(0x60);

  // pressed or released a key?
  if(c<128) {
    if(!key_lock[c]) {
      key_press[c]=1;
    }
  } else {
    key_press[c-128]=0;
    key_lock[c-128]=0;
  }

  // clear the interrupt
  c=inp(0x61);
  outp(0x61,c | 0x80);
  outp(0x61,c);

  // and finally acknowledge the PIC
  outp(0x20,0x20);
}

keylock(signed short int n)
{
  key_lock[n]=1;
  key_press[n]=0;
}

#endif
