/*  ERROR CHECK FOR DEFINES */
#ifdef COMPILER_BORLAND
  #ifdef COMPILER_WATCOM
    #error MUST USE ONLY ONE COMPILER_ OPTION
  #endif
#else
  #ifndef COMPILER_WATCOM
    #error MUST USE COMPILER_ OPTION
  #endif
#endif

#ifndef __STDARG_H
#include <stdarg.h>
#endif

#define FONT_DEFAULT_COLOR 15
#define FONT_DEFAULT_TRANS -1

//========================================================================
//  VARIABLES
//========================================================================
signed short int font_height=8;
signed short int font_width=8;

//char *font_ptr=(char *)0xf000fa6e;
#ifdef COMPILER_BORLAND
char *font_ptr=(char *)(0xf0000000);
#endif

#ifdef COMPILER_WATCOM
char *font_ptr=(char *)(0xf0000);
#endif


//========================================================================
//  PROTOTYPES
//========================================================================
signed short int font_printxy(char *screen,signed short int x,signed short int y,char *text,...);
void font_printc(char *screen,signed short int x,signed short int y,signed short int color,signed short int trans,char c);

//========================================================================
//  FUNCTIONS
//========================================================================
signed short int font_printxy(char *screen,signed short int x,signed short int y,char *text,...)
{
  va_list valist;
  char toprocess[200],*ptr;
  unsigned short int length;
  signed short int i,trans,color;
  char c1,c2,chars[4];
  signed short int xx,yy;

  va_start(valist,text);
  vsprintf(toprocess,text,valist);
  va_end(valist);

  length=0;
  trans=FONT_DEFAULT_TRANS;
  color=FONT_DEFAULT_COLOR;
  ptr=toprocess;
  xx=x;
  yy=y;

  while(*ptr) {

    // pull out a character
    c1=*ptr++;

    // is it an embedded command?
    if(c1=='/') {

      // pull out the next character
      if(!(c2=*ptr++))
        return(length);

      switch(c2) {
        // b is for background color
        // pull out 3 number for a decimal value 0 to 255 (>255 is transparent)
        case 'b': for(i=0;i<3;i++) {
                    chars[i]=*ptr++;
                    if(!chars[i])
                      return(length);
                    if((chars[i]<'0') || (chars[i]>'9'))
                      chars[i]='0';
                  }
                  chars[3]=0;

                  trans=atoi(chars);
                  if(trans<0)
                    trans=0;
                  if(trans>255)
                    trans=-1;

                  break;

        // t is for drawing color
        // pull out 3 number for a decimal value 0 to 255
        case 't': for(i=0;i<3;i++) {
                    chars[i]=*ptr++;
                    if(!chars[i])
                      return(length);
                    if((chars[i]<'0') || (chars[i]>'9'))
                      chars[i]='0';
                  }
                  chars[3]=0;

                  color=atoi(chars);
                  if(color<0)
                    color=0;
                  if(color>255)
                    color=255;

                  break;

        // n is for form feed  (move down 1 line)
        case 'n': yy++;
                  break;

        // r is for carriage return  (move to x)
        case 'r': xx=x;
                  break;

        // N is for form feed and carriage return (move to x, move down 1 line)
        case 'N': xx=x;
                  yy++;
                  break;

        default: font_printc(screen,xx,yy,color,trans,c2);
                 length++;
                 xx+=font_width;
                 break;
      }
    } else {
      font_printc(screen,xx,yy,color,trans,c1);
      length++;
      xx+=font_width;
    }
  }

  return(length);
}

void font_printc(char *screen,signed short int x,signed short int y,signed short int color,signed short int trans,char c)
{
  signed short int i,j,xx;
  char mask;
  char *cptr,*sptr;

  cptr = font_ptr + c * font_width + 0xfa6e;
  screen+=(y<<6)+(y<<8)+x;

  i=0;
  while(i++ < font_height && (unsigned short int)y < 200) {
    xx=x;
    mask=128;
    sptr=screen;
    j=0;
    while(j++ < font_width && (unsigned short int)xx < 320) {
      if(*cptr & mask)
        *sptr=color;
      else
      if(trans!=-1)
        *sptr=trans;
      sptr++;
      xx++;
      mask>>=1;
    }
    cptr++;
    screen+=320;
    y++;
  }
}
