/*
  All work in this is property of Jim Adams.
  I assume no responsibility of damages resulting in its use.
  You may freely distribute this as you feel.
  Make sure to give credit to me if you do.

                    Jim Adams  1996
*/

/*  Set what compiler you're using */
#define COMPILER_BORLAND
/*
#define COMPILER_WATCOM
*/

#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <stdlib.h>

/*
  Remove the following includes if you are going to use a makefile
    or compile as a project.  I use this method as only the main
    file needs these functions.  It's almost like appending all the
    libraries into the main file.
*/
#include "video.c"
#include "block.c"
#include "pcx.c"
#include "keytrap.c"

char *gfx_tiles[40];

typedef struct {
  char num;
  char tile[10];
  char height[10];
  char layer[10];
} MAP_INFO;
MAP_INFO map[32][32];

char virtual_screen[64000];
char palette[768];

signed short int sprite_x,sprite_y,sprite_layer,sprite_frame;

main()
{
  signed short int viewx,viewy,scroll_speed;

  setvmode(0x03);
  printf("Isometric Engine Example (c) 1996 by Jim Adams\n");
  printf("Use the keypad to move, 0-9 to control speed.  ESC quits.\n\n");
  printf("PRESS ANY KEY TO BEGIN.\n");
  if(!getch())
    getch();

  srand(1);

  if(!load_tiles())
    return;

  setup_map();

  setvmode(0x13);
  palette_set(palette,256,0);

  viewx = 0;
  viewy = 0;
  scroll_speed = 2;

  sprite_x = 0;
  sprite_y = 0;
  sprite_layer = 1;
  sprite_frame = 12;

  key_trap();

  // loop until ESC pressed
  while(!key_press[1]) {

    // check for HOME
    if(key_press[71])
      viewx -= scroll_speed;

    // check for END
    if(key_press[79])
      viewy += scroll_speed;

    // check for PGUP
    if(key_press[73])
      viewy -= scroll_speed;

    // check for PGDN
    if(key_press[81])
      viewx += scroll_speed;

    // check for LEFT
    if(key_press[75]) {
      viewx -= scroll_speed;
      viewy += scroll_speed;
    }

    // check for RIGHT
    if(key_press[77]) {
      viewx += scroll_speed;
      viewy -= scroll_speed;
    }

    // check for UP
    if(key_press[72]) {
      viewx -= scroll_speed;
      viewy -= scroll_speed;
    }

    // check for DOWN
    if(key_press[80]) {
      viewx += scroll_speed;
      viewy += scroll_speed;
    }

    // check for change in scroll speed
    // 0
    if(key_press[11])
      scroll_speed=2;
    // 1
    if(key_press[2])
      scroll_speed=4;
    // 2
    if(key_press[3])
      scroll_speed=6;
    // 3
    if(key_press[4])
      scroll_speed=8;
    // 4
    if(key_press[5])
      scroll_speed=10;
    // 5
    if(key_press[6])
      scroll_speed=12;
    // 6
    if(key_press[7])
      scroll_speed=14;
    // 7
    if(key_press[8])
      scroll_speed=16;
    // 8
    if(key_press[9])
      scroll_speed=18;
    // 9
    if(key_press[10])
      scroll_speed=20;

    // wrap around view
    if(viewx < 0)
      viewx += 32*16;    // 16 fine cords per map, map is 32 long
    if(viewx >= 32*16)
      viewx-=32*16;
    if(viewy < 0)
      viewy += 32*16;
    if(viewy >= 32*16)
      viewy-=32*16;

    // move and update the sprite
    sprite_x += ((rand()%4 - 2) *2);
    sprite_y += ((rand()%4 - 2) *2);
    if(sprite_x<0)
      sprite_x+=32*16;
    if(sprite_x >= 32*16)
      sprite_x-=32*16;
    if(sprite_y < 0)
      sprite_y += 32*16;
    if(sprite_y >= 32*16)
      sprite_y-=32*16;
    if(sprite_frame == 12)
      sprite_frame = 13;
    else sprite_frame = 12;

    clear_screen(virtual_screen,0);
    draw_map(viewx,viewy,virtual_screen);
    display_screen(virtual_screen);
  }

  key_untrap();

  setvmode(0x03);
  free_tiles();
}

load_tiles()
{
  char file[81],num,i,j,k;

  if(!pcx_load("tiles.pcx",virtual_screen,palette))
    return(0);

  num=0;
  for(i=0;i<4;i++) {
    for(j=0;j<10;j++) {
      if((gfx_tiles[num++] = block_clip2(virtual_screen,j*32,i*50,32,50))==NULL)
        return(0);
    }
  }

  return(1);
}

free_tiles()
{
  char i;

  for(i=0;i<40;i++)
    free(gfx_tiles[i]);
}

draw_map(signed short int x,signed short int y,char *screen)
{
  signed short int i,j,k;
  signed short int current_layer,highest_layer,next_layer,last_layer;
  signed short int mapx,mapy,mx,my,tx,ty,xo,yo,xa,ya,screenx,screeny;
  signed short int length;
  char tile_to_draw,height_to_draw;

  signed short int sprite_mx,sprite_my,spritex,spritey,xx,yy;

  current_layer = 0;
  highest_layer = 0;
  last_layer    = 0;

  sprite_mx = sprite_x / 16;
  sprite_my = sprite_y / 16;

  mapx = x / 16;
  xo   = x & 15;
  mapy = y / 16;
  yo   = y & 15;
  xa   = xo - yo;
  ya   = (xo>>1) + (yo>>1);

  while(1) {
    next_layer = 255;
    mx = mapx;
    my = mapy;
    screeny = 8 - ya;

    // normal height is 28, go higher for big objects
    for(i=0;i<38;i++) {
      tx = mx;
      ty = my;

      screenx = 16 - xa;

      length = 12;
      if(i&1) {
        length++;
        screenx-=16;
      }

      for(j=0;j<length;j++) {

        for(k=0;k<map[ty][tx].num;k++) {
          if(map[ty][tx].layer[k] == current_layer) {
            tile_to_draw = map[ty][tx].tile[k];
            height_to_draw = map[ty][tx].height[k];
            block_draw(gfx_tiles[tile_to_draw],screenx,screeny-height_to_draw,screen);
          }

          if(tx == sprite_mx && ty == sprite_my && current_layer==sprite_layer) {
            xo = sprite_x & 15;
            yo = sprite_y & 15;
            xx   = xo - yo;
            yy   = (xo>>1) + (yo>>1);
            block_draw(gfx_tiles[sprite_frame],screenx-32+xx,screeny-16+yy,screen);
          }

          if(map[ty][tx].layer[k] > highest_layer)
             highest_layer = map[ty][tx].layer[k];

          if(map[ty][tx].layer[k] < next_layer && map[ty][tx].layer[k] > last_layer)
            next_layer = map[ty][tx].layer[k];
        }

        screenx+=32;

        // map update and wrap around
        if((tx+=1) > 31)
          tx = 0;
        if((ty-=1) < 0)
          ty = 31;
      }

      screeny+=8;

      if(i & 1) {
        if((mx+=1) > 31)
          mx = 0;
      } else {
        if((my+=1) > 31)
          my = 0;
      }
    }

    last_layer = current_layer;
    // smudge to fit in sprite layer
    if(current_layer == 0)
      current_layer = 1;
    else current_layer = next_layer;

    if(current_layer > highest_layer)
      break;
  }
}

setup_map()
{
  signed short int i,j;
  char transform_map[32][32] = {
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,6,6,6,5,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,
    0,0,0,0,0,0,0,6,6,6,5,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,
    0,0,0,0,0,0,0,6,6,6,5,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,
    0,0,0,0,0,0,0,4,4,7,3,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
    0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,6,6,6,6,5,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,6,6,6,6,5,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,6,6,6,6,5,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,6,6,6,6,6,5,0,1,0,0,0,0,0,0,0,6,6,6,5,0,0,0,0,0,0,0,0,0,0,0,0,
    0,6,6,6,6,6,8,1,1,0,0,0,0,0,0,0,6,6,6,5,0,0,0,0,0,0,0,0,0,0,0,0,
    0,4,4,4,4,4,3,0,0,0,0,0,0,0,0,0,4,4,4,3,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0 };

  // transform the map into map structure
  for(i=0;i<32;i++) {
    for(j=0;j<32;j++) {
      switch(transform_map[i][j]) {
        case 0:  map[i][j].num       = 1;
                 map[i][j].tile[0]   = 0;
                 map[i][j].height[0] = 0;
                 map[i][j].layer[0]  = 0;
                 break;
        case 1:  map[i][j].num       = 1;
                 map[i][j].tile[0]   = 1;
                 map[i][j].height[0] = 0;
                 map[i][j].layer[0]  = 0;
                 break;
        case 2:  map[i][j].num       = 1;
                 map[i][j].tile[0]   = 2;
                 map[i][j].height[0] = 0;
                 map[i][j].layer[0]  = 0;
                 break;
        case 3:  map[i][j].num       = 3;
                 map[i][j].tile[0]   = 3;
                 map[i][j].height[0] = 0;
                 map[i][j].layer[0]  = 1;
                 map[i][j].tile[1]   = 4;
                 map[i][j].height[1] = 0;
                 map[i][j].layer[1]  = 1;
                 map[i][j].tile[2]   = 5;
                 map[i][j].height[2] = 43;
                 map[i][j].layer[2]  = 2;
                 break;
        case 4:  map[i][j].num       = 2;
                 map[i][j].tile[0]   = 3;
                 map[i][j].height[0] = 0;
                 map[i][j].layer[0]  = 1;
                 map[i][j].tile[1]   = 5;
                 map[i][j].height[1] = 43;
                 map[i][j].layer[1]  = 2;
                 break;
        case 5:  map[i][j].num       = 2;
                 map[i][j].tile[0]   = 4;
                 map[i][j].height[0] = 0;
                 map[i][j].layer[0]  = 1;
                 map[i][j].tile[1]   = 5;
                 map[i][j].height[1] = 43;
                 map[i][j].layer[1]  = 2;
                 break;
        case 6:  map[i][j].num       = 1;
                 map[i][j].tile[0]   = 5;
                 map[i][j].height[0] = 43;
                 map[i][j].layer[0]  = 2;
                 break;
        case 7:  map[i][j].num       = 3;
                 map[i][j].tile[0]   = 3;
                 map[i][j].height[0] = 0;
                 map[i][j].layer[0]  = 1;
                 map[i][j].tile[1]   = 10;
                 map[i][j].height[1] = 0;
                 map[i][j].layer[1]  = 1;
                 map[i][j].tile[2]   = 5;
                 map[i][j].height[2] = 43;
                 map[i][j].layer[2]  = 2;
                 break;
        case 8:  map[i][j].num       = 3;
                 map[i][j].tile[0]   = 4;
                 map[i][j].height[0] = 0;
                 map[i][j].layer[0]  = 1;
                 map[i][j].tile[1]   = 11;
                 map[i][j].height[1] = 0;
                 map[i][j].layer[1]  = 1;
                 map[i][j].tile[2]   = 5;
                 map[i][j].height[2] = 43;
                 map[i][j].layer[2]  = 2;
                 break;
      }
    }
  }
}
