/*
    Video functions      May 12, 1996

    New functions for WATCOM and BORLAND compilers.

    just use:

  #define COMPILER_WATCOM

  or

  #define COMPILER_BORLAND

  Error checks if both directives used.
*/

/*  ERROR CHECK FOR DEFINES */
#ifdef COMPILER_BORLAND
  #ifdef COMPILER_WATCOM
    #error MUST USE ONLY ONE COMPILER_ OPTION
  #endif
#else
  #ifndef COMPILER_WATCOM
    #error MUST USE COMPILER_ OPTION
  #endif
#endif

/*
  DO BORLAND STUFF
*/
#ifdef COMPILER_BORLAND

#ifndef __DOS_H
#include <dos.h>
#endif

#ifndef __STDIO_H
#include <stdio.h>
#endif

#ifndef __CONIO_H
#include <conio.h>
#endif

#ifndef __MEM_H
#include <mem.h>
#endif

// define our video screen memory region
char *gfx_screen=MK_FP(0xa000,0);

// video setting and getting functions
void setvmode(short short int video_mode);
signed short int getmode(void);

// palette setting and capturing functions
void palette_set(char *pal,signed short int num_colors,char border_color);
void palette_get(char *pal);
void set_single_color(char color_number,char r,char g,char b);

// palette fading in and out functions
void palette_fadein(char *pal,signed short int speed);
void palette_fadeout(char *pal,signed short int speed);

// set current palette colors to black or white
void black_pal(void);
void white_pal(void);

// wait for vertical retrace
void wait_vbi(void);

// set or get a graphics pixel
void pixel(signed short int x,signed short int y,char color,char *screen);
signed short int get_pixel(signed short int x,signed short int y,char *screen);

// blitting buffers, clearing buffers, copying buffers functions
void display_screen(char *screen);
void clear_screen(char *screen,char color);
void copy_screen(char *dest,char *src);


void setvmode(short short int video_mode)
{
  asm {
    mov ax,video_mode
    int 10h
  }
}

signed short int getmode(void)
{
  union REGS reg;

  reg.h.ah=0x0f;
  int86(0x10,&reg,&reg);
  return(reg.h.al);
}

void palette_set(char *pal,signed short int num_colors,char border_color)
{
  signed short int i;

  // set all colors
  outp(0x3c6,0xff);
  for(i=0;i<num_colors;++i) {
    outp(0x3c8,i);
    outp(0x3c9,(*pal++) >> 2);
    outp(0x3c9,(*pal++) >> 2);
    outp(0x3c9,(*pal++) >> 2);
  }

  // set border color
  asm {
    mov ax,0x1001
    mov bh,border_color;
    int 10h
  }
}

void palette_get(char *pal)
{
  char i;
  char _red,_green,_blue;

  for(i=0;i<256;i++) {
    asm {
      mov dx,0x3c7
      mov al,i
      out dx,al

      add dx,2

      in     al,dx
      mov    _red,al
      in     al,dx
      mov    _green,al
      in     al,dx
      mov    _blue,al
    }
    *pal++ = _red;
    *pal++ = _green;
    *pal++ = _blue;
  }
}

void set_single_color(char color_number,char r,char g,char b)
{
  asm {
    mov    dx,0x3c8
    mov    al,color_number
    out    dx,al
    inc    dx
    mov    al,r
    out    dx,al
    mov    al,g
    out    dx,al
    mov    al,b
    out    dx,al
  }
}

void palette_fadein(char *pal,signed short int speed)
{
  char pal2[768];
  signed short int i,j;
  signed short int max;

  max=256/speed;
  memset(pal2,0,768);
  for(i=0;i<max;i++) {
    for(j=0;j<768;j++) {
      if(pal2[j]+speed<pal[j])
        pal2[j]+=speed;
      else pal2[j]=pal[j];
    }
    palette_set(pal2,256,0);
  }
  palette_set(pal,256,0);
}

void palette_fadeout(char *pal,signed short int speed)
{
  char pal2[768];
  signed short int i,j;
  signed short int max;

  max=256/speed;
  memcpy(pal2,pal,768);
  for(i=0;i<max;i++) {
    for(j=0;j<768;j++) {
      if(pal2[j]>speed)
        pal2[j]-=speed;
      else pal2[j]=0;
    }
    palette_set(pal2,256,0);
  }
}

void black_pal(void)
{
  char pal[768];

  memset(pal,0,768);
  palette_set(pal,256,0);
}

void white_pal(void)
{
  char pal[768];

  memset(pal,255,768);
  palette_set(pal,256,0);
}

// Wait for vertical retrace
void wait_vbi(void)
{
  while((inp(0x3da)&8) !=0);
  while((inp(0x3da)&8) ==0);
/*
  asm mov     dx,03DAh
  vbi_1:
  asm {
    in    al,dx
    test  al,08h
    jnz   vbi_1
  }
  vbi_2:
  asm {
    in    al,dx
    test  al,08h
    jz    vbi_2
  }
*/
}

void pixel(signed short int x,signed short int y,char color,char *screen)
{
  if((unsigned short int)x<320 && (unsigned short int)y<200)
    screen[(y<<8)+(y<<6)+x]=color;
}

signed short int get_pixel(signed short int x,signed short int y,char *screen)
{
  if((unsigned short int)x<320 && (unsigned short int)y<200)
    return(screen[(y<<6)+(y<<8)+x]);
  return(-1);
}

void display_screen(char *screen)
{
  char *gscreen=MK_FP(0xa000,0);

  asm {
    push ds
    push es

    lds si,screen
    les di,gscreen
    cld
    mov cx,64000/2
    rep movsw

    pop es
    pop ds
  }
}

void clear_screen(char *screen,char color)
{
  asm {
    push es
    push di
    mov al,color
    mov ah,al
    les di,screen
    cld
    mov cx,32000
    rep stosw
    pop di
    pop es
  }
}

void copy_screen(char *dest,char *src)
{
  asm {
    push ds
    push es
    push di
    push si

    lds si,src
    les di,dest
    cld
    mov cx,64000/2
    rep movsw

    pop si
    pop di
    pop es
    pop ds
  }
}

/*
setmodex(char height)
{
  asm {
    cld
    mov ax,13h
    int 10h
    cli
    mov dx,3c4h
    mov AX,604h                    // Unchain VGA
    out dx,ax
    mov ax,0F02h                   // All planes...
    out dx,ax

    mov dx,3D4h
    mov ax,14h                     // Disable dword mode
    out dx,ax
    mov ax,0E317h                  // Enable byte mode.
    out dx,ax
    mov al,9
    out dx,al
    inc dx
    in  al,dx
    and al,0E0h
    add al,height                  // Set height of scan
    out dx,al
  }
}

{}
Procedure GetPal(Col : Byte; Var R,G,B : Byte);
  { This gets the Red, Green and Blue values of a certain color }
Var
   rr,gg,bb : Byte;
Begin
   asm
      mov    dx,3c7h
      mov    al,col
      out    dx,al

      add    dx,2

      in     al,dx
      mov    [rr],al
      in     al,dx
      mov    [gg],al
      in     al,dx
      mov    [bb],al
   end;
   r := rr;
   g := gg;
   b := bb;
end;

{}
procedure WaitRetrace; assembler;
  {  This waits for a vertical retrace to reduce snow on the screen }
label
  l1, l2;
asm
    mov dx,3DAh
l1:
    in al,dx
    and al,08h
    jnz l1
l2:
    in al,dx
    and al,08h
    jz  l2
end;
*/

#endif

/*
  DO WATCOM STUFF
*/
#ifdef COMPILER_WATCOM

#ifndef __DOS_H
#include <dos.h>
#endif

#ifndef __STDIO_H
#include <stdio.h>
#endif

#ifndef __CONIO_H
#include <conio.h>
#endif

#ifndef __MEM_H
#include <mem.h>
#endif

// define our video screen memory region
char *gfx_screen=(char*)0xa0000;

// video setting and getting functions
void setvmode(signed short int video_mode);

signed short int getmode(void);

// palette setting and capturing functions
void palette_set(char *pal,signed short int num_colors,char border_color);
void palette_get(char *pal);
void set_single_color(char color_number,char r,char g,char b);

// palette fading in and out functions
void palette_fadein(char *pal,signed short int speed);
void palette_fadeout(char *pal,signed short int speed);

// set current palette colors to black or white
void black_pal(void);
void white_pal(void);

// wait for vertical retrace
void wait_vbi(void);

// set or get a graphics pixel
void pixel(signed short int x,signed short int y,char color,char *screen);
signed short int get_pixel(signed short int x,signed short int y,char *screen);

// blitting buffers, clearing buffers, copying buffers functions
void display_screen(char *screen);
void clear_screen(char *screen,char color);
void copy_screen(char *dest,char *src);

// setvmode
#pragma aux setvmode =   \
        "int 10h"               \
	parm caller [eax];
//	modify [eax];

signed short int getmode(void)
{
  union REGS reg;

  reg.h.ah=0x0f;
  int386(0x10,&reg,&reg);
  return(reg.h.al);
}

void palette_set(char *pal,signed short int num_colors,char border_color)
{
  union REGS reg;
  signed short int i;

  // set all colors
  outp(0x3c6,0xff); //??
  for(i=0;i<num_colors;++i) {
    outp(0x3c8,i);
    outp(0x3c9,(*pal++) >> 2);
    outp(0x3c9,(*pal++) >> 2);
    outp(0x3c9,(*pal++) >> 2);
  }

  // set border color
  reg.x.eax = 0x1001;
  reg.h.bh = border_color;
  int386(0x10,&reg,&reg);
}


void palette_get(char *pal)
{
  char i;

  for(i=0;i<256;i++) {
    outp(0x3c7,i);
    *pal++ = inp(0x3c9);
    *pal++ = inp(0x3c9);
    *pal++ = inp(0x3c9);
  }
}

void set_single_color(char color_number,char r,char g,char b)
{
  outp(0x3c8,color_number);
  outp(0x3c9,r);
  outp(0x3c9,g);
  outp(0x3c9,b);
}

void palette_fadein(char *pal,signed short int speed)
{
  char pal2[768];
  signed short int i,j;
  signed short int max;

  max=256/speed;
  memset(pal2,0,768);
  for(i=0;i<max;i++) {
    for(j=0;j<768;j++) {
      if(pal2[j]+speed<pal[j])
        pal2[j]+=speed;
      else pal2[j]=pal[j];
    }
    palette_set(pal2,256,0);
  }
  palette_set(pal,256,0);
}

void palette_fadeout(char *pal,signed short int speed)
{
  char pal2[768];
  signed short int i,j;
  signed short int max;

  max=256/speed;
  memcpy(pal2,pal,768);
  for(i=0;i<max;i++) {
    for(j=0;j<768;j++) {
      if(pal2[j]>speed)
        pal2[j]-=speed;
      else pal2[j]=0;
    }
    palette_set(pal2,256,0);
  }
}

void black_pal(void)
{
  char pal[768];

  memset(pal,0,768);
  palette_set(pal,256,0);
}

void white_pal(void)
{
  char pal[768];

  memset(pal,255,768);
  palette_set(pal,256,0);
}

// Wait for vertical retrace
void wait_vbi(void)
{
  while((inp(0x3da)&8) !=0);
  while((inp(0x3da)&8) ==0);
}

void pixel(signed short int x,signed short int y,char color,char *screen)
{
  if((unsigned short int)x<320 && (unsigned short int)y<200)
    screen[(y<<8)+(y<<6)+x]=color;
}

signed short int get_pixel(signed short int x,signed short int y,char *screen)
{
  if((unsigned short int)x<320 && (unsigned short int)y<200)
    return(screen[(y<<6)+(y<<8)+x]);
  return(-1);
}

void display_screen(char *screen)
{
  memcpy(gfx_screen,screen,64000);
}

void clear_screen(char *screen,char color)
{
  memset(screen,color,64000);
}

void copy_screen(char *dest,char *src)
{
  memcpy(dest,src,64000);
}

#endif

