/***********************************************************************
Intermediate Programmer tutorial #001
Copyright (c) 1995 by Jouni Miettunen

Critical Error (0x24) handler sample program

Test what disk drives are available and what can be used to store data

***********************************************************************/

#include <dir.h>
#include <dos.h>
#include <stdio.h>

int	my_handler	( int, int, int, int		);
int	testdisk	( int				);

volatile int	int24_error;

static char	*int24_message[] = {
	"Write protect",
	"Unknown unit",
	"Drive not ready",
	"Unknown command",
	"Data error (CRC)",
	"Bad request",
	"Seek error",
	"Unknown media type",
	"Sector not found",
	"Printer out of paper",
	"Write fault",
	"Read fault",
	"General failure",
	"reserved",
	"reserved",
	"Invalid disk change"
};

/* main ***************************************************************/
/* the main program ***************************************************/
/**********************************************************************/
int main(void)
{
int	i,
//	limit = 'Z' - 'A' + 1,		// all possible disk drives
//	limit = setdisk(getdisk()),	// number of available drives
	limit = 6,			// keep it short for testing..
	result;

for (i=0; i<limit; i++) {
	result = testdisk(i);
	switch (result) {
	case -2:
		printf("Disk drive %c: does not exist.\n", i+'A');
		break;
	case -1:
		printf("Disk drive %c: ready for use.\n", i+'A');
		break;
	default:
		printf("Disk drive %c: exists, error \"%s\".\n",
			i+'A',int24_message[result]);
		break;
	}
}

return (0);

} /* int main */

#pragma argsused
/* my_handler *********************************************************/
/* my own 0x24 function ***********************************************/
/**********************************************************************/
int my_handler(
	int 	error,	// error code from DOS - _DI register
	int	ax,
	int	bp,
	int	si
	)
{

int24_error = (error & 0xff);
hardretn(2);	// abort
return (2);	// abort

} /* int my_handler */

/* testdisk ***********************************************************/
/* test if drive can be used or not ***********************************/
/**********************************************************************/
int testdisk(
	int	disk
	)
{
FILE	*fp;
int	orig_disk = getdisk();
void interrupt (*old24)();

setdisk(disk);

if (getdisk() == disk) {
	int24_error = -1;	// everything ok
	old24 = getvect(0x24);
	harderr(my_handler);
		fp = fopen("$$$$$$$$.$$$","wb");
		if (fp) {
			fclose(fp);
			remove("$$$$$$$$.$$$");
		}
	setvect(0x24,old24);
	setdisk(orig_disk);
}
else
	int24_error = -2;	// can't access drive

return(int24_error);

} /* int testdisk */

/**********************************************************************/
/*************************** A HAPPY END ******************************/
/**********************************************************************/
