// PALDEMO.C - functions for demonstrating the VGA colour palette.

// Written by Phil Inch for Game Developers Magazine (issue 3).
// Contributed to the public domain.

// This program written and compiled with Borland C++ v3.1
// Compatibility with other compilers is not guaranteed.

// Usage of this program is subject to the disclaimer printed
// in the magazine.  You assume all risks associated with the use
// of this program.

// The box drawing routine used in this demo is also explained in issue
// 3 of GDM, in the "VGA mode 13h" section.

#include <stdio.h>
#include <conio.h>
#include <time.h>
#include <dos.h>
#include <mem.h>
#include <string.h>
#include <stdlib.h>
#include "palette.h"

char far *screen=MK_FP(0xA000,0);

void	SetGraphicsMode( void ) {
	asm {
		mov	ax,0x13
    int	0x10
	  }
}

void	SetTextMode( void ) {
	asm {
  	mov	ax,0x03
    int	0x10;
    }
}

void SetPoint( int X, int Y, int C ) {
  *(screen+(Y*320)+X)=C;
}

void FastBoxDraw(int x1, int y1, int x2, int y2, int color) {
  int x,y;

  /* Top and bottom lines */
  for ( x = x1; x < x2; x++ ) {
      SetPoint( x, y1, color );
      SetPoint( x, y2, color );
      }

  /* Left and Right lines */
  for ( y = y1; y < y2; y++ ) {
      SetPoint( x1, y, color );
      SetPoint( x2, y, color );
      }
}

void main( void ) {
  int x1,y1,x2,y2,c,d;
  char savepal[768];
  char workpal[768];

  SetGraphicsMode();

  /* Save the default palette before we begin */
  GetBlockPal( 1, &(savepal[0]), 255 );

  /* This will set all colours to zero */
  memset( workpal, 0, 768 );
  SetBlockPal( 1, &(workpal[0]), 255 );

  /* Now draw some different coloured boxes.  Because we've made the
     pallete all black, we won't be able to see them yet */

  for ( d = 0; d < 500; d++ ) {
    do {
      x1 = rand()%320;
      x2 = rand()%320;
    } while ( x1 >= x2 );

    do {
      y1 = rand()%200;
      y2 = rand()%200;
    } while ( y1 >= y2 );

    c = rand()%256;

    FastBoxDraw( x1, y1, x2, y2, c );
    }

  /* Now "fade in" the image */
  FadePaletteIn( &(savepal[0]) );
  delay(1000);

  /* Set the whole palette to red */
  for ( c = 0; c < 768; c+=3 ) {
    workpal[c++] = 32;
    workpal[c++] = 0;
    workpal[c++] = 0;
    }
  SetBlockPal( 1, &(workpal[0]), 255 );
  delay(1000);

  /* Set the whole palette to green */
  for ( c = 0; c < 768; c+=3 ) {
    workpal[c++] = 0;
    workpal[c++] = 32;
    workpal[c++] = 0;
    }
  SetBlockPal( 1, &(workpal[0]), 255 );
  delay(1000);

  /* Set the whole palette to blue */
  for ( c = 0; c < 768; c+=3 ) {
    workpal[c++] = 0;
    workpal[c++] = 0;
    workpal[c++] = 32;
    }
  SetBlockPal( 1, &(workpal[0]), 255 );
  delay(1000);

  /* Restore the original palette */
  SetBlockPal( 1, &(savepal[0]), 255 );
  delay(1000);

  /* Fade out the palette */
  FadePaletteOut();
  delay(1000);

  /* Restore the original palette before we leave */
  SetBlockPal( 1, &(savepal[0]), 255 );

  SetTextMode();
}
