#ifndef JTAG_H
#define JTAG_H
#include <malloc.h>

/* common macros */
#define MALLOC(n)        malloc((unsigned)(n))
#define NEWV(type,n)     (type*)MALLOC((n)*sizeof(type))
#define FREE(p)          free((char*)p)

/* bitstream stuff */
typedef unsigned long bitstream;

bitstream *AllocBits( int NumBits );
void FreeBits( bitstream *bits );
unsigned int GetBit( bitstream *bits, int i );
void SetBit( bitstream *bits, int i, int val );
void CmpBits( int length, bitstream *b1, bitstream *b2,
          bitstream *mask, bitstream *result );
void PrintBits( bitstream *bits, int length );
void SelectPort( int PortNum );
void PortWait( void );
void SetPortDelay( int delay );
void OutToPort( int val );
int GetOutPortValue( void );
int InFromPort( void );
void SetPortBit( int bit, int val );
unsigned int GetPortBit( int bit );
void SetTMSValue( int val );
unsigned int GetTMSValue( void );
void SetTDOValue( int val );
unsigned int GetTDOValue( void );
unsigned int GetTDIValue( void );
unsigned int GetTCKValue( void );
void SetTCKValue( int val );
JTAGTraceOnOff( int OnOff );
void PulseTCK( void );
void JTAGPortInit( void );
void HardTAPReset( void );
void UpdateTAPState( void );
char *GetTAPStateText( void );
unsigned int SendRcvBit( unsigned SendBit );
void SendRcvBitstream( int length, bitstream *SendBits, bitstream *RcvBits );
void LoadBSIRthenBSDR( int BSIRLength, bitstream *instruction,
               int BSDRLength, bitstream *send, bitstream *recv );
void EPX780IDCode( bitstream *DeviceIDCode );
void EPX780UES( bitstream *UESig );
void EPX780SamplePreload( bitstream *send, bitstream *recv );
void EPX780Extest( bitstream *send, bitstream *recv );
void EPX780HighZ(void);
void EPX780Bypass(void);
void SetMacrocellDirection( bitstream *bsdr, int macrocell, int dir );
int GetMacrocellDirection( bitstream *bsdr, int macrocell );
void SetMacrocellOutput( bitstream *bsdr, int macrocell, int value );
int GetMacrocellOutput( bitstream *bsdr, int macrocell );
void SetMacrocellInput( bitstream *bsdr, int macrocell, int value );
int GetMacrocellInput( bitstream *bsdr, int macrocell );
void SetSyncCLOCK( bitstream *bsdr, int clock, int value );
int GetSyncClock( bitstream *bsdr, int clock );
void SetDedicatedInput( bitstream *bsdr, int input, int value );
int GetDedicatedInput( bitstream *bsdr, int input );

#endif
