#include <stdlib.h>
#include <stdio.h>
#include "jtag.h"

main()
    {
    int bit1, bit2;

    /* declare and create storage for the EPX780 BSDR bits */
    bitstream *bsdr = AllocBits(264);

    /* get the TAP and the TAP controller initialized */
    JTAGPortInit();
    HardTAPReset();

    /* load the BSDR storage with the contents of the EPX780 BSDR
       so we know what the current state is out there.  This
       will alter the EPX780 BSDR. */
    EPX780SamplePreload( NULL, bsdr );

    /* setup macrocell 3 (attached to pin 6) to output a logic 1 */
    SetMacrocellDirection( bsdr, 3, 1 );
    SetMacrocellOutput( bsdr, 3, 1 );

    /* setup macrocell 5 (attached to pin 7) as an input */
    SetMacrocellDirection( bsdr, 5, 0 );

    /* save the value of the output bit */
    bit1 = GetMacrocellOutput( bsdr, 3 );

    /* now reload the EPX780 BSDR with what we got out of it
       plus the modifications we just made. */
    EPX780SamplePreload( bsdr, NULL );

    /* then activate the EXTEST and shift out the result into the
       BSDR storage array */
    EPX780Extest( NULL, bsdr );

    /* now print the output from macrocell 3 and the input to
       macrocell 5 and see if they match */
    bit2 = GetMacrocellInput( bsdr, 5 );
    if( bit1==bit2 )
        printf( "%d = %d\n", bit1, bit2 );
    else
        printf( "%d != %d\n", bit1, bit2 );

    /* now force a logic 0 on the macrocell 3 output and see if it
       turns up on the macrocell 5 input */
    SetMacrocellOutput( bsdr, 3, 0 );
    bit1 = GetMacrocellOutput( bsdr, 3 );
    EPX780SamplePreload( bsdr, NULL );
    EPX780Extest( NULL, bsdr );
    bit2 = GetMacrocellInput( bsdr, 5 );
    if( bit1==bit2 )
        printf( "%d = %d\n", bit1, bit2 );
    else
        printf( "%d != %d\n", bit1, bit2 );

    /* now tristate all the EPX780 pins */
    EPX780HighZ();
    }
