;
;       FLAMER!         MULTI-PALETTE VERSION           386+ only, sorry!
;                       ---------------------
;                       by E.Vaughan May 1996
;
;       please mail any comments, etc. to: emil0@aol.com

comment *  This is public domain software. Its been done before but here is 
	   my version. Feel free to make it better if you want. Please send 
	   any comments or suggestions to my address above - I would very
	   much appreciate it if you send me any modifications you make to
	   the source code. Cheers!
	
DISCLAIMER: there is no disclaimer. If this fucks up your machine, I don't
	    care - just try and sue me... :) 
	*
;----------------------------------------------------------------------------
	 DOSSEG          
	.MODEL SMALL
	.STACK 100

.DATA

; Different palettes for the flame

RAINBOW = 1		; *** choose palette here ***

palette label word

IFDEF (NORMAL)          ; the "normal" flame palette

	db 0, 0, 0          ; set black to red
	i = 3
	rept 15
	   db i, 0, 0
	   i = i + 4
	endm
	db 63, 0, 0         ; set red to yellow
	i = 1
	rept 31
	   db 63, i, 0
	   i = i + 2
	endm
	db 63, 63, 0        ; set yellow to white
	i = 1
	rept 31
	   db 63, 63, i
	   i = i + 2
	endm
	db 528 dup (63)     ; set remaining colors to white
ENDIF

IFDEF (TESTER)     ; use this palette to see how the flame works

	db 0, 0, 0
	rept 85
	   db 63, 0, 0
	   db 0, 63, 0
	   db 0, 0, 63
	endm    
ENDIF

IFDEF (GAS1)	; I don't like this one much

	db 0, 0, 0          
	i = 1
	rept 31
	   db 0, 0, i
	   i = i + 2
	endm
	db 0, 0, 63         
	i = 3
	rept 15
	   db i, 0, 63-i
	   i = i + 4
	endm
	db 63, 0, 0        
	i = 1
	rept 31
	   db 63, i, i
	   i = i + 2
	endm
	db 528 dup (63)     
ENDIF

IFDEF (GAS2)	; some people really like this one         

	db 0, 0, 0
	i = 1
	rept 31
	   db 0, 0, i
	   i = i + 2
	endm
	i = 1
	rept 48
	   db 0, 0, 63-i
	   i = i +1
	endm
	db 528 dup (0)          ; NOTE: remaining colors set to black
ENDIF

IFDEF (GREEN)	; quite a nice palette, this one.

	db 0, 0, 0          ; set black to green                                  
	i = 1
	rept 31
	   db 0, i, 0
	   i = i + 2
	endm
	i = 1               ; set green to white
	rept 48
	   db i, 63, i
	   i = i + 1
	endm
     
	db 528 dup (63)     ; set remaining colors to white
ENDIF

IFDEF (YELLOW)		; it is what is says!        

	db 0, 0, 0
	i = 1
	rept 31
	   db i, i, 0
	   i = i + 2
	endm
	i = 1
	rept 48
	   db 63, 63, i
	   i = i +1
	endm
	db 528 dup (63) 
ENDIF

IFDEF (PURPLE)		; no comment.

	db 0, 0, 0          ; set black to purple                                  
	i = 1
	rept 31
	   db i, 0, i
	   i = i + 2
	endm
	i = 1               ; set purple to white
	rept 48
	   db 63, i, 63
	   i = i + 1
	endm
     
	db 528 dup (63)
ENDIF

IFDEF (RAINBOW)		; cool rainbow palette

	db 0, 0, 0
	i = 1
	rept 20		; set black - purple
	   db i, 0, i
	   i = i + 3
	endm 
	rept 10		; set purple - blue
	   db i, 0, 63
	   i = i - 6
	endm
	i = 1
	rept 10		; set blue - green
	   db 0, i, 63-i
	   i = i + 6
	endm
	i = 1
	rept 30		; set green - white
	   db i, 63, i
	   i = i + 2
	endm
	db 555 dup (63)
ENDIF

random_seed1    dw 0    ; used by random number generator
random_seed2    dw 0
		
message label byte        
db "Flamer! (c) E.Vaughan May 1996", 10, 10, 13
db "Please me send any comments, suggestions, cash, " 
db "credit card numbers... :)", 10, 10, 13
db "You can reach me at emil0@aol.com", 10, 10, 13, "$"

.CODE
.386    ; could be 286-, but I used 32-bit string instructions.
	; replace these with word instructions for 286- machines.

main    PROC    NEAR

start:
	mov     ax, seg @DATA   ; sort out ds segment
	mov     ds, ax
	cld

	mov     ax, 2C00h       ; set random number generator seeds
	int     21h             ; call DOS get time function
	mov     word ptr @DATA:random_seed1, cx
	mov     word ptr @DATA:random_seed2, dx
	
	xor     ax, ax          ; BOTH arrays _must_ be zeroed!!
	push    ds
	pop     es
	mov     di, offset flame_map
	mov     cx, 1536        ; this is the size of the arrays in dwords
	rep     stosd
	mov     di, offset new_flame_map
	mov     cx, 1536
	rep     stosd

	mov     ax, 0A000h
	mov     es, ax          ; set es to VGA video segment
	
	mov     ax, 0013h
	int     10h             ; switch to VGA mode 13h!
	
	mov     bx, offset palette     ; put palette name here!   
	call    set_palette

@main_loop:

	push    es
	push    ds
	pop     es              ; save es, and transfer ds to es
	
	mov     si, offset @DATA:flame_map
	add     si, 127*48+10   
	mov     cx, 12          ; number of hot_spots - changeable
	push    si              ; save a copy of si
@hot_spots_loop:
	pop     si
	push    si
	mov     bx, 28    ; determines how wide the hot-spot area is
	call    random
	add     si, ax
	mov     al, 200      ; you can change this to alter flame height
	mov     ds:[si], al
	loop    @hot_spots_loop
	pop     si                      ; sort out stack!

	mov     si, offset @DATA:flame_map
	add     si, 49
	mov     di, offset @DATA:new_flame_map
	add     di, 49
	mov     dx, 127          ; row counter
@rows1:
	mov     cx, 46          ; columns counter
@cols1:
	xor     ax, ax          ; get average of the 8 surrounding pixels
	xor     bx, bx          ; pixels are taken from one BELOW 
	mov     al, ds:[si-1]
	mov     bl, ds:[si]
	add     ax, bx
	mov     bl, ds:[si+1]
	add     ax, bx
	mov     bl, ds:[si+47]
	add     ax, bx
	mov     bl, ds:[si+49]
	add     ax, bx
	mov     bl, ds:[si+95]
	add     ax, bx
	mov     bl, ds:[si+96]
	add     ax, bx
	mov     bl, ds:[si+97] 
	add     ax, bx
	shr     ax, 3   
	mov     es:[di], al     ; es still set to ds!
	inc     si
	inc     di
	loop    @cols1
	inc     si              ; note: the outside edges are left alone.
	inc     si
	inc     di
	inc     di
	dec     dx              ; dx counts rows
	jnz     @rows1

	mov     si, offset @DATA:new_flame_map
	mov     di, offset @DATA:flame_map
	mov     cx, 1536
	rep     movsd           ; update new flames map
	pop     es              ; restore video segment 

	mov     dx, 03DAh       ; VGA port used to get retrace state

comment *	uncomment this to sync flame with vertical retrace

@retrw:
	in      al, dx
	test    al, 8
	jz      @retrw          ; wait for a vertical retrace

	*

	mov     si, offset @DATA:flame_map
	mov     di, 36*320+160-24 
	mov     bx, 127          ; row counter
@rows2:
	mov     cx, 12
	rep     movsd            ; write flame bitmap to video memory
	add     di, 272
	dec     bx
	jnz     @rows2

	in      al, 60h         ; wait until user presses escape
	cmp     al, 1
	jne     @main_loop
		
@finished:

	mov     ax, 0003h       ; return to text mode
	int     10h
		
	mov     dx, offset message  ; display message
	mov     ah, 9
	int     21h
	
	mov     ax, 0C06h
	mov     dl, 0
	int     21h             ; GOOD way of flushing keyboard buffer
				; any comments?
	
	mov     ax, 4C00h       ; terminate program
	int     21h

main    ENDP

set_palette     PROC    NEAR

	; sets VGA palette - bx holds palette image offset!
	
	push    ax cx dx si di es       ; commas may be needed with MASM
	mov     si, bx
	mov     dx, 03C6h
	mov     al, 0FFh
	out     dx, al
	inc     dx
	inc     dx
	mov     al, 0           ; start with color 0
	out     dx, al
	inc     dx
	mov     cx, 768
	rep     outsb           ; blast palette to VGA

	mov     ax, 0A000h      ; draws the palette at the top of the screen
	mov     es, ax
	xor     di, di
	mov     cx, 256
	mov     al, 0
@@loop1:
	stosb
	inc     al
	loop    @@loop1
	
	pop     es di si dx cx ax
	ret
	
set_palette     ENDP

random  PROC    NEAR    ; good random proc - sorry, I can't remember
			;       where this originated from.

	push    cx dx si di
	mov     cx, bx
	mov     ax, word ptr ds:random_seed1
	mov     bx, word ptr ds:random_seed2
	mov     si, ax
	mov     di, bx
	mov     dl, ah
	mov     ah, al
	mov     al, bh
	mov     bh, bl
	xor     bl, bl
	rcr     dl, 1
	rcr     ax, 1
	rcr     bx, 1
	add     bx, di
	adc     ax, si
	add     bx, 62E9h
	adc     ax, 3619h
	mov     word ptr ds:random_seed2, ax
	mov     word ptr ds:random_seed1, bx
	xor     dx, dx
	div     cx		; slow DIV instruction here...
	mov     ax, dx
	pop     di si dx cx
	ret

random  ENDP

.DATA

flame_map       db 6144 dup (?)       ; large arrays
new_flame_map   db 6144 dup (?)

	END     start

			*** END OF FILE ***        
