/****************************************************************************\
*                                                                            *
*  SCROLLTX.C                                                                *
*                                                                            *
*  Copyright 1993 Diana Gruber. All rights reserved.                         *
*                                                                            *
*  Scroll bitmapped text horizontally in an EGA mode. The trick to this      *
*  program is fg_transfer transfers on byte boundaries. Because a byte       *
*  boundary in mode 13 occurs every 8 pixels, to scroll horizontally in      *
*  one-pixel increments, you must have 8 copies of the text on the hidden    *
*  page.                                                                     *
*                                                                            *
*  This program scrolls one line of text, but the idea can be extended to    *
*  multiple lines of text. The font is the simple fixed-pitch bitmapped      *
*  font defined in CHAR.C. If you want better fonts, you can create your     *
*  own or use Fastgraph/Fonts.                                               *
*                                                                            *
*  See MISC.DOC for compile and link commands.                               *
*                                                                            *
\****************************************************************************/

#include "defs.h"
#include "scrolltx.h"

void main()
{

   /* initialize the video mode to 320x200x16 EGA graphics */

   init_graphics(13);

   /* draw some rectangles */

   fg_setcolor(1);
   fg_rect(0,319,0,239);
   fg_setcolor(15);
   fg_rect(24,295,15,24);
   fg_setcolor(0);
   fg_box(23,296,14,25);
   fg_waitfor(9);

   /* scroll the message across */

   scroll_status_message("The rain in Spain.");
   fg_waitkey();

   /* exit to DOS */

   quit_graphics();
}

/****************************************************************************\
*                                                                            *
*  scroll_status_message -- one pixel horizontal text scrolling              *
*                                                                            *
\****************************************************************************/

void scroll_status_message(char *message)
{
   int minx, maxx, miny;
   int newx, newy;
   register int x, y;
   int delay;

   /* clear the workspace on the hidden page */

   fg_setpage(HIDDEN);
   fg_setcolor(15);
   fg_rect(0,319,0,80);

   /* copy the message to eight positions in the workspace */

   fg_setcolor(12);
   y = 80;
   for (x = 0; x < 8; x++)
   {
      put_bstring(message,x,y);
      y -= 10;
   }

   /* scroll the message into the status area */

   delay = clockspeed / 6;

   newx = 288;
   newy = 23;

   while (newx >= 24)
   {
      flushkey();
      maxx = 295 - newx;
      for (miny = 2; miny <= 72; miny+=10)
      {
         fg_transfer(0,maxx,miny,miny+8,newx,newy,HIDDEN,VISUAL);
         fg_stall(delay);
      }
      newx -= 8;
   }

   /* scroll the message out of the status area */

   minx = 8;
   maxx = ((strlen(message)*6+7) & 0xFFF8) + 8;

   while (minx < maxx)
   {
      flushkey();
      for (miny = 2; miny <= 72; miny+=10)
      {
         fg_transfer(minx,maxx,miny,miny+8,24,newy,HIDDEN,VISUAL);
         fg_stall(delay);
      }
      minx += 8;
   }
   fg_setpage(VISUAL);
}
