/****************************************************************************\
*                                                                            *
*  GUI.C -- generic menu code                                                *
*                                                                            *
\****************************************************************************/

#include "defs.h"

void main()
{
   init_graphics(22);
   init_mouse();
   do_menu();
}

/****************************************************************************\
*                                                                            *
*  do_menu -- main menu control code                                         *
*                                                                            *
\****************************************************************************/

void do_menu()
{
   unsigned char key,aux;
   int mousex, mousey, count;
   register int i;

   xlimit = 319;
   ylimit = 239;
   redraw = TRUE;
   main_option = 0; /* this is a global value */

   /* draw the screen on the hidden page and copy it to the visual page */

   draw_screen();

   /* begin the main program loop */

   for(;;)
   {
      fg_mousevis(ON);
      fg_waitfor(2);

      /* intercept a keystroke */

      fg_intkey(&key,&aux);
      if (key == ESC)
      {
         exit_program();
         continue;
      }
      else if (aux == RIGHT_ARROW)
      {
         main_option++;
         if (main_option == ITEMS)
            main_option = 0;
      }
      else if (aux == LEFT_ARROW)
      {
         main_option--;
         if (main_option < 0)
            main_option = ITEMS - 1;
      }

      /* display menu according to keystroke pressed */

      if (key+aux > 0)
      {
         fg_mousevis(OFF);

         fg_restore(0,319,MENU_TOP,MENU_BOTTOM);
         horizontal_menu(main_menu,4,main_option);
         if (main_option == ESC)
         {
            exit_program();
            main_option = 0;
         }
         fg_mousevis(OFF);
         fg_restore(0,xlimit,MENU_TOP,ylimit);
         horizontal_menu(main_menu,-4,main_option);
         fg_mousevis(ON);
      }

      /* intercept a mouse click */

      if (mouse)
      {
         fg_mousebut(1,&count,&mousex,&mousey);
         if (count > 0 && BETWEEN(mousey,MENU_TOP,MENU_BOTTOM))
         {
            for (i = 0; i < ITEMS; i++)
            {
               if (BETWEEN(mousex, mouse_limits[i], mouse_limits[i+1]))
               {
                  fg_restore(0,319,MENU_TOP,MENU_BOTTOM);
                  if (horizontal_menu(main_menu,4,i) == ESC)
                     exit_program();
                  fg_mousevis(OFF);
                  fg_restore(0,xlimit,MENU_TOP,ylimit);
                  horizontal_menu(main_menu,-4,main_option);
                  fg_mousevis(ON);
                  break;
               }
            }
         }
      }
   }
}

/****************************************************************************\
*                                                                            *
*  draw_screen -- draw the main menu screen on the hidden page               *
*                                                                            *
\****************************************************************************/

void draw_screen()
{
   static char *string[] =
   {
      "Bunch of menu code",
      "Copyright 1992-1993 Ted Gruber Software"
   };

   /* erase the hidden page */

   fg_mousevis(0);
   fg_setpage(HIDDEN);
   fg_erase();

   /* draw some rectangles */

   fg_setcolor(white);
   fg_rect(0,xlimit,0,ylimit);
   fg_setcolor(red);
   fg_rect(0,xlimit,0,12);
   fg_setcolor(blue);
   fg_rect(0,xlimit,25,ylimit);
   fg_setcolor(black);
   fg_rect(0,xlimit,12,12);
   fg_rect(0,xlimit,24,24);

   /* main menu title */

   fg_setcolor(black);
   center_bstring(string[0],0,317,7);
   fg_setcolor(white);
   center_bstring(string[0],0,319,8);

   /* copyright notice at bottom of screen */

   fg_setcolor(black);
   center_bstring(string[1],0,317,236);
   fg_setcolor(white);
   center_bstring(string[1],0,319,237);

   fg_setpage(VISUAL);
   fg_restore(0,xlimit,0,ylimit);
   horizontal_menu(main_menu,-4,main_option);
}

char infile[13];
char outfile[13];
char otherfile[13];

/****************************************************************************\
*                                                                            *
*  load_files -- enter strings for file names                                *
*                                                                            *
\****************************************************************************/

load_files()
{
   register int i,j;
   int y;
   int current;
   char string[13];

   static char *string1[] = {
      "      Enter file names",
      " ",
      "Input file:",
      "Output file:",
      "Other file:",
      " ",
      "      Press F10 to start"
   };

   static char *string2[] = {infile,outfile,otherfile};
   static int y1[] = {90,100,110};

   /* put your own stuff in here */

   strcpy(infile,"infile.dat");
   strcpy(outfile,"outfile.dat");
   strcpy(otherfile,"other.dat");

   fg_mousevis(0);
   fg_setcolor(blue);
   fg_rect(0,319,25,199);

   fg_setcolor(black);
   fg_rect(0,319,24,24);

   fg_setcolor(white);
   fg_rect(32,288,55,145);
   fg_setcolor(black);
   fg_box(32,288,55,145);

   y = 70;
   for (i = 0; i < 7; i++)
   {
      put_bstring(string1[i],60,y);
      y+= 10;
   }

   for (i = 0; i < 3; i++)
   {
      put_bstring(string2[i],180,y1[i]);
   }

   current = 0;

   for(;;)
   {
      strcpy(string,string2[current]);
      fg_setcolor(blue);
      j = get_field(string,180,y1[current],12,0,0);

      if (j == ESC)
      {
         fg_setcolor(blue);
         fg_rect(0,319,25,199);
         redraw = TRUE;
         return(OK);
      }
      if (j == UP_ARROW || j == DOWN_ARROW || j == ENTER)
      {
         strcpy(string2[current],string);
         fg_setcolor(white);
         fg_rect(180,287,y1[current]-9,y1[current]);
         fg_setcolor(black);
         put_bstring(string2[current],180,y1[current]);
      }

      /* next field */

      if (j == DOWN_ARROW)
      {
         current++;
         if (current > 2)
            current = 0;
      }

      /* previous field */

      else if (j == UP_ARROW)
      {
         current--;
         if (current < 0)
            current = 2;
      }
      else if (j == F10)
         break;
   }

   /* check and see if the file exists */

   if (!file_exists(infile))
   {
      fg_setcolor(white);
      fg_rect(33,287,56,144);
      fg_setcolor(black);
      center_bstring("file not found",33,287,100);
      fg_waitkey();
      fg_setcolor(blue);
      fg_rect(0,319,25,199);
      redraw = TRUE;
      return(OK);
   }

   /* clear the screen and return */

   fg_setcolor(blue);
   fg_rect(0,319,25,239);
   redraw = TRUE;
   return(OK);
}



