#include "gui.h"
#include "char.h"
#include "common.h"
#include "menu.h"
#include <fastgraf.h>

#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <io.h>
#ifdef __TURBOC__
   #include <alloc.h>
#else
   #include <malloc.h>
#endif

#define BETWEEN(x,a,b) ((x >= a) && (x <= b))
#define MAX(x,y) ((x) > (y)) ? (x) : (y)
#define MIN(x,y) ((x) < (y)) ? (x) : (y)

#define OFF   0
#define ON    1

#define ERR  -1
#define OK    1

#define FALSE 0
#define TRUE  1

#define VISUAL 0
#define HIDDEN 1

#ifndef common_c
   #define DECLARE extern
   extern int redraw;
   extern int mouse_limits[5];
#else
   #define DECLARE
   int redraw = TRUE;
   int mouse_limits[5] = {2,80,160,240,320};
#endif

DECLARE int clockspeed;
DECLARE int stall_time;
DECLARE int background;
DECLARE int old_mode;

DECLARE int white;
DECLARE int black;
DECLARE int blue;
DECLARE int dkblue;
DECLARE int grey;
DECLARE int red;

DECLARE int buttons;
DECLARE int mouse;
DECLARE int xlimit, ylimit;
DECLARE int xmouse, ymouse;
DECLARE int main_option;

#define MENU_TOP    13
#define MENU_BOTTOM 24

#define BS     8
#define ENTER 13
#define ESC   27
#define SPACE 32
#define F10   68
#define CR          13
#define SPACEBAR    32

#define UP_ARROW    72
#define LEFT_ARROW  75
#define RIGHT_ARROW 77
#define DOWN_ARROW  80

#define CTRL_LEFT_ARROW  115
#define CTRL_RIGHT_ARROW 116

#define HOME        71
#define PGUP        73
#define END         79
#define PGDN        81

#define INSERT      82
#define DELETE      83

#define BACKGROUND   0
#define FOREGROUND   1

#define F1          59
#define F2          60
#define F3          61
#define F4          62
#define F5          63
#define F6          64
#define F7          65
#define F8          66
#define F9          67
#define F10         68

/* stuff for menu operation */

typedef int (*PFI)();   /* pointer to an integer function */

#define ITEMS 4         /* number of items on main menu */

/* command structure */

typedef struct cmd
{
   PFI menu_func;       /* function to carry out the command */
   char *menu_item;     /* the menu item as written on the screen */
   int x1;              /* coordinates of location of menu_item */
   int x2;
   int next;
   int prev;
}  CMD;

extern CMD main_menu[4];
