/*
	The Forgotten Realms demo-Ba (DEMOB.ZIP)

	Derived from the Minimalist Group: "Wars in Darkness" alpha Coding
	and from the still alpha-version (and currently shelved) "Historical Wars".
	Stripped and hacked.

	Written/Edited/Drawn,etc by Lewis Sellers, Copyright (c) 1994

	Coding note 6/8/94:
	Yea, well, the coding could use a lot of reworking now that I know
	exactly what it's supposed to do :) and that'd speed it up a lot.
	It'd also help if I rewrote the whole thing in 386 protected linear
	assembly code too!! But am I goin'a do it?  Not very likely unless
	someone want's to "sponser" the endevour! =)
*/

#pragma option -1		//generate 80186 code
#pragma option -G   	//optimize for speed
#pragma option -mc  	//compact memory model
#pragma option -O    //optimize jumps
#pragma option -K	 	//signed int
#pragma option -k-	//no standard stack
#pragma option -N-	//no over-stack logic
#pragma option -v-   //no debugging info for hackers to sniff (yea. right!)
/* but seriously, DO set the debugger to OFF before compiling anything
	for public distribution. don't want to make it TOO easy. :-) */
#pragma option -y-   //like so. sparse debug info here.

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <direct.h>
#include <process.h>
#include <time.h>
#include <conio.h>
#include <string.h>
#include <malloc.h>

#define MOUSE_BIOS 0x33
#define VIDEO_BIOS 0x10
#define EMS_BIOS 	 0x67

#define FALSE 0
#define TRUE 1

#define LEFT	0
#define RIGHT	1

#define PALETTE_SIZE 768

typedef unsigned char byte;
typedef unsigned int word;

extern unsigned char _osmajor; /* ask what dos version we're running under */
extern unsigned char _osminor;

/* hardware detection */
byte mouse=FALSE;
byte printcolor,printsfx;
word mousex,mousey;

/* global countdown */
int countdown=0;
int frame=0,framedir=1;
word clouds,stars,moon,tfrs,tfrsnode,castle,nuke; // malloc handle names for intro section

/* data areas for pictures */
unsigned char *palette;
char *background;
char *foreground;
char *buffer;
char *interground;
char *alphanumerics;
char *bigalphanumerics;
char *icons;
char *flags;
word emsseg;

/* constants for alphanumerics */
#define MATTE	0
#define FLAT 	1
#define SHADOW 2
#define WHITE	0
#define GREEN	13
#define RED 	14
#define GOLD 	15

/* prototypes */
getlines();

/* -------------------------------------------- */
/* video functions follow */
void vgascreen()
{
	word n;
	union REGS regs;
	struct SREGS segregs;
	unsigned char *p;

	/* to 320x200 256 color mode 13h */
	regs.x.ax=0x13;
	int86(VIDEO_BIOS,&regs,&regs);

	/* black out the palette */
	outp(0x3c6,0xff);
	for(n=0;n<256;++n) {
		outp(0x3c8,n);
		outp(0x3c9,0);
		outp(0x3c9,0);
		outp(0x3c9,0);
	}
}


void textscreen()
{
	union REGS regs;

	regs.x.ax = 0x3;
	int86(VIDEO_BIOS,&regs,&regs);
}

void blankpalette()
{
	register n;

	outp(0x3c6,0xff);
	for(n=0;n<256;++n) {
		outp(0x3c8,n);
		outp(0x3c9,0);
		outp(0x3c9,0);
		outp(0x3c9,0);
	}
}

void fadein()
{
	word n,i;
	unsigned char *p,*pal;

	pal=(unsigned char *)malloc(768);
	for(i=63;i!=0;i--) {
		for (n=0;n<PALETTE_SIZE;n++) {
			pal[n]=palette[n]-i;
			if(pal[n]>63) pal[n]=0;
		}
		p=pal;
		outp(0x3c6,0xff);
		for(n=0;n<256;++n) {
			outp(0x3c8,n);
			outp(0x3c9,(*p++));
			outp(0x3c9,(*p++));
			outp(0x3c9,(*p++));
		}
	}
	free(pal);
}


void whiteout()
{
	word n,i;
	unsigned char *p,*pal;

	pal=(unsigned char *)malloc(768);
	for(n=0;n<768;n++) pal[n]=palette[n];
	for(i=0;i<64;i++) {
		p=pal;
		outp(0x3c6,0xff);
		for(n=0;n<256;++n) {
			outp(0x3c8,n);
			outp(0x3c9,(*p++));
			outp(0x3c9,(*p++));
			outp(0x3c9,(*p++));
		}
		for (n=0;n<PALETTE_SIZE;n++) {
			if(pal[n]<63) pal[n]++;
		}
	}
	free(pal);
}


void whitein()
{
	word n,i;
	unsigned char *p,*pal;

	pal=(unsigned char *)malloc(768);
	for(n=0;n<768;n++) pal[n]=63;

	for(i=63;i!=0;--i) {
		for (n=0;n<PALETTE_SIZE;n++) {
			if(palette[n]+i<64) pal[n]=palette[n]+i;
		}
		p=pal;
		outp(0x3c6,0xff);
		for(n=0;n<256;++n) {
			outp(0x3c8,n);
			outp(0x3c9,(*p++));
			outp(0x3c9,(*p++));
			outp(0x3c9,(*p++));
		}
	}
	free(pal);
}

void fadeout()
{
	word n,i;
	unsigned char *p,*pal;

	pal=(unsigned char *)malloc(768);
	for(n=0;n<768;n++) pal[n]=palette[n];

	for(i=0;i<64;i++) {
		for (n=0;n<768;n++) {
			if(pal[n]!=0) --pal[n];
		}
		p=pal;
		outp(0x3c6,0xff);
		for(n=0;n<256;++n) {
			outp(0x3c8,n);
			outp(0x3c9,(*p++));
			outp(0x3c9,(*p++));
			outp(0x3c9,(*p++));
		}
	}
	free(pal);
}

/* changes to palette intensity -/+64 points. */
void lightlevel(int level)
{
	word n;
	byte *pal,*p;

	pal=(char *)malloc(768);
	for (n=0;n<576;n++) {
		pal[n]=palette[n]+level;
		if((signed char)palette[n]+level<0) pal[n]=0;
		if((signed char)palette[n]+level>63) pal[n]=63;
	}
	p=pal;
	outp(0x3c6,0xff);
	for(n=0;n<192;++n) { // change only palette colors 0 to 192
		outp(0x3c8,n);    // leave last 64 alone cause they're used for
		outp(0x3c9,(*p++)); // the oscillating colors of the eye and
		outp(0x3c9,(*p++));  //logo :)
		outp(0x3c9,(*p++));
	}
	free(pal);
}


void blackletters()
{
	word n;

	outp(0x3c6,0xff);
	for(n=720;n<768;n++) {
		outp(0x3c8,n);
		outp(0x3c9,0);
		outp(0x3c9,0);
		outp(0x3c9,0);
	}
}

void flashletters()
{
	word n;

	outp(0x3c6,0xff);
	for(n=720;n<768;n++) {
		outp(0x3c8,n);
		outp(0x3c9,255);
		outp(0x3c9,255);
		outp(0x3c9,255);
	}
}

/* makes the top 16 colors cycle, giving a scintillating effect to big words */
void scintillateletters()
{
	register n;
	byte red,green,blue;

	outp(0x3c6,0xff);
	outp(0x3c8,239);
	for(n=239;n<256;n++) {
		outp(0x3c9,palette[n*3]);
		outp(0x3c9,palette[n*3+1]);
		outp(0x3c9,palette[n*3+2]);
	}
	red=palette[720];
	green=palette[721];
	blue=palette[722];
	for(n=720;n<768;n++) palette[n]=palette[n+3];
	palette[765]=red;
	palette[766]=green;
	palette[767]=blue;
}


/* pulsate the red-eye of Sauron, the Darklord */
void redeye()
{
	register n;
	word pseg,poff; //the palette!

	pseg=FP_SEG(palette)+(FP_OFF(palette)>>4);
	poff=FP_OFF(palette)&0xf;

	outp(0x3c6,0xff);
	outp(0x3c8,208);
	for(n=208;n<224;n++) {
		outp(0x3c9,palette[n*3]);
		outp(0x3c9,palette[n*3+1]);
		outp(0x3c9,palette[n*3+2]);
	}
	if(--countdown<0) countdown=15;
	if((countdown&8)) {
		asm {
			push ds
			push si
			mov ds,pseg
			mov si,poff
			add si,624
			mov cx,15
			mov bh,[si]
			mov dl,[si+1]
			mov dh,[si+2]
		}
pre:	 asm {
			mov al,[si+3]
			mov ah,[si+4]
			mov bl,[si+5]
			mov [si],al
			mov [si+1],ah
			mov [si+2],bl
			add si,3
			loop pre
			mov [si],bh
			mov [si+1],dl
			mov [si+2],dh
			pop si
			pop ds
		}
	}
	if(!(countdown&8)) {
		asm {
			push ds
			push si
			mov ds,pseg
			mov si,poff
			add si,669
			mov cx,15
			mov bh,[si]
			mov dl,[si+1]
			mov dh,[si+2]
		}
preu:	asm {
			mov al,[si-3]
			mov ah,[si-2]
			mov bl,[si-1]
			mov [si],al
			mov [si+1],ah
			mov [si+2],bl
			sub si,3
			loop preu
			mov [si],bh
			mov [si+1],dl
			mov [si+2],dh
			pop si
			pop ds
		}
	}
}


/* ---------------------------------------------------------------- */
/* copy background buffer to VGA screen */
void buffertovga()
{
	word bseg,boff;

	bseg=FP_SEG(buffer)+(FP_OFF(buffer)>>4);
	boff=FP_OFF(buffer)&0xf;
	asm {
		push ds
		push es
		push si
		push di
		mov ds,bseg
		mov si,boff
		mov ax,0xa000
		mov es,ax
		mov di,0
		mov cx,0x7d00
		rep movsw
		pop di
		pop si
		pop es
		pop ds
	}
}

/* copy foreground buffer to VGA screen */
void foretovga()
{
	word foreseg,foreoff;

	foreseg=FP_SEG(foreground)+(FP_OFF(foreground)>>4);
	foreoff=FP_OFF(foreground)&0xf;
	asm {
		push ds
		push es
		push si
		push di
		mov ds,foreseg
		mov si,foreoff
		mov ax,0xa000
		mov es,ax
		mov di,0
		mov cx,0x7d00
		rep movsw
		pop di
		pop si
		pop es
		pop ds
	}
}


/* copy background buffer to VGA screen */
void backtovga()
{
	word backseg,backoff;

	backseg=FP_SEG(background)+(FP_OFF(background)>>4);
	backoff=FP_OFF(background)&0xf;
	asm {
		push ds
		push es
		push si
		push di
		mov ds,backseg
		mov si,backoff
		mov ax,0xa000
		mov es,ax
		mov si,0
		mov cx,0x7d00
		rep movsw
		pop di
		pop si
		pop es
		pop ds
	}
}

/* copy screen to foreground ie the castle mask After we update it with
	alphanumerics and icons. used only once. */ /* copy VGA to foreground */
void vgatofore()
{
	word foreseg,foreoff;

	foreseg=(FP_SEG(foreground))+(FP_OFF(foreground)>>4);
	foreoff=FP_OFF(foreground)&0xf;
	asm {
		push ds
		push es
		push si
		push di
		mov es,foreseg
		mov di,foreoff
		mov ax,0xa000
		mov ds,ax
		mov si,0
		mov cx,0x7d00
		rep movsw
		pop di
		pop si
		pop es
		pop ds
	}
}


void starstobuffer()
{
	word bseg,boff;
	word backseg,backoff;

	bseg=(FP_SEG(buffer))+(FP_OFF(buffer)>>4);
	boff=FP_OFF(buffer)&0xf;
	backseg=(FP_SEG(background))+(FP_OFF(background)>>4);
	backoff=FP_OFF(background)&0xf;
	asm {
		push ds
		push es
		push si
		push di
		mov ds,backseg
		mov si,backoff
		mov es,bseg
		mov di,boff
		mov cx,0x7d00
		rep movsw
		pop di
		pop si
		pop es
		pop ds
	}
}


/* shifts the stars/cloud right */
void shiftstars()
{
	word backseg,backoff;

	backseg=(FP_SEG(background))+(FP_OFF(background)>>4);
	backoff=FP_OFF(background)&0xf;
	asm {
		push ds
		push es
		push si
		push di
		mov ds,backseg
		mov si,backoff
		mov es,backseg
		mov di,backoff
		add si,318
		add di,319
		mov cx,200
	}
s0: asm {
		mov ah,[di]
		push si
		push di
		push cx
		std
		mov cx,319
		rep movsb
		pop cx
		pop di
		pop si
		cld
		mov [di-319],ah
		add si,320
		add di,320
		loop s0
		pop di
		pop si
		pop es
		pop ds
	}
}

/* shifts the stars/cloud left. ie. shift the background left one pixel. */
void shiftclouds()
{
	word backseg,backoff;

	backseg=(FP_SEG(background))+(FP_OFF(background)>>4);
	backoff=FP_OFF(background)&0xf;
	asm {
		push ds
		push es
		push si
		push di
		mov ds,backseg
		mov si,backoff
		inc si
		mov es,backseg
		mov di,backoff
		mov cx,200
	}
s0: asm {
		mov ah,[di]
		push si
		push di
		push cx
		mov cx,159
		rep movsw
		movsb
		pop cx
		pop di
		pop si
		mov [di+319],ah
		add si,320
		add di,320
		loop s0
		pop di
		pop si
		pop es
		pop ds
	}
}



/* put up the logo/moon,etc nice and quick like */
void interpantobuffer(int pan)
{
	word iseg,ioff;
	word bseg,boff;

	if(pan>199) pan=199;
	if(pan<-199) pan=-199;
	iseg=FP_SEG(interground)+(FP_OFF(interground)>>4);
	ioff=FP_OFF(interground)&0xf;
	bseg=FP_SEG(buffer)+(FP_OFF(buffer)>>4);
	boff=FP_OFF(buffer)&0xf;
	if(pan>=0) {
		asm {
			push ds
			push es
			push si
			push di
			mov ds,iseg
			mov si,ioff
			mov es,bseg
			mov di,boff

			mov ax,320
			mov cx,pan
			mul cx
			add di,ax

			mov cx,200
			sub cx,pan
			mov ax,320
			mul cx
			xchg cx,ax
		}
p2: asm {
			mov al,[si]
			cmp al,0
			je p3
			mov es:[di],al
		}
p3: asm {
			inc si
			inc di
			loop p2

			pop di
			pop si
			pop es
			pop ds
		}
	}
	else {
		asm {
			push ds
			push es
			push si
			push di
			mov ds,iseg
			mov si,ioff
			mov es,bseg
			mov di,boff

			mov cx,pan
			neg cx
			mov pan,cx

			mov cx,pan
			mov ax,320
			mul cx
			add si,ax

			mov cx,200
			sub cx,pan
			mov ax,320
			mul cx
			xchg cx,ax
		}
n2: 	asm {
			mov al,[si]
			cmp al,0
			je n3
			mov es:[di],al
		}
n3:	asm {
			inc si
			inc di
			loop n2

			pop di
			pop si
			pop es
			pop ds
		}
	}
}



void flagwaving()
{
	word n;
	union REGS regs;
	word fseg,foff; //foreground castle
	word flseg,floff; //flags
	int fram=frame;


	fseg=FP_SEG(foreground)+(FP_OFF(foreground)>>4);
	foff=FP_OFF(foreground)&0xf;
	flseg=FP_SEG(flags)+(FP_OFF(flags)>>4);
	floff=FP_OFF(flags)&0xf;
	/* now put the flag up proper to the castle mask */
	if((frame<10)&&(frame>=4)) { //the flag A on the left
		asm {
			push ds
			push es
			push si
			push di

			mov ds,flseg
			mov si,floff
			add si,0x0000
			mov ax,fram
			sub ax,4
			mov bx,32
			mul bx
			add si,ax

			mov es,fseg
			mov di,foff
			add di,15756	//49y 76x
			mov cx,20
		}
flA:	asm {
			push si
			push di
			push cx
			mov cx,12
			rep movsb
			pop cx
			pop di
			pop si
			add si,320
			add di,320
			loop flA

			pop di
			pop si
			pop es
			pop ds
		}
	}
	if((frame<6)&&(frame>=0)) { //the flag B on the right
		asm {
			push ds
			push es
			push si
			push di

			mov ds,flseg
			mov si,floff
			add si,0xb
			mov ax,fram
			mov bx,32
			mul bx
			add si,ax

			mov es,fseg
			mov di,foff
			add di,10816	//33y 256x
			mov cx,30
		}
flB:	asm {
			push si
			push di
			push cx
			mov cx,16
			rep movsb
			pop cx
			pop di
			pop si
			add si,320
			add di,320
			loop flB

			pop di
			pop si
			pop es
			pop ds
		}
	}
	frame+=framedir;
	if(frame>10) framedir=-1;
	if(frame<-20) framedir=1;
}



void backtobuffer()
{
	word bgseg,bgoff; //background
	word bseg,boff; //buffer

	bseg=FP_SEG(buffer)+(FP_OFF(buffer)>>4);
	boff=FP_OFF(buffer)&0xf;
	bgseg=FP_SEG(background)+(FP_OFF(background)>>4);
	bgoff=FP_OFF(background)&0xf;
	asm { //copy clouds/background to buffer
		push es
		push di
		push ds
		push si
		mov ds,bgseg
		mov si,bgoff
		mov es,bseg
		mov di,boff
		mov cx,0x7d00
		rep movsw
		pop si
		pop ds
		pop di
		pop es
	}
}


/* code to put the cloud/stars overtop the castle mask */
void mattebuffertovga()
{
	word bseg,boff; //buffer
	word fseg,foff; //background

	bseg=FP_SEG(buffer)+(FP_OFF(buffer)>>4);
	boff=FP_OFF(buffer)&0xf;
	fseg=FP_SEG(foreground)+(FP_OFF(foreground)>>4);
	foff=FP_OFF(foreground)&0xf;
	asm {
		push ds
		push es
		push si
		push di

		mov ds,fseg
		mov si,foff

		mov ax,0xa000
		mov es,ax
		mov di,0

		mov bx,bseg
		mov dx,boff

		mov cx,0xc800
	}
in0: asm {
		mov al,[si]
		cmp al,0
		jne in1

		push ds
		push si
		mov ds,bx
		mov si,dx
		mov al,[si]
		pop si
		pop ds
	}
in1: asm {
		mov es:[di],al
		inc si
		inc di
		inc dx
		loop in0
		pop di
		pop si
		pop es
		pop ds
	}
}

/* code to put the castle foreground over the cloud/stars buffer */
void matteforetobuffer()
{
	word bseg,boff; //buffer
	word fseg,foff; //background

	bseg=FP_SEG(buffer)+(FP_OFF(buffer)>>4);
	boff=FP_OFF(buffer)&0xf;
	fseg=FP_SEG(foreground)+(FP_OFF(foreground)>>4);
	foff=FP_OFF(foreground)&0xf;
	asm {
		push ds
		push es
		push si
		push di

		mov ds,fseg
		mov si,foff
		mov es,bseg
		mov di,boff
		mov cx,0xfa00
	}
in0: asm {
		mov al,[si]
		cmp al,0
		je in1
		mov es:[di],al
	}
in1: asm {
		inc si
		inc di
		loop in0
		pop di
		pop si
		pop es
		pop ds
	}
}

void matteintertobuffer(int pan)
{
	word bseg,boff; //buffer
	word iseg,ioff;

	if(pan>199) pan=199;
	if(pan<0) pan=0;
	bseg=FP_SEG(buffer)+(FP_OFF(buffer)>>4);
	boff=FP_OFF(buffer)&0xf;
	iseg=FP_SEG(interground)+(FP_OFF(interground)>>4);
	ioff=FP_OFF(interground)&0xf;
	asm {
		push ds
		push es
		push si
		push di

		mov ds,iseg
		mov si,ioff
		mov es,bseg
		mov di,boff

		mov ax,320
		mov cx,pan
		mul cx
		add di,ax

		mov cx,200
		sub cx,pan
		mov ax,320
		mul cx
		xchg cx,ax
	}
in0: asm {
		mov al,[si]
		cmp al,0
		je in1
		mov es:[di],al
	}
in1: asm {
		inc si
		inc di
		loop in0
		pop di
		pop si
		pop es
		pop ds
	}
}


/* the intro sequence with the castle and flags in the breeze */
void starrycastle()
{
	backtobuffer();
	flagwaving();
	mattebuffertovga();
	shiftstars();
	redeye();
}

/* the intro sequence with the castle and flags in the breeze */
void starrycastleoverlogo(int pan)
{
	backtobuffer(); //prep the buffer a cloud/star background
	interpantobuffer(pan); // put the panned interground logo onto the buffer
	scintillateletters();
	flagwaving();
	mattebuffertovga();
	scintillateletters();
	shiftstars();
	scintillateletters();
	redeye();
}

/* fast nuke the castle */
void nukestarrycastle(int pan)
{
	backtobuffer(); //prep the buffer a cloud/star background
	interpantobuffer(pan); // put the panned interground logo onto the buffer
	flagwaving();
	mattebuffertovga();
	shiftstars();
}


/* the intro sequence with the castle and flags in the breeze */
void windycastle()
{
	backtobuffer();
	flagwaving();
	mattebuffertovga();
	shiftclouds();
	redeye();
}


/* the intro sequence with the castle and flags in the breeze */
void windycastleoverlogo(int pan)
{
	backtobuffer(); //prep the buffer a cloud/star background
	interpantobuffer(pan); // put the panned interground logo onto the buffer
	scintillateletters();
	flagwaving();
	mattebuffertovga();
	scintillateletters();
	shiftclouds();
	scintillateletters();
	redeye();
}


/* the intro sequence with the castle and flags in the breeze */
void logooverwindycastle(int pan)
{
	backtobuffer(); // put the star/cloud background in the buffer
	scintillateletters();
	flagwaving(); //prep for next by changing flags in foreground
	matteforetobuffer();  // now matte the foreground to the buffer
	matteintertobuffer(pan);  //now matte the logo onto the buffer
	buffertovga(); //now copy the buffer to the vga screen
	scintillateletters();
	shiftclouds();
	scintillateletters();
	redeye();
}

/* fast nuke the castle */
void nukewindycastle(int pan)
{
	backtobuffer(); //prep the buffer a cloud/star background
	interpantobuffer(pan); // put the panned interground logo onto the buffer
	flagwaving();
	mattebuffertovga();
	shiftclouds();
}



/* --- */
makestarfield()
{
	FILE *source;
	union REGS regs;
	word handle;
	word n;
	int x,y;

	regs.h.ah=0x43;
	regs.x.bx=4;
	int86(EMS_BIOS,&regs,&regs);
	handle=regs.x.dx;
	if(regs.h.ah!=0) return 2;
	for(n=0;n<4;n++) {
		regs.h.ah=0x44;
		regs.h.al=n;
		regs.x.bx=n;
		regs.x.dx=handle;
		int86(EMS_BIOS,&regs,&regs);
	}

	asm { // clear-cls the EMS frame buffer
		push es
		push di
		mov es,emsseg
		mov di,0
		mov ax,0
		mov cx,0x7d00
		rep stosw
		pop di
		pop es
	}

	/* display all the stars */
	for(n=0;n<50000;n++) {
		x=(rand()%320);
		y=(rand()%200);
		asm {
			push es
			push di
			mov es,emsseg
		}
sf0:	asm {
			mov ax,y
			mov bx,320
			mul bx
			add ax,x
			mov di,ax
			mov al,es:[di]
			inc al
			cmp al,6
			jne sfn
			mov al,3
			mov es:[di+1],al
			mov es:[di-1],al
			mov es:[di-320],al
			mov es:[di+320],al
			mov al,13
		}
sfn:	asm {
			mov es:[di],al
			pop di
			pop es
		}
	}
	return handle;
}


/* ----------------------------------------------------------------- */
/**** mousey functions follow *****/
showmouse()
{
	union REGS regs;

	regs.x.ax = 1;
	int86(MOUSE_BIOS,&regs,&regs);
	return 0;
}

hidemouse()
{
	union REGS regs;

	regs.x.ax = 2;
	int86(MOUSE_BIOS,&regs,&regs);
	return 0;
}

/* since the computer will get to the next menu before clumsy human
fingers get off the mouse button...wait on them */
void waitonfingers()
{
	unsigned int button;
	union REGS regs;

	do {
		regs.x.ax = 3;
		int86(MOUSE_BIOS,&regs,&regs);
	} while (regs.x.bx!=0);
}

/* check and see if anyone wants out! */
int pressed()
{
	int option=FALSE;
	union REGS regs;

	if(kbhit()) { //check to see if key was pressed
		getch();
		option=TRUE;
	}

	regs.x.ax=3; // check to see if mouse button was pressed
	int86(MOUSE_BIOS,&regs,&regs);
	if (regs.x.bx!=0) {
		option=TRUE;
		waitonfingers();
	}
	return option;
}




/* ------------------------------------------------------------------ */
/*   */
void printchar(int x,int y,char c)
{
	word aseg,aoff;

	aseg=FP_SEG(alphanumerics)+(FP_OFF(alphanumerics)>>4);
	aoff=FP_OFF(alphanumerics)&0xf;
	if(printsfx==1) {
		asm {
			push ds
			push es
			mov dl,printcolor
			mov cl,4
			shl dx,cl
			mov ax,0xa000
			mov es,ax
			mov ax,320
			mov bx,y
			push dx
			mul bx
			pop dx
			add ax,x
			mov di,ax
			mov ax,aseg
			mov ds,ax
			mov si,aoff
			mov bl,c
			sub bl,32
			cmp bl,96
			jb c96
			mov bl,0
		}
c96: asm {
			mov al,80
			mul bl
			add si,ax
			mov cx,10
		}
c1: asm {
			push cx
			push di
			mov cx,8
			rep movsb
			pop di
			pop cx
			add di,320
			loop c1
			pop es
			pop ds
		}
	}

	if(printsfx==2) {
		asm {
			push ds
			push es
			mov dl,printcolor
			mov cl,4
			shl dx,cl
			mov ax,0xa000
			mov es,ax
			mov ax,320
			mov bx,y
			push dx
			mul bx
			pop dx
			add ax,x
			add ax,321
			mov di,ax
			mov ax,aseg
			mov ds,ax
			mov si,aoff
			mov bl,c
			sub bl,32
			cmp bl,96
			jb s96
			mov bl,0
		}
s96: asm {
			mov al,80
			mul bl
			add si,ax
			mov cx,10
		}
s1: asm {
			push cx
			push di
			mov cx,8
		}
s0: asm {
			lodsb
			cmp al,0
			je s2
			add al,dl
			sub al,8
			mov es:[di],al
		}
s2: asm {
			inc di
			loop s0
			pop di
			pop cx
			add di,320
			loop s1
			pop es
			pop ds
		}
	}

	if((printsfx==0)||(printsfx==2)) {
		asm {
			push ds
			push es
			mov dl,printcolor
			mov cl,4
			shl dx,cl
			mov ax,0xa000
			mov es,ax
			mov ax,320
			mov bx,y
			push dx
			mul bx
			pop dx
			add ax,x
			mov di,ax
			mov ax,aseg
			mov ds,ax
			mov si,aoff
			mov bl,c
			sub bl,32
			cmp bl,96
			jb m96
			mov bl,0
		}
m96: asm {
			mov al,80
			mul bl
			add si,ax
			mov cx,10
		}
m1: asm {
			push cx
			push di
			mov cx,8
		}
m0: asm {
			lodsb
			cmp al,0
			je m2
			add al,dl
			mov es:[di],al
		}
m2: asm {
			inc di
			loop m0
			pop di
			pop cx
			add di,320
			loop m1
			pop es
			pop ds
		}
	}
}



/* routines to display characters and character strings */
void printline(int x,int y,char *text)
{
	word n;
	byte c;

	for(n=0;n<40;n++) {
		if(text[n]==NULL) break;
		printchar(x,y,text[n]);
		x+=8;
		if(x>320) break;
	}
}

void printnumber(int x,int y,int no)
{
	char temp[20];

	sprintf(temp,"%u",no);
	printline(x,y,temp);
}


void attribute(byte color,byte sfx)
{
	printcolor=color&0x0f;
	printsfx=sfx&0x7;
}





/* icons -------------------------------- */
/* put up icons neatly */
icon(word x,word y,word i)
{
	word ioff,iseg;

	iseg=FP_SEG(icons)+(FP_OFF(icons)>>4);
	ioff=FP_OFF(icons)&0xf;
	asm {
		push ds
		push es
		mov ds,iseg
		mov si,ioff
		mov ax,i
		mov bx,640
		mul bx
		add si,ax
		mov ax,0xa000
		mov es,ax
		mov ax,y
		mov bx,320
		mul bx
		add ax,x
		mov di,ax
		mov cx,20
	}
icn1: asm {
		cmp di,0xfa00
		ja icn7
		push cx
		push di
		mov cx,32
		rep movsb
		pop di
		pop cx
		add di,0x140
	}
icn7:
	asm {
		loop icn1
		pop es
		pop ds
	}
	return 0;
}




/* --------------------------------------------------- */
loadmcgpage(char *filename)
{
	FILE *source;
	union REGS regs;
	word handle;
	word n,y;
	byte color,truebit,bit;
	word index,bitindex;
	char *temp,*localbuffer;
	word bseg,boff;

	/* load mcg 8000 byte mono and convert to 256 color */
	if(coreleft()<8000+64000) return 1;
	localbuffer=(char *)malloc(64000);
	temp=(char *)malloc(8000);
	/* clear local buffer */
	for(n=0;n<64000;n++) localbuffer[n]=0;

	/* grab the mcg image into the temp area */
	if((source=fopen(filename,"rb"))==NULL) {
		textscreen();
		printf("Error opening MCG file %s\n",filename);
		exit(1);
	}
	fread(temp,8000,1,source);
	fclose(source);

	/* decode the 1bit mono into a scintilatable 256color */
	for(bitindex=0,index=0;index<320;) {
		for(bit=0;bit<8;bit++) {

			if(index&16)
				color=255-((byte)index&15);
			 else
				color=240+((byte)index&15);

			truebit=(1<<bit);

			for(y=0;y<200;y++) {
				if((temp[bitindex+40*y]&truebit)!=0)
					localbuffer[index+320*y]=color;
			}
			index++;
		}
		bitindex++;
	}

	/* prep an EMS page */
	regs.h.ah=0x43;
	regs.x.bx=4;
	int86(EMS_BIOS,&regs,&regs);
	handle=regs.x.dx;
	if(regs.h.ah!=0) return 2;
	for(n=0;n<4;n++) {
		regs.h.ah=0x44;
		regs.h.al=n;
		regs.x.bx=n;
		regs.x.dx=handle;
		int86(EMS_BIOS,&regs,&regs);
	}

	/* copy local buffer to EMS seg */
	bseg=FP_SEG(localbuffer)+(FP_OFF(localbuffer)>>4);
	boff=FP_OFF(localbuffer)&0xf;
	asm {
		push ds
		push es
		push si
		push di
		mov es,emsseg
		mov di,0
		mov ds,bseg
		mov si,boff
		mov cx,0x7d00
		rep movsw
		pop di
		pop si
		pop es
		pop ds
	}
	/* done thrashing */
	free(localbuffer);
	free(temp);

	return handle;
}


loadvgapage(char *filename)
{
	FILE *source;
	union REGS regs;
	word handle;
	word n;

	regs.h.ah=0x43;
	regs.x.bx=4;
	int86(EMS_BIOS,&regs,&regs);
	handle=regs.x.dx;
	if(regs.h.ah!=0) return 2;

	for(n=0;n<4;n++) {
		regs.h.ah=0x44;
		regs.h.al=n;
		regs.x.bx=n;
		regs.x.dx=handle;
		int86(EMS_BIOS,&regs,&regs);
	}

	if((source=fopen(filename,"rb"))==NULL) {
		textscreen();
		printf("Error opening VGA file %s\n",filename);
		exit(1);
	}
	fread(MK_FP(emsseg,0),0xfa00,1,source);
	fclose(source);
	return handle;
}

unloadvgapage(int handle)
{
	union REGS regs;

	regs.h.ah=0x45;
	regs.x.dx=handle;
	int86(EMS_BIOS,&regs,&regs);
	if(regs.h.ah!=0) return 1;
	return 0;
}


void emstofore(int handle)
{
	union REGS regs;
	word fseg,foff;
	word n;

	for(n=0;n<4;n++) {
		regs.h.ah=0x44;
		regs.h.al=n;
		regs.x.bx=n;
		regs.x.dx=handle;
		int86(EMS_BIOS,&regs,&regs);
	}

	fseg=(FP_SEG(foreground))+(FP_OFF(foreground)>>4);
	foff=FP_OFF(foreground)&0xf;
	asm {
		push ds
		push es
		push si
		push di
		mov ds,emsseg
		mov si,0
		mov es,fseg
		mov di,foff
		mov cx,0x7d00
		rep movsw
		pop di
		pop si
		pop es
		pop ds
	}
}

void emstoback(int handle)
{
	union REGS regs;
	word bseg,boff;
	word n;

	for(n=0;n<4;n++) {
		regs.h.ah=0x44;
		regs.h.al=n;
		regs.x.bx=n;
		regs.x.dx=handle;
		int86(EMS_BIOS,&regs,&regs);
	}

	bseg=(FP_SEG(background))+(FP_OFF(background)>>4);
	boff=FP_OFF(background)&0xf;
	asm {
		push ds
		push es
		push si
		push di
		mov ds,emsseg
		mov si,0
		mov es,bseg
		mov di,boff
		mov cx,0x7d00
		rep movsw
		pop di
		pop si
		pop es
		pop ds
	}
}


void emstobuffer(int handle)
{
	union REGS regs;
	word bseg,boff;
	word n;

	for(n=0;n<4;n++) {
		regs.h.ah=0x44;
		regs.h.al=n;
		regs.x.bx=n;
		regs.x.dx=handle;
		int86(EMS_BIOS,&regs,&regs);
	}

	bseg=(FP_SEG(buffer))+(FP_OFF(buffer)>>4);
	boff=FP_OFF(buffer)&0xf;
	asm {
		push ds
		push es
		push si
		push di
		mov ds,emsseg
		mov si,0
		mov es,bseg
		mov di,boff
		mov cx,0x7d00
		rep movsw
		pop di
		pop si
		pop es
		pop ds
	}
}


void emstointerground(int handle)
{
	union REGS regs;
	word iseg,ioff;
	word n;

	for(n=0;n<4;n++) {
		regs.h.ah=0x44;
		regs.h.al=n;
		regs.x.bx=n;
		regs.x.dx=handle;
		int86(EMS_BIOS,&regs,&regs);
	}

	iseg=(FP_SEG(interground))+(FP_OFF(interground)>>4);
	ioff=FP_OFF(interground)&0xf;
	asm {
		push ds
		push es
		push si
		push di
		mov ds,emsseg
		mov si,0
		mov es,iseg
		mov di,ioff
		mov cx,0x7d00
		rep movsw
		pop di
		pop si
		pop es
		pop ds
	}
}







/*            "Obsession.  Repression.  The end of it all."            */
/*  -----------------------------------------------------------------  */
main()
{
	register n;
	union REGS regs;
	struct SREGS sregs;
	FILE *source;
	int pan,count,option=FALSE,moving;
	word backseg,backoff;
	word foreseg,foreoff;
	char far *emptr,far *nameptr;
	char far *emmstring,far *reference_string;
	unsigned int handle;


	textscreen();
/* say hi */
	puts("THE FORGOTTEN REALMS BBS demo-Ba");
	puts("Written by The Minimalist Group");
	puts("");

/* check BIOS/DOS version */
	printf("C_System: ");
	if(_osmajor<4) {
		puts("This program requires DOS 4.0 or higher to run.");
		return 1;
	}
	else
		printf("Running under DOS %u.%u\n",_osmajor,_osminor);

/* check for silliness */
	if(getdisk()<=1) {
		puts(" Program MUST be ran from hard drive.");
		return 1;
	}

/* check if enough conventional memory to buffer image in RAM */
	printf("I_CMTEST: ");
	if(coreleft()<768+7680+19200+25600+0xfb40*2+0xfa00*2) {
		puts(" Insufficent conventional memory to proceed.");
		printf(" Core memory %lu\n",(unsigned long)coreleft());
		return 1;
	}
	else {
		puts("Allocating conventional memory");
		palette=(unsigned char *)malloc(768);
		alphanumerics=(char *)malloc(7680);
		icons=(char *)malloc(19200);
		flags=(char *)malloc(25600);
		background=(char *)malloc(0xfb40);
		foreground=(char *)malloc(0xfb40);
		buffer=(char *)malloc(0xfa00);
		interground=(char *)malloc(0xfa00);
	}

	/* Is the driver installed? Get the address of the EMS386 driver from
	interrupt 0x67, where it always dwells, and then check to see if the
	tag EMMXXXX0 is there.  If all this is true, there is an expanded memory
	manager active here.  */
	nameptr="EMMXXXX0";
	regs.h.ah=0x35;
	regs.h.al=0x67;
	intdosx(&regs,&regs,&sregs);
	emptr=(char *)MK_FP(sregs.es,0);

	emmstring=emptr+10;
	reference_string=nameptr;
	n=8;
	while(*reference_string && n>0) {
		if(*emmstring!=*reference_string) {
			printf(" EMS Driver not detected. This program REQUIRES an EMS386 compatable driver be installed.");
			return 1;
		}
		n--;
		emmstring++;
		reference_string++;
	}
	puts("EMS Driver detected!");


	printf("I_EMSTEST: ");
	/* is hardware present? */
	regs.h.ah=0x40;
	int86(0x67,&regs,&regs);
	switch (regs.h.ah) {
		case 0x00:
			puts("EMS Expanded memory manager detected");
			break;
		case 0x80:
			puts("Internal error in EMS software");
			return 1;
		case 0x81:
			puts("Malfunction in EMS hardware");
			return 1;
		case 0x84:
			puts("Undefined EMS function");
			return 1;
		default:
			puts("Undefined EMS ERROR");
			return 1;
	}

	/* look for page frame segment */
	regs.h.ah=0x41;
	int86(0x67,&regs,&regs);
	switch (regs.h.ah) {
		case 0x00:
			printf(" Segment of page frame %u (%Xh)\n",regs.x.bx,regs.x.bx);
			emsseg=regs.x.bx;
			break;
		case 0x80:
			puts(" Internal error in EMS software. Segment page not found.");
			puts(" EMS software possibly is not emulating expanded memory.");
			return 1;
		case 0x81:
			puts(" Malfunction in EMS hardware");
			return 1;
		case 0x84:
			puts(" Undefined EMS function");
			return 1;
		default:
			puts(" Undefined EMS ERROR");
			return 1;
	}

	/* get page count */
	regs.h.ah=0x42;
	int86(0x67,&regs,&regs);
	switch (regs.h.ah) {
		case 0x00:
			printf(" Number of unallocated pages %u (%uk)\n",regs.x.bx,regs.x.bx*16);
			printf(" Total number of pages in system %u (%uk)\n",regs.x.dx,regs.x.dx*16);
			break;
		case 0x80:
			puts(" Internal error in EMS software");
			return 1;
		case 0x81:
			puts(" Malfunction in EMS hardware");
			return 1;
		case 0x84:
			puts(" Undefined EMS function");
			return 1;
		default:
			puts(" Undefined EMS ERROR");
			return 1;
	}

/* look for mouse driver */
	printf("I_MDTEST: ");
	regs.x.ax = 0;
	if (!int86(MOUSE_BIOS,&regs,&regs)) {
		puts("Mouse driver not detected");
		puts(" A mouse is required to properly use this program.");
		puts(" If you have a mouse, please check to see if cabling is properly attached");
		puts(" or if your mouse driver has been loaded.");
		return 1;
	}
	else {
		mouse=TRUE;
		puts("Mouse driver detected");
	}



/* -- srcbuild all image files -- */
	printf("R_SrcBuild (demo): loading");

	if((source=fopen("working.PAL","rb"))==NULL)  {
		puts("Error opening file working.PAL");
		getch();
		return 1;
	}
	fread(palette,768,1,source);
	fclose(source);
	putchar('.');

	/* get alphanumerics character set */
	if((source=fopen("ancs1010.src","rb"))==NULL)  {
		puts("Error opening ANCS1010.SRC");
		return 1;
	}
	fread(alphanumerics,7680,1,source);
	fclose(source);
	putchar('.');

	/* get icons and flags */
	if((source=fopen("tfricon.src","rb"))==NULL) {
		puts("Error opening tfricon.SRC");
		return 1;
	}
	fread(icons,12800,1,source);
	fread(flags,25600,1,source);
	fclose(source);
	putchar('.');

	/* ok. now grab everything else off the HD and alloc some mem for them */
	stars=makestarfield(); putchar('.');
	moon=loadvgapage("moon.vga"); putchar('.');
	castle=loadvgapage("castle.vga"); putchar('.');
	clouds=loadvgapage("clouds.vga"); putchar('.');
	tfrs=loadmcgpage("tfrs.mcg"); putchar('.');
	tfrsnode=loadmcgpage("tfrsnode.mcg"); putchar('.');
	nuke=loadvgapage("nuke.vga"); putchar('.');
	puts("Built!");


/*ok. we do, so let's do it. here's the main */
	vgascreen();
	blankpalette(); // pitch dark in the beginning

/* restrict mouse movement to the two icons */
	regs.x.ax=7;
	regs.x.cx=576;
	regs.x.dx=639;
	int86(MOUSE_BIOS,&regs,&regs);
	regs.x.ax=8;
	regs.x.cx=160;
	regs.x.dx=199;
	int86(MOUSE_BIOS,&regs,&regs);
/* and start the mouse cursor off way the fuck to the bottom/right */
	regs.x.ax=0x4;
	regs.x.cx=639;
	regs.x.dx=199;
	int86(MOUSE_BIOS,&regs,&regs);


	/* now let the wind blow while we ask 'em "what now?" */
/* -------- precore preping ---------- */
	frame=0;
	framedir=1;
	emstoback(stars); //prep
	emstointerground(moon); //prep
	emstofore(castle); //prep
	foretovga(); //compose new foreground
	icon(288,160,0);
	icon(288,180,9);
	vgatofore();
	windycastle(); //prime the pump with a picture
	showmouse();

	for(count=0;count<60;count++) { // wait a few secs with only red pulsing
		if(option==10) break;
		starrycastle();
		option=pressed();
	}


 /* -------- core ------------- */
	// the main section here
	do {

		moving=RIGHT;
		/* ok. it's night time. full moon. stars. */
		emstoback(stars); // stary background
		emstointerground(moon);  // the moon is the moving object
		/* prep fore with new castle */
		emstofore(castle);
		foretovga(); //compose new foreground
		attribute(WHITE,SHADOW);
		printline(16,188,"The MINIMALIST Group ~ 1994");
		icon(288,160,0);
		icon(288,180,9);
		vgatofore();

		for(count=-63;count<0;count++) {  // fade in
			if(option!=FALSE) break;
			option=pressed();
			lightlevel(count);
			starrycastle();
		}
		for(pan=199;pan>=0;pan--) { //the moon rises
			if(option!=FALSE) break;
			option=pressed();
			starrycastleoverlogo(pan);
		}
		for(pan=0;pan>-199;pan--) { // as moon rises high, gets brighter
			if(option!=FALSE) break;
			option=pressed();
			lightlevel(-(pan>>4));
			starrycastleoverlogo(pan);
		}
		for(count=0;count>-63;count--) {  // moon sets, gets dark
			if(option!=FALSE) break;
			option=pressed();
			lightlevel(count);
			starrycastle();
		}


		if(option!=FALSE) break;
		/* alright. it going to get day light now */
		moving=LEFT;
		emstoback(clouds);
		emstointerground(tfrs);

		/* prep fore with castle without minimlist copyright notice */
		emstofore(castle);
		foretovga(); //compose new foreground
		icon(288,160,0);
		icon(288,180,9);
		vgatofore();

		for(pan=-63;pan<=0;pan++) { // morning. clouds. sun comes up.
			if(option!=FALSE) break;
			option=pressed();
			lightlevel(pan);
			windycastle();
		}
		for(pan=150;pan!=0;pan--) { //the first logo rises behind castle
			if(option!=FALSE) break;
			option=pressed();
			windycastleoverlogo(pan);
		}
		for(pan=0;pan>-40;pan--) { // and it sits there a bit
			if(option!=FALSE) break;
			option=pressed();
			windycastleoverlogo(0);
		}
		flashletters();
		for(pan=0;pan>-63;pan--) { // now it shines in-front of the castle
			if(option!=FALSE) break;
			option=pressed();
			logooverwindycastle(0);
		}
		flashletters();
		if(option!=FALSE) break;
		emstointerground(tfrsnode); //switch to other logo
		for(pan=0;pan>-63;pan--) { // now it shines in-front of the castle
			if(option!=FALSE) break;
			option=pressed();
			logooverwindycastle(0);
		}
		for(pan=0;pan<200;pan++) { //and now it lowers
			if(option!=FALSE) break;
			option=pressed();
			logooverwindycastle(pan);
		}
		for(pan=0;pan>-63;pan--) { //and it gets dark
			if(option!=FALSE) break;
			option=pressed();
			lightlevel(pan);
			windycastle();
		}
	} while (option==FALSE);

/* ------ end core ---- */

/* so, they've pressed the key and think it's over eh? well...
	IT'S OVER!! ==> NUKE 'EM! ==>             */
	emstointerground(nuke);
	hidemouse();
	for(pan=128;pan>0;pan-=4) {
		lightlevel((128-pan)>>1);
		if(moving==LEFT)
			nukewindycastle(pan);
		else
			nukestarrycastle(pan);
	}
	hidemouse();
	whitein();
	fadeout();

/* that's it. it's over. roll credits. */
	/* deallocate conventional memory and EMS handles */
	free(palette);
	free(alphanumerics);
	free(icons);
	free(flags);
	free(foreground);
	free(background);
	free(buffer);
	unloadvgapage(clouds);
	unloadvgapage(moon);
	unloadvgapage(stars);
	unloadvgapage(castle);
	unloadvgapage(tfrs);
	unloadvgapage(tfrsnode);
	unloadvgapage(nuke);

	/* restore mouse movement */
	regs.x.ax=7;
	regs.x.cx=0;
	regs.x.dx=639;
	int86(MOUSE_BIOS,&regs,&regs);
	regs.x.ax=8;
	regs.x.cx=0;
	regs.x.dx=199;
	int86(MOUSE_BIOS,&regs,&regs);

	/* the credits and legals */
	textscreen();
	puts("THE FORGOTTEN REALMS BBS demo-Ba");
	puts("Node 1 (615)584-9134	28.8USR modem! 486/33processor!");
	puts("Node 2 Coming soon!");
	puts("24/7 LORD 3.03! PITT! Ursurper 0.6a<reg>! -- The Matrix!");
	puts("Sysop Grand Admiral Thrawn");
	puts("");
	puts("demo-B Written by Lewis Sellers 3 'Minimalist'");
	puts("The MINIMALIST Group; Knoxville, TN United States of America");
	puts("Copyright (c) 1994. All Rights Reserved.");
	puts("Revision Ba make possible by the complaints of Clan McCannon :)");
	puts("This is a FREEWARE Demo.  Treat it as such!");
	puts("No ripping or reverse-engineering please.  If you see a routine");
	puts(" you like just 'ask' about it. Maybe we can trade?");
	puts("");
	printf("Lines of Borland 3.00 C++/80186 assembly code %u\n",getlines());
	printf("Last Compile date %s %s\n",__DATE__,__TIME__);
	return 0;
}

getlines() // how many lines of code???
{
	return __LINE__+1;
}

