/* 
  BOBOLI map editor
*/
#include "mgraph.h"
#include "umk.h"
#include "mfont.h"
#include "boboli.h"
#include <stdio.h>

umkset u1,u2;
centerray ob;
scrntype scrn;
paltype hulkpal;
colmat dark;
maprec map;
genrec gen[maxgen];
tileset tiles;

void loadctr(char *name,centerray c)
{
  FILE *f;
  f=fopen(name,"rb");
  fread(c,1,sizeof(centerray),f);
  fclose(f);
}

byte calc_shadows(byte x,byte y)
{
  byte v;
  if(map[x+y*mapwidth].floor>63) return 0; /* no shadows on walls */
  if(x==0) {
    if(y==0) return 6;
    else if(map[x+(y-1)*mapwidth].floor>63) return 6;
    else return 2;
  }
  if(y==0) { 
    if(map[x-1+y*mapwidth].floor>63) return 6;
    else return 4;
  }
  if(map[x-1+y*mapwidth].floor>63) {
    if(map[x+(y-1)*mapwidth].floor>63) return 6;
    if(map[x-1+(y-1)*mapwidth].floor>63) return 2;
    else return 1;
  }
  if(map[x+(y-1)*mapwidth].floor>63) {
    if(map[x-1+(y-1)*mapwidth].floor>63) return 4;
    else return 5;
  }
  if(map[x-1+(y-1)*mapwidth].floor>63) return 3;
  return 0;
}

void clear_map(void)
{
  short i,j;
  for(i=0;i<mapwidth;i++)
    for(j=0;j<mapheight;j++) {
      map[i+j*mapwidth].floor=0;
      map[i+j*mapwidth].object=0;
      map[i+j*mapwidth].shadow=calc_shadows(i,j);
    }
  for(i=0;i<maxgen;i++)
    gen[i].kind=gn_none;
}

void loadtiles(char *name,tileset t)
{
  short i,j,k,x,y;
  paltype p;
  loadPCX(name,p,scrn);
  x=0; y=0;
  for(i=0;i<128;i++) {
    for(j=0;j<16;j++)
      for(k=0;k<16;k++)
        t[i][j+k*16]=scrn[x+j+(y+k)*320];
    x+=16;
    if(x>319) {
      x=0;
      y+=16;
    }
  }
}

void edit_init()
{
  __djgpp_nearptr_enable();
  initmg();
  font_init("misc\\little.fnt");
  gmode(0x13);
  scrn=(scrntype)malloc(64000);
  loadpal("misc\\hulk.pal",hulkpal);
  setpal(hulkpal);
  mat_load("misc\\dark.mat",dark);
  umk_load("umks\\stuff.umk",u1);
  umk_load("umks\\objects.umk",u2);
  loadctr("ctr\\objects.ctr",ob);
  loadtiles("pcx\\tiles.pcx",tiles);
  clear_map();
}

void edit_exit()
{
  gmode(0x3);
  umk_free(u1);
  umk_free(u2);
  free(scrn);
  __djgpp_nearptr_disable();
}

void display_tile(short x,short y,tilerec t,scrntype scrn)
{
  byte i;
  for(i=0;i<16;i++) memcpy(&(scrn[x+(y+i)*320]),&(tiles[t.floor][i*16]),16);
  switch(t.object) {
    case ob_none: break;
    case ob_genrtr: umk_draw(x+8-ob[0].x,y+8-ob[0].y,u2[0],scrn);
                    break;
    default: umk_draw(x+8-ob[44+t.object].x,y+8-ob[44+t.object].y,u2[44+t.object],scrn);
                     break;
  }
  if(t.shadow>0)
    umk_shadow(x,y,dark,u1[t.shadow-1],scrn);
}

void display_map(byte x,byte y)
{
  short i,j;
  for(i=x;i<x+12;i++)
    for(j=y;j<y+11;j++) 
      display_tile((i-x)*16,(j-y)*16,map[i+j*mapwidth],scrn);
}

void loadmap(void)
{
  FILE *f;
  f=fopen("temp.map","rb");
  fread(map,sizeof(maprec),1,f);
  fread(gen,sizeof(genrec)*maxgen,1,f);
  fclose(f);
}

void savemap(void)
{
  FILE *f;
  f=fopen("temp.map","wb");
  fwrite(map,sizeof(maprec),1,f);
  fwrite(gen,sizeof(genrec)*maxgen,1,f);
  fclose(f);
}

void add_genrtr(byte x,byte y,byte kind)
{
  byte i;
  for(i=0;i<maxgen;i++) {
    if(gen[i].kind==gn_none) {
      gen[i].x=x;
      gen[i].y=y;
      gen[i].kind=kind;
      gen[i].timer=255;
      gen[i].hp=150;
      i=maxgen;
    }
  }
}

void rm_generator(byte x,byte y) 
{
  byte i;
  for(i=0;i<maxgen;i++) 
    if((gen[i].x==x)&&(gen[i].y==y)) gen[i].kind=gn_none;
}

void dot_tile(short x,short y,tilerec t)
{
  byte i;
  if((t.floor<3)||(t.floor==15)) i=3;
  if((t.floor==3)) i=21;
  if(t.floor==4) i=19;
  if(t.floor==5) i=169;
  if((t.floor>5)&&(t.floor<15)) i=165;
  if((t.floor==64)||(t.floor==65)) i=215;
  if((t.floor>65)&&(t.floor<82)) i=8;
  screen[x+y*320]=i;
  if(t.object>0) screen[x+y*320]=15;
  if(t.object==ob_genrtr) screen[x+y*320]=55;
}

void dot_map()
{
  short i,j;
  for(i=0;i<mapwidth;i++)
    for(j=0;j<mapheight;j++) 
      dot_tile(i,j,map[i+j*mapwidth]);
}


void editit(void)
{
  short sx=0,sy=0;
  byte x=0,y=0,done=0,fusing=0,lock=0;
  tilerec fusing_t;
  char a;
  clear(0,scrn);
  fusing_t.floor=0;
  fusing_t.shadow=0;
  fusing_t.object=0;
  while(!done) {
    display_map(sx,sy);
    display_tile(220,0,fusing_t,scrn);
    near_scrcpy(scrn,screen);
    while(!kbhit()) {
      box((x-sx)*16,(y-sy)*16,(x-sx)*16+15,(y-sy)*16,random()%256,screen);
      box((x-sx)*16,(y-sy)*16+15,(x-sx)*16+15,(y-sy)*16+15,random()%256,screen);
      qdelay(1000);
    }
    a=getch();
    if(a==27) done=1;
    if(a==0) {
      a=getch();
      if(a==60) savemap();
      if(a==61) loadmap();
    }
    if(a=='l') lock=1-lock;
    if(a=='8') {
      if(lock) a=' ';
      y--;
      if(y>mapheight) y=mapheight-1;
    }
    if(a=='6') {
      if(lock) a=' ';
      x++;
      if(x==mapwidth) x=0;
    }
    if(a=='2') {
      if(lock) a=' ';
      y++;
      if(y==mapheight) y=0;
    }
    if(a=='4') {
      if(lock) a=' ';
      x--;
      if(x>mapwidth) x=mapwidth-1;
    }
    if(a==' ') {
      map[x+y*mapwidth].floor=fusing;
      map[x+y*mapwidth].shadow=calc_shadows(x,y);
      if(x<mapwidth-1) map[x+1+y*mapwidth].shadow=calc_shadows(x+1,y);
      if(y<mapheight-1) {
        if(x<mapwidth-1) map[x+1+(y+1)*mapwidth].shadow=calc_shadows(x+1,y+1);
        map[x+(y+1)*mapwidth].shadow=calc_shadows(x,y+1);
      }
    }
    if(a=='-') {
      fusing--;
      if(fusing>127) fusing=127;
      fusing_t.floor=fusing;
    }
    if(a=='=') {
      fusing++;
      if(fusing>127) fusing=0;
      fusing_t.floor=fusing;
    }
    if(a=='_') {
      fusing=0;
      fusing_t.floor=fusing;
    }
    if(a=='+') {
      fusing=64;
      fusing_t.floor=fusing;
    }
    if(a=='q') {
      rm_generator(x,y);
      map[x+y*mapwidth].object=ob_none;
    }
    if(a=='w') {
      map[x+y*mapwidth].object=ob_xbow;
      rm_generator(x,y);
    }
    if(a=='e') {
      map[x+y*mapwidth].object=ob_genrtr;
      rm_generator(x,y);
      add_genrtr(x,y,gn_bonehead);
    }
    if(a=='r') {
      map[x+y*mapwidth].object=ob_genrtr;
      rm_generator(x,y);
      add_genrtr(x,y,gn_glob);
    }
    if(a=='t') {
      map[x+y*mapwidth].object=ob_fball;
      rm_generator(x,y);
    }
    if(a=='y') {
      map[x+y*mapwidth].object=ob_inferno;
      rm_generator(x,y);
    }
    if(a=='u') {
      map[x+y*mapwidth].object=ob_3xbow;
      rm_generator(x,y);
    }
    if(a=='i') {
      map[x+y*mapwidth].object=ob_elfswd;
      rm_generator(x,y);
    }
    if(a=='o') {
      map[x+y*mapwidth].object=ob_gntswd;
      rm_generator(x,y);
    }
    if(a=='p') {
      map[x+y*mapwidth].object=ob_souledge;
      rm_generator(x,y);
    }
    if(a=='a') {
      map[x+y*mapwidth].object=ob_mirshield;
      rm_generator(x,y);
    }
    if(a=='s') {
      map[x+y*mapwidth].object=ob_tornado;
      rm_generator(x,y);
    }
    if(a=='d') {
      map[x+y*mapwidth].object=ob_fxbow;
      rm_generator(x,y);
    }
    if(a=='f') {
      map[x+y*mapwidth].object=ob_greenthumb;
      rm_generator(x,y);
    }
    if(a=='g') {
      map[x+y*mapwidth].object=ob_invis;
      rm_generator(x,y);
    }
    if(a=='h') {
      map[x+y*mapwidth].object=ob_shieldspl;
      rm_generator(x,y);
    }
    if(a=='j') {
      map[x+y*mapwidth].object=ob_healing;
      rm_generator(x,y);
    }
    if(a=='k') {
      map[x+y*mapwidth].object=ob_summon;
      rm_generator(x,y);
    }
    if(a==9) {
      dot_map();
      while(!kbhit()) {
        screen[x+y*320]=random()%256;
        screen[64+64*320]=random()%256;
      }
      getch();
    }
    if(x>sx+10) sx=x-10;
    if(x<sx+2) sx=x-2;
    if(y>sy+8) sy=y-8;
    if(y<sy+2) sy=y-2;
    if(sx<0) sx=0;
    if(sx>mapwidth-12) sx=mapwidth-12;
    if(sy<0) sy=0;
    if(sy>mapheight-11) sy=mapheight-11;
  }
}

void main(void)
{
  edit_init();
  editit();
  edit_exit();
}
