
// I N C L U D E S ///////////////////////////////////////////////////////////

#include <io.h>
#include <conio.h>
#include <graph.h>
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <bios.h>
#include <fcntl.h>
#include <memory.h>
#include <malloc.h>
#include <math.h>
#include <string.h>
#include <ctype.h>

#include "sound.h"
#include "graphics.h"
#include "input.h"

#define NUM_SOUND_FX 1     // the number of sound fx loaded in
#define MENU_VOC 1
#define MAX_SHIPS 4


#define TRUE 1
#define FALSE !TRUE

// state of the game itself

#define GAME_SETUP                  0   // the game is in the setup mode
#define GAME_LINKING                1   // the communications link is being established
#define GAME_RUNNING                2   // the game is running
#define GAME_PAUSED                 3   // the game is paused (not implemented)
#define GAME_OVER                   4   // what do you think

// general object states

#define DEAD                        0   // these are general states for any
#define ALIVE                       1   // object
#define DYING                       2

// defines for setup selections

#define SETUP_PLAY_SOLO             0
#define SETUP_MAKE_CONNECTION       1
#define SETUP_WAIT_FOR_CONNECTION   2
#define SETUP_SELECT_SHIP           3
#define SETUP_SET_COMM_PORT         4
#define SETUP_BRIEFING              5
#define SETUP_EXIT                  6

#define NUM_SETUP                   7   // number of setup choices

#define USER_QUITTED
#define USER_LOST
#define USER_WON

#define EASY_AS_SNOT   1
#define A_GOOD_BELCH   2
#define PUKE_GRAVY     3
#define TOUGH_AS_SHIT  4
#define A_FARTS_CHANCE 5

////////// F U N C T I O N S /////////////////////////////////////////////////

void SetupShips(int connected);
int PlayGame(int connected);
int computersTurn();
int intro(void);
void selectDifficulty(void);
void makeHarder (int * xptr, int * yptr);

//// G L O B A L S  ////////////////////////////////////////////////////////////


void (_interrupt _far *Old_Key_Isr)(); // holds old keyboard interrupt handler

int direction[4] = {0, 0, 0, 0}; // 0 up, 1 down, 2 left, 3 right

sprite shipPlacer;

sprite userShip[4];
sprite computerShip[4]; 

Sound digital_FX[8];
music song;

int font_init = 0;
int game_state = GAME_SETUP;  // the overall state of the game
int PlayerWantsToQuit = FALSE;
int counterH = 0, counterV = 0;

gridSquare bGrid[12][12]; // bad guy's grid system
gridSquare gGrid[12][12]; // good guy's grid system

int gShipsGone = 0;
int numComputerShots = 4;
int bShipsGone = 0;
int curDirection; //the current direction of attack

int difficulty;

sprite shotCovering;
sprite missCovering;

int hitFlag = 0;
int cheat = 0;

//////////////////////////////////////////////////////////////////////////////

// M A I N ///////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////

void main(void)
{
        int counter = 0, done = 0, i;
        int redraw = 1;
        int index;
        RGB_color animate[256], temp;
                
        //fade DOS prompt and other text stuff out
        Screen_Transition(SCREEN_DARKNESS);

        // set video mode to 320x200 256 color mode
        Set_Graphics_Mode(GRAPHICS_MODE13);

        Sound_Load("menu.voc",(sound_ptr)&digital_FX[0],1);
        Sound_Load("thunder.voc",(sound_ptr)&digital_FX[1],1);
        Sound_Load("shpmove.voc",(sound_ptr)&digital_FX[2],1);
        Sound_Load("splash.voc",(sound_ptr)&digital_FX[4],1);
        Sound_Load("shot.voc",(sound_ptr)&digital_FX[5],1);
        Sound_Load("blowup.voc",(sound_ptr)&digital_FX[6],1);
        Sound_Load("laugh.voc",(sound_ptr)&digital_FX[7],1);

        Music_Load("music.xmi", (music_ptr)&song);
        Music_Play((music_ptr)&song,0);

        Font_Engine_1(0,0,0,0,NULL,NULL);

        PCX_Init((pcx_picture_ptr)&background);
        PCX_Load("water.pcx", (pcx_picture_ptr)&background, 0);
        Wait_For_Vertical_Retrace();
        PCX_Show_Buffer((pcx_picture_ptr)&background, 1);

        // install new isr's
        Keyboard_Install_Driver();

        for(index = 0; index < 256; index++)
        {
            Read_Color_Reg(index, (RGB_color_ptr)&animate[index]);
        }

        while(!keys_active)
        {
            temp.red = animate[1].red;
            temp.green = animate[1].green;
            temp.blue = animate[1].blue;
            for(index = 1; index < 256; index++)
            {
                animate[index].red = animate[index + 1].red;
                animate[index].green = animate[index + 1].green;
                animate[index].blue = animate[index + 1].blue;
            }
            animate[255].red = temp.red;
            animate[255].green = temp.green;
            animate[255].blue = temp.blue;

            for(index = 1; index < 256; index++)
            {
                Write_Color_Reg(index, (RGB_color_ptr)&animate[index]);
            }
        }

        PCX_Delete((pcx_picture_ptr)&background);
        
        intro();
        Screen_Transition(SCREEN_DARKNESS);

        PCX_Init((pcx_picture_ptr)&background);
        PCX_Load("menu.pcx", (pcx_picture_ptr)&background, 0);
        PCX_Show_Buffer((pcx_picture_ptr)&background, 1);
        PCX_Delete((pcx_picture_ptr)&background);

        PCX_Init((pcx_picture_ptr)&shell_back);
        PCX_Load("torp.pcx", (pcx_picture_ptr)&shell_back, 0);

        Sprite_Init((sprite_ptr)&shell, 75, 40, 75, 40, 24, 24, 0, 0, 0, 0, 0);
        PCX_Get_Sprite((pcx_picture_ptr)&shell_back, (sprite_ptr)&shell, 0, 0, 0);
        PCX_Get_Sprite((pcx_picture_ptr)&shell_back, (sprite_ptr)&shell, 1, 1, 0);
        PCX_Get_Sprite((pcx_picture_ptr)&shell_back, (sprite_ptr)&shell, 2, 2, 0);
        PCX_Get_Sprite((pcx_picture_ptr)&shell_back, (sprite_ptr)&shell, 3, 3, 0);
        PCX_Delete((pcx_picture_ptr)&shell_back);

        Sprite_Under((sprite_ptr)&shell, video_buffer);
        Sprite_Draw((sprite_ptr)&shell, video_buffer, 1);

        while(done != 1)
        {
            if (Music_Status()==2 || Music_Status()==0)
            {
                Music_Stop();
                Music_Play((music_ptr)&song,0);
            }

            if(keys_active > 0)
            {
                // what is user doing
                if (keyboard_state[MAKE_UP])
                {
                    shell.y-=16;

                    // test if we need to wrap around bottom

                    if (--counter < 0)
                    {
                        counter = 6;
                        shell.y = 135;
                    } // end if wrap around
                    //keyboard_state[MAKE_UP] = 0;
                    Sound_Stop();
                    Sound_Play((sound_ptr)&digital_FX[0]);
                    redraw = 1;
                } // end if up

                if (keyboard_state[MAKE_DOWN])
                {
                    shell.y+=16;

                    // test if we need to wrap around bottom

                    if (++counter > 6)
                    {
                        counter = 0;
                        shell.y = 40;
                    } // end if wrap around
                    //keyboard_state[MAKE_DOWN] = 0;
                    Sound_Stop();
                    Sound_Play((sound_ptr)&digital_FX[0]);
                    redraw = 1;
                } // end if down

                if(keyboard_state[MAKE_HOME])
                {
                    shell.y = 40;
                    counter = 0;
                    Sound_Stop();
                    Sound_Play((sound_ptr)&digital_FX[0]);
                    redraw = 1;
                }

                if(keyboard_state[MAKE_END])
                {
                    shell.y = 135;
                    counter = 6;
                    Sound_Stop();
                    Sound_Play((sound_ptr)&digital_FX[0]);
                    redraw = 1;
                }

                if(keyboard_state[MAKE_ENTER])
                {
                    switch(counter)
                    {
                            case 0:
//                          Screen_Transition(SCREEN_DARKNESS);
//                          Sprite_Delete(&shell);
                            selectDifficulty();
                            SetupShips(0);
                            shell.x_old = shell.x = 75;
                            shell.y_old = shell.y = 40;
                            PlayGame(0);
                            Screen_Transition(SCREEN_DARKNESS);
                            PCX_Init((pcx_picture_ptr)&background);
                            PCX_Load("menu.pcx", (pcx_picture_ptr)&background, 0);
                            PCX_Show_Buffer((pcx_picture_ptr)&background, 1);
                            PCX_Delete((pcx_picture_ptr)&background);
                            shell.y = 40;
                            counter = 0;
                            // scan the background at new postition
                            Sprite_Under((sprite_ptr)&shell, video_buffer);
                            //erase sprite at old position
                            Sprite_Erase((sprite_ptr)&shell, video_buffer);
                            // scan the background at new postition
                            Sprite_Under((sprite_ptr)&shell, video_buffer);
                            // draw sprite at new position
                            Sprite_Draw((sprite_ptr)&shell, video_buffer, 1);
                            // update old position
                            shell.y_old=shell.y;
                            Music_Stop();
                            Music_Unload((music_ptr)&song);
                            Music_Load("menu.xmi", (music_ptr)&song);
                            Music_Play((music_ptr)&song,0);
                            break;
                        case 1:
                        case 2:
                        case 3:
                            Screen_Transition(SCREEN_DARKNESS);
                            PCX_Init((pcx_picture_ptr)&background);
                            PCX_Load("sorry.pcx", (pcx_picture_ptr)&background, 0);
                            PCX_Show_Buffer((pcx_picture_ptr)&background, 1);
//                            PCX_Delete((pcx_picture_ptr)&background);
                            keys_active = 0;
                            while(!keys_active) //Wait for a key press to continue
                            {
                                if (Music_Status()==2 || Music_Status()==0)
                                {
                                    Music_Stop();
                                    Music_Play((music_ptr)&song,0);
                                }
                            }
                            Screen_Transition(SCREEN_DARKNESS);
//                            PCX_Init((pcx_picture_ptr)&background);
                            PCX_Load("menu.pcx", (pcx_picture_ptr)&background, 0);
                            PCX_Show_Buffer((pcx_picture_ptr)&background, 1);
                            PCX_Delete((pcx_picture_ptr)&background);
                            shell.y = 40;
                            counter = 0;
                            // scan the background at new postition
                            Sprite_Under((sprite_ptr)&shell, video_buffer);
                            //erase sprite at old position
                            Sprite_Erase((sprite_ptr)&shell, video_buffer);
                            // scan the background at new postition
                            Sprite_Under((sprite_ptr)&shell, video_buffer);
                            // draw sprite at new position
                            Sprite_Draw((sprite_ptr)&shell, video_buffer, 1);
                            // update old position
                            shell.y_old=shell.y;
                            break;
                        case 4:
                            Screen_Transition(SCREEN_DARKNESS);
                            PCX_Init((pcx_picture_ptr)&background);
                            PCX_Load("help.pcx", (pcx_picture_ptr)&background, 0);
                            PCX_Show_Buffer((pcx_picture_ptr)&background, 1);
//                            PCX_Delete((pcx_picture_ptr)&background);
                            keys_active = 0;
                            while(!keys_active) //Wait for a key press to continue
                            {
                                if (Music_Status()==2 || Music_Status()==0)
                                {
                                    Music_Stop();
                                    Music_Play((music_ptr)&song,0);
                                }
                            }
                            Screen_Transition(SCREEN_DARKNESS);
//                            PCX_Init((pcx_picture_ptr)&background);
                            PCX_Load("menu.pcx", (pcx_picture_ptr)&background, 0);
                            PCX_Show_Buffer((pcx_picture_ptr)&background, 1);
                            PCX_Delete((pcx_picture_ptr)&background);
                            shell.y = 40;
                            counter = 0;
                            // scan the background at new postition
                            Sprite_Under((sprite_ptr)&shell, video_buffer);
                            //erase sprite at old position
                            Sprite_Erase((sprite_ptr)&shell, video_buffer);
                            // scan the background at new postition
                            Sprite_Under((sprite_ptr)&shell, video_buffer);
                            // draw sprite at new position
                            Sprite_Draw((sprite_ptr)&shell, video_buffer, 1);
                            // update old position
                            shell.y_old=shell.y;
                            break;
                        case 5:
                            done = 1;
                            Screen_Transition(SCREEN_DARKNESS);
                            PCX_Init((pcx_picture_ptr)&background);
                            PCX_Load("rip.pcx", (pcx_picture_ptr)&background, 0);
                            Wait_For_Vertical_Retrace();
                            PCX_Show_Buffer((pcx_picture_ptr)&background, 1);
                            PCX_Delete((pcx_picture_ptr)&background);
                            Music_Stop();
                            Music_Play((music_ptr)&song,2);
                            Keyboard_Remove_Driver();
                            break;
                        case 6:
                            creadits();
                            PCX_Init((pcx_picture_ptr)&background);
                            PCX_Load("menu.pcx", (pcx_picture_ptr)&background, 0);
                            PCX_Show_Buffer((pcx_picture_ptr)&background, 1);
                            PCX_Delete((pcx_picture_ptr)&background);
                            shell.y = 40;
                            counter = 0;
                            // scan the background at new postition
                            Sprite_Under((sprite_ptr)&shell, video_buffer);
                            //erase sprite at old position
                            Sprite_Erase((sprite_ptr)&shell, video_buffer);
                            // scan the background at new postition
                            Sprite_Under((sprite_ptr)&shell, video_buffer);
                            // draw sprite at new position
                            Sprite_Draw((sprite_ptr)&shell, video_buffer, 1);
                            // update old position
                            shell.y_old=shell.y;
                            break;
                    }
                }
                if (keyboard_state[MAKE_ESC]) //1 == ESC
                {
                    done = 1;
                    Screen_Transition(SCREEN_DARKNESS);
                    PCX_Init((pcx_picture_ptr)&background);
                    PCX_Load("rip.pcx", (pcx_picture_ptr)&background, 0);
                    Wait_For_Vertical_Retrace();
                    PCX_Show_Buffer((pcx_picture_ptr)&background, 1);
                    PCX_Delete((pcx_picture_ptr)&background);
                    Music_Stop();
                    Music_Play((music_ptr)&song,2);
                    Keyboard_Remove_Driver();
                    break;
                }
            }

            if (redraw)
            {
                // erase sprite at old position
                Sprite_Erase((sprite_ptr)&shell, video_buffer);
                // scan the background at new postition
                Sprite_Under((sprite_ptr)&shell, video_buffer);
                // draw sprite at new position
                Sprite_Draw((sprite_ptr)&shell, video_buffer, 1);
                // update old position
                shell.y_old = shell.y;
                Time_Delay(3);
                redraw = 0;
            } // end if sprites needed to be redrawn
        } //end while(done != 1)



        PCX_Delete((pcx_picture_ptr)&background);
        PCX_Init((pcx_picture_ptr)&background);
        PCX_Load("lightng.pcx", (pcx_picture_ptr)&background, 0);

        Sprite_Init((sprite_ptr)&shell, 75, 0, 75, 0, 53, 90, 0, 0, 0, 0, 0);
        PCX_Get_Sprite((pcx_picture_ptr)&background, (sprite_ptr)&shell, 0, 0, 0);
        PCX_Delete((pcx_picture_ptr)&background);

        Sprite_Under((sprite_ptr)&shell, video_buffer);

        Time_Delay(5); //Wait a bit before blasting the lightning
        
        Sound_Stop();
        Sound_Play((sound_ptr)&digital_FX[1]); //Make the thunder BOOM!
        for(i = 0; i < 5; i++)
        {
            Sprite_Draw((sprite_ptr)&shell, video_buffer, 1); //Blast it!!
            //Make the scenery light up
            for(index = 0; index < 256; index++)
            {
                Read_Color_Reg(index, (RGB_color_ptr)&animate[index]);
            }

            for(index = 16; index < 256; index++)
            {
                animate[index].red += 15;
                animate[index].green += 15;
                animate[index].blue += 15;
            }
                    
            for(index = 16; index < 256; index++)
            {
                Write_Color_Reg(index, (RGB_color_ptr)&animate[index]);
            }

            Time_Delay(1); //Let it stay light for a bit
        
            //Darken things back up
            Sprite_Erase((sprite_ptr)&shell, video_buffer); //Take away lightning bolt
            for(index = 16; index < 256; index++)
            {
                animate[index].red -= 15;
                animate[index].green -= 15;
                animate[index].blue -= 15;
            }
                    
            for(index = 16; index < 256; index++)
            {
                Write_Color_Reg(index, (RGB_color_ptr)&animate[index]);
            }
            Time_Delay(1);        
        }

        Time_Delay(10); //Let 'm see that the lightning is done

        Screen_Transition(SCREEN_DARKNESS);
//      Sprite_Delete(&shell);
        PCX_Delete((pcx_picture_ptr)&background);
        Music_Stop();
        Music_Unload((music_ptr)&song);
        Sound_Stop();
        Sound_Unload((sound_ptr)&digital_FX);
        Set_Graphics_Mode(TEXT_MODE);   

        _settextcolor( 15 );
        _setbkcolor( 4 );
        _outtext("+--| T H A N K S  F O R  P L A Y I N G  O U R  G A M E  |--+\n");
        _outtext("|                                                          |\n");
        _outtext("| Please, give this game to all your friends!              |\n");
        _outtext("| Look for more of our games!!!                            |\n");
        _outtext("|                                                          |\n");
        _outtext("+----------------------------------------------------------+\n");

        _settextcolor( 7 );
        _setbkcolor( _BLACK );
} // end main

void SetupShips(int connected)
{
    // Declare variables ///////////////////////
    int x, redraw = 0, OneATopOfAnother = 0, flag = 0;
    int initLooper1, initLooper2;
    int randVorH, randCounterH, randCounterV;
    int cheatCounter = 0, index = 0;

    hitFlag = 0;
    cheat = 0;

    srand((unsigned int) *clock);
    curDirection = (rand() % 4);

    for(initLooper1 = 0; initLooper1 < 12; initLooper1++)
    {
        for(initLooper2 = 0; initLooper2 < 12; initLooper2++)
        {
            gGrid[initLooper1][initLooper2].coveredByShip = FALSE;
            gGrid[initLooper1][initLooper2].coveredByWhat = NULL;
            gGrid[initLooper1][initLooper2].beenShotAt    = FALSE;

            bGrid[initLooper1][initLooper2].coveredByShip = FALSE;
            bGrid[initLooper1][initLooper2].coveredByWhat = NULL;
            bGrid[initLooper1][initLooper2].beenShotAt    = FALSE;
        }
    }

    for(initLooper1 = 0; initLooper1 < 4; initLooper1++)
    {
        userShip[initLooper1].howManyTimesHit = 0;
        computerShip[initLooper1].howManyTimesHit = 0;
    }

    // Init and Load pictures ///////////////////////////
    PCX_Init((pcx_picture_ptr)&background);
    PCX_Load("grid.pcx", (pcx_picture_ptr)&background, 0);

    // DISPLAY PICTURES ////////////////////////////////
    PCX_Show_Buffer((pcx_picture_ptr)&background, 1);
    PCX_Delete((pcx_picture_ptr)&background);

    PCX_Init((pcx_picture_ptr)&ships_back);
    PCX_Load("xhair.pcx", (pcx_picture_ptr)&ships_back, 0);
    // INIT AND LOAD SPRITES ////////////////////////////

    Sprite_Init((sprite_ptr)&shipPlacer, 9, 11, 9, 11, 11, 11, 0, 0, 0, 0, 0);

    PCX_Get_Sprite((pcx_picture_ptr)&ships_back, (sprite_ptr)&shipPlacer, 0, 0, 0);

    PCX_Delete((pcx_picture_ptr)&ships_back);
    // DISPLAY SPRITES /////////////////////////////////
    Sprite_Under((sprite_ptr)&shipPlacer, video_buffer);
    Sprite_Draw((sprite_ptr)&shipPlacer, video_buffer, 1);
    // PRINT INSTRUCTIONS //////////////////////////////
    Tech_Print(8, 180, "USE THE ARROW KEYS TO MOVE SHIP-PLACER. PRESS ENTER WHEN DONE.",video_buffer);
    // TEST FOR CHEATS /////////////////////////////////
    /*Not yet implimented*/
    // LET USER SET UP SHIP LOCATIONS //////////////////
    counterH = counterV = 0;
    x = 0;
    PlayerWantsToQuit = FALSE;   
    while(x < 4 && PlayerWantsToQuit == FALSE) 
    {
        if(OneATopOfAnother == 1 && flag == 1)
        {
            Tech_Print(80, 180, "HEY, SMARTY, IF YOU", video_buffer);
            Time_Delay(10);
            _fmemset((char far *)(video_buffer + 57600), 0, 3200);
            Tech_Print(80, 180, "TRY TO PUT ONE SHIP ON", video_buffer);
            Time_Delay(10);
            _fmemset((char far *)(video_buffer + 57600), 0, 3200);
            Tech_Print(80, 180, "TOP OF ANOTHER AGAIN,", video_buffer);
            Time_Delay(10);                                
            _fmemset((char far *)(video_buffer + 57600), 0, 3200);
            Tech_Print(80, 180, "I WILL WUP YA!!!!", video_buffer);
            Time_Delay(10);
            _fmemset((char far *)(video_buffer + 57600), 0, 3200);
            flag = 0;
        }

        if(OneATopOfAnother == 2 && flag == 1)
        {
            Tech_Print(80, 180, "I WARNED YOU...", video_buffer);
            Time_Delay(20);
            _fmemset((char far *)(video_buffer + 57600), 0, 3200);
            Tech_Print(10, 180, "SAY GOOD BYE!", video_buffer);
            Time_Delay(20);
            Screen_Transition(SCREEN_SWIPE_Y);
            flag = 0;
            PlayerWantsToQuit = TRUE; // Ha, ha, ha, ha! 8-)
        }
        
        // IMPLEMENTATION OF THE "SAMMY" CHEAT CODE

        if(keyboard_state[MAKE_S] && cheatCounter == 0 && cheat != 1)
        {
            cheatCounter = 1;
            keyboard_state[MAKE_S] = 0;
        }

        if(keyboard_state[MAKE_A] && cheatCounter == 1 && cheat != 1)
        {
            cheatCounter++;
            keyboard_state[MAKE_A] = 0;
        }

        if(keys_active == 1 && keyboard_state[MAKE_A] == 0 && cheatCounter != 1)
            cheatCounter = 0;

        if(keyboard_state[MAKE_M] && cheatCounter == 2 && cheat != 1)
        {
            cheatCounter++;
            keyboard_state[MAKE_M] = 0;
        }


        if(keys_active == 1 && keyboard_state[MAKE_M] == 0 && cheatCounter != 2)
            cheatCounter = 0;

        if(keyboard_state[MAKE_M] && cheatCounter == 3 && cheat != 1)
        {
            Time_Delay(4);
            cheatCounter++;
            keyboard_state[MAKE_M] = 0;
        }

        if(keys_active == 1 && keyboard_state[MAKE_M] == 0 && cheatCounter != 3)
            cheatCounter = 0;

        if(keyboard_state[MAKE_Y] && cheatCounter == 4 && cheat != 1)
        {
            Time_Delay(4);
            cheatCounter++;
            keyboard_state[MAKE_Y] = 0;
        }

        if(keys_active == 1 && keyboard_state[MAKE_Y] == 0 && cheatCounter != 4)
            cheatCounter = 0;

        if(cheatCounter == 5 && cheat != 1)
        {
            _fmemset((char far *)(video_buffer + 57600), 0, 3200);
            Tech_Print(80, 180, "SAMMY IS AWESOME!!", video_buffer);
            Time_Delay(25);
            _fmemset((char far *)(video_buffer + 57600), 0, 3200);
            Tech_Print(80, 180, "YOU GET AN EXTA SHOT PER TURN!", video_buffer);
            Time_Delay(25);
            _fmemset((char far *)(video_buffer + 57600), 0, 3200);
            cheat = 1;
        }

        if(keyboard_state[MAKE_ESC])
        {
            PlayerWantsToQuit = TRUE;
            continue;
        }

        if (keyboard_state[MAKE_RIGHT])
        {
            if(++counterH > 11)
            {
                counterH = 0;
                shipPlacer.x = 9;
            }

            else
            {
                shipPlacer.x += 12;
            }
            Sound_Stop();
            Sound_Play((sound_ptr)&digital_FX[2]);
            redraw = 1;
        }

        if (keyboard_state[MAKE_LEFT])
        {
            if(--counterH < 0)
            {
                counterH = 11;
                shipPlacer.x = 141;
            }

            else
            {
                shipPlacer.x -= 12;
            }
            Sound_Stop();
            Sound_Play((sound_ptr)&digital_FX[2]);
            redraw = 1;
        }

        if (keyboard_state[MAKE_UP])
        {
            if(--counterV < 0)
            {
                counterV = 11;
                shipPlacer.y = 143;
            }

            else
            {
                shipPlacer.y -= 12;
            }
            Sound_Stop();
            Sound_Play((sound_ptr)&digital_FX[2]);
            redraw = 1;
        }

        if (keyboard_state[MAKE_DOWN])
        {
            if(++counterV > 11)
            {
                counterV = 0;
                shipPlacer.y = 11;
            }

            else
            {
                shipPlacer.y += 12;
            }
            Sound_Stop();
            Sound_Play((sound_ptr)&digital_FX[2]);
            redraw = 1;
        }

        if (redraw == 1)
        {
            // erase sprite at old position
            Sprite_Erase((sprite_ptr)&shipPlacer, video_buffer);
            // scan the background at new postition
            Sprite_Under((sprite_ptr)&shipPlacer, video_buffer);
            // draw the sprite at the new position
            Sprite_Draw((sprite_ptr)&shipPlacer, video_buffer, 1);
            // update old position
            shipPlacer.y_old = shipPlacer.y;
            shipPlacer.x_old = shipPlacer.x;

            Time_Delay(3);
            redraw = 0;
        } // end if sprites needed to be redrawn

        if(keyboard_state[MAKE_ENTER])
        {
            userShip[x].coveredSquare1.x = counterH;
            userShip[x].coveredSquare1.y = counterV;

            userShip[x].x = ((counterH * 12) + 4);
            userShip[x].y = ((counterV * 12) + 11);

            _fmemset((char far *)(video_buffer + 57600), 0, 3200);
            Tech_Print(80, 180, "HORIZONTAL OR VERTICAL (H/V)?",video_buffer);

            keyboard_state[MAKE_ENTER] = 0;

            while(!keyboard_state[MAKE_H] && !keyboard_state[MAKE_V] && !keyboard_state[MAKE_ESC]) //Wait for a key press to continue
            {
            }

            if(keyboard_state[MAKE_ESC])
            {
                _fmemset((char far *)(video_buffer + 57600), 0, 3200);
                Tech_Print(80, 180, "SHIP PLACEMENT ABORTED.",video_buffer);                    
                Time_Delay(10);
                _fmemset((char far *)(video_buffer + 57600), 0, 3200);
                keyboard_state[MAKE_ESC] = 0;
                continue;
            }

            if(keyboard_state[MAKE_H])
            {
                if(counterH > 9)
                {
                    _fmemset((char far *)(video_buffer + 57600), 0, 3200);

                    if(counterV < 10)
                    {
                        Tech_Print(80, 180, "CAN'T MAKE THIS SHIP HORIZONTAL",video_buffer);                    
                        Time_Delay(10);
                        _fmemset((char far *)(video_buffer + 57600), 0, 3200);
                        Tech_Print(80, 180, "SO MAKING IT VERTICAL.", video_buffer);
                        Time_Delay(10);
                        _fmemset((char far *)(video_buffer + 57600), 0, 3200);

                        userShip[x].coveredSquare2.x = userShip[x].coveredSquare1.x;
                        userShip[x].coveredSquare3.x = userShip[x].coveredSquare1.x;
                        userShip[x].coveredSquare2.y = userShip[x].coveredSquare1.y + 1;
                        userShip[x].coveredSquare3.y = userShip[x].coveredSquare2.y + 1;

                        if(x > 0)
                        {
                            if(gGrid[ userShip[x].coveredSquare1.x ][ userShip[x].coveredSquare1.y ].coveredByShip == TRUE ||
                            gGrid[ userShip[x].coveredSquare2.x ][ userShip[x].coveredSquare2.y ].coveredByShip == TRUE ||
                            gGrid[ userShip[x].coveredSquare3.x ][ userShip[x].coveredSquare3.y ].coveredByShip == TRUE)
                            {
                                OneATopOfAnother++;
                                flag = 1;
                                continue;
                            }
                        }

                        gGrid[counterH][counterV].coveredByWhat = &userShip[x].coveredSquare1.hit;
                        gGrid[counterH][counterV].coveredByShip = TRUE;
                        gGrid[counterH][counterV + 1].coveredByShip = TRUE;
                        gGrid[counterH][counterV + 1].coveredByWhat = &userShip[x].coveredSquare2.hit;
                        gGrid[counterH][counterV + 2].coveredByShip = TRUE;
                        gGrid[counterH][counterV + 2].coveredByWhat = &userShip[x].coveredSquare3.hit;

                        PCX_Init((pcx_picture_ptr)&background);
                        PCX_Load("vShip.pcx", (pcx_picture_ptr)&background, 0);
                        Sprite_Init((sprite_ptr)&userShip[x], userShip[x].x, userShip[x].y, userShip[x].x, userShip[x].y, 23, 35, 0, 0, 0, counterH, counterV);
                        PCX_Get_Sprite((pcx_picture_ptr)&background, (sprite_ptr)&userShip[x], 0, 0, 0);
                        PCX_Delete((pcx_picture_ptr)&background);
                        Sprite_Erase((sprite_ptr)&shipPlacer, video_buffer);
                        Sprite_Under((sprite_ptr)&userShip[x], video_buffer);
                        Sprite_Draw((sprite_ptr)&userShip[x], video_buffer, 1);
                        Sprite_Under((sprite_ptr)&shipPlacer, video_buffer);
                        Sprite_Draw((sprite_ptr)&shipPlacer, video_buffer, 1);
                        userShip[x].howManyTimesHit = 0;
                        x++;
                        Sound_Stop();
                        Sound_Play((sound_ptr)&digital_FX[4]);
                    }

                    else
                    {
                        Tech_Print(80, 180, "YOU CAN'T PUT YOUR SHIP THERE!",video_buffer);                    
                        Time_Delay(10);
                        _fmemset((char far *)(video_buffer + 57600), 0, 3200);
                    }
                }

                else
                {

                    _fmemset((char far *)(video_buffer + 57600), 0, 3200);
                    Tech_Print(95, 180, "OK, SIR!", video_buffer);
                    Time_Delay(10);
                    _fmemset((char far *)(video_buffer + 57600), 0, 3200);

                    userShip[x].coveredSquare2.y = userShip[x].coveredSquare1.y;
                    userShip[x].coveredSquare3.y = userShip[x].coveredSquare1.y;
                    userShip[x].coveredSquare2.x = userShip[x].coveredSquare1.x + 1;
                    userShip[x].coveredSquare3.x = userShip[x].coveredSquare2.x + 1;

                    if(x > 0)
                    {
                        if(gGrid[ userShip[x].coveredSquare1.x ][ userShip[x].coveredSquare1.y ].coveredByShip == TRUE ||
                        gGrid[ userShip[x].coveredSquare2.x ][ userShip[x].coveredSquare2.y ].coveredByShip == TRUE ||
                        gGrid[ userShip[x].coveredSquare3.x ][ userShip[x].coveredSquare3.y ].coveredByShip == TRUE)
                        {
                            OneATopOfAnother++;
                            flag = 1;
                            continue;
                        }
                    }

                    gGrid[counterH][counterV].coveredByWhat = &userShip[x].coveredSquare1.hit;
                    gGrid[counterH][counterV].coveredByShip = TRUE;
                    gGrid[counterH + 1][counterV].coveredByShip = TRUE;
                    gGrid[counterH + 1][counterV].coveredByWhat = &userShip[x].coveredSquare2.hit;
                    gGrid[counterH + 2][counterV].coveredByShip = TRUE;
                    gGrid[counterH + 2][counterV].coveredByWhat = &userShip[x].coveredSquare3.hit;

                    userShip[x].x += 5;
                    userShip[x].y -= 5;

                    PCX_Init((pcx_picture_ptr)&background);
                    PCX_Load("hShip.pcx", (pcx_picture_ptr)&background, 0);
                    Sprite_Init((sprite_ptr)&userShip[x], userShip[x].x, userShip[x].y, userShip[x].x, userShip[x].y, 35, 23, 0, 0, 0, counterH, counterV);
                    PCX_Get_Sprite((pcx_picture_ptr)&background, (sprite_ptr)&userShip[x], 0, 0, 0);
                    PCX_Delete((pcx_picture_ptr)&background);
                    Sprite_Erase((sprite_ptr)&shipPlacer, video_buffer);
                    Sprite_Under((sprite_ptr)&userShip[x], video_buffer);
                    Sprite_Draw((sprite_ptr)&userShip[x], video_buffer, 1);
                    Sprite_Under((sprite_ptr)&shipPlacer, video_buffer);
                    Sprite_Draw((sprite_ptr)&shipPlacer, video_buffer, 1);
                    userShip[x].howManyTimesHit = 0;
                    x++;
                    Sound_Stop();
                    Sound_Play((sound_ptr)&digital_FX[4]);
                }
            }

            if(keyboard_state[MAKE_V])
            {
                if(counterV > 9)
                {
                    _fmemset((char far *)(video_buffer + 57600), 0, 3200);

                    if(counterH < 10)
                    {
                        Tech_Print(80, 180, "CAN'T MAKE THIS SHIP VERTICAL",video_buffer);                    
                        Time_Delay(10);
                        _fmemset((char far *)(video_buffer + 57600), 0, 3200);
                        Tech_Print(80, 180, "SO MAKING IT HORIZONTAL.", video_buffer);
                        Time_Delay(10);
                        _fmemset((char far *)(video_buffer + 57600), 0, 3200);

                        userShip[x].coveredSquare2.y = userShip[x].coveredSquare1.y;
                        userShip[x].coveredSquare3.y = userShip[x].coveredSquare1.y;
                        userShip[x].coveredSquare2.x = userShip[x].coveredSquare1.x + 1;
                        userShip[x].coveredSquare3.x = userShip[x].coveredSquare2.x + 1;

                        if(x > 0)
                        {
                            if(gGrid[ userShip[x].coveredSquare1.x ][ userShip[x].coveredSquare1.y ].coveredByShip == TRUE ||
                            gGrid[ userShip[x].coveredSquare2.x ][ userShip[x].coveredSquare2.y ].coveredByShip == TRUE ||
                            gGrid[ userShip[x].coveredSquare3.x ][ userShip[x].coveredSquare3.y ].coveredByShip == TRUE)
                            {
                                OneATopOfAnother++;
                                flag = 1;
                                continue;
                            }
                        }

                        gGrid[counterH][counterV].coveredByWhat = &userShip[x].coveredSquare1.hit;
                        gGrid[counterH][counterV].coveredByShip = TRUE;
                        gGrid[counterH + 1][counterV].coveredByShip = TRUE;
                        gGrid[counterH + 1][counterV].coveredByWhat = &userShip[x].coveredSquare2.hit;
                        gGrid[counterH + 2][counterV].coveredByShip = TRUE;
                        gGrid[counterH + 2][counterV].coveredByWhat = &userShip[x].coveredSquare3.hit;

                        userShip[x].x += 5;
                        userShip[x].y -= 5;

                        PCX_Init((pcx_picture_ptr)&background);
                        PCX_Load("hShip.pcx", (pcx_picture_ptr)&background, 0);
                        Sprite_Init((sprite_ptr)&userShip[x], userShip[x].x, userShip[x].y, userShip[x].x, userShip[x].y, 35, 23, 0, 0, 0, counterH, counterV);
                        PCX_Get_Sprite((pcx_picture_ptr)&background, (sprite_ptr)&userShip[x], 0, 0, 0);
                        PCX_Delete((pcx_picture_ptr)&background);
                        Sprite_Erase((sprite_ptr)&shipPlacer, video_buffer);
                        Sprite_Under((sprite_ptr)&userShip[x], video_buffer);
                        Sprite_Draw((sprite_ptr)&userShip[x], video_buffer, 1);
                        Sprite_Under((sprite_ptr)&shipPlacer, video_buffer);
                        Sprite_Draw((sprite_ptr)&shipPlacer, video_buffer, 1);
                        userShip[x].howManyTimesHit = 0;
                        x++;
                        Sound_Stop();
                        Sound_Play((sound_ptr)&digital_FX[4]);
                    }

                    else
                    {
                        Tech_Print(80, 180, "YOU CAN'T PUT YOUR SHIP THERE!",video_buffer);                    
                        Time_Delay(10);
                        _fmemset((char far *)(video_buffer + 57600), 0, 3200);
                    }
                }

                else
                {

                    _fmemset((char far *)(video_buffer + 57600), 0, 3200);
                    Tech_Print(95, 180, "OK, SIR!", video_buffer);
                    Time_Delay(10);
                    _fmemset((char far *)(video_buffer + 57600), 0, 3200);

                    userShip[x].coveredSquare2.x = userShip[x].coveredSquare1.x;
                    userShip[x].coveredSquare3.x = userShip[x].coveredSquare1.x;
                    userShip[x].coveredSquare2.y = userShip[x].coveredSquare1.y + 1;
                    userShip[x].coveredSquare3.y = userShip[x].coveredSquare2.y + 1;

                    if(x > 0)
                    {
                        if(gGrid[ userShip[x].coveredSquare1.x ][ userShip[x].coveredSquare1.y ].coveredByShip == TRUE ||
                        gGrid[ userShip[x].coveredSquare2.x ][ userShip[x].coveredSquare2.y ].coveredByShip == TRUE ||
                        gGrid[ userShip[x].coveredSquare3.x ][ userShip[x].coveredSquare3.y ].coveredByShip == TRUE)
                        {
                            OneATopOfAnother++;
                            flag = 1;
                            continue;
                        }
                    }

                    gGrid[counterH][counterV].coveredByWhat = &userShip[x].coveredSquare1.hit;
                    gGrid[counterH][counterV].coveredByShip = TRUE;
                    gGrid[counterH][counterV + 1].coveredByShip = TRUE;
                    gGrid[counterH][counterV + 1].coveredByWhat = &userShip[x].coveredSquare2.hit;
                    gGrid[counterH][counterV + 2].coveredByShip = TRUE;
                    gGrid[counterH][counterV + 2].coveredByWhat = &userShip[x].coveredSquare3.hit;

                    PCX_Init((pcx_picture_ptr)&background);
                    PCX_Load("vShip.pcx", (pcx_picture_ptr)&background, 0);
                    Sprite_Init((sprite_ptr)&userShip[x], userShip[x].x, userShip[x].y, userShip[x].x, userShip[x].y, 23, 35, 0, 0, 0, counterH, counterV);
                    PCX_Get_Sprite((pcx_picture_ptr)&background, (sprite_ptr)&userShip[x], 0, 0, 0);
                    PCX_Delete((pcx_picture_ptr)&background);
                    Sprite_Erase((sprite_ptr)&shipPlacer, video_buffer);
                    Sprite_Under((sprite_ptr)&userShip[x], video_buffer);
                    Sprite_Draw((sprite_ptr)&userShip[x], video_buffer, 1);
                    Sprite_Under((sprite_ptr)&shipPlacer, video_buffer);
                    Sprite_Draw((sprite_ptr)&shipPlacer, video_buffer, 1);
                    userShip[x].howManyTimesHit = 0;
                    x++;
                    Sound_Stop();
                    Sound_Play((sound_ptr)&digital_FX[4]);
                }
            }
        }
    } // end local player setup

    if(PlayerWantsToQuit == FALSE)
    {
        Time_Delay(10);
        _fmemset((char far *)(video_buffer + 57600), 0, 3200);
        Tech_Print(95, 180, "NOW IT IS TIME FOR ME TO SET", video_buffer);
        Time_Delay(20);
        _fmemset((char far *)(video_buffer + 57600), 0, 3200);        
        Tech_Print(95, 180, "UP AND KICK YOUR BUTT IN THIS GAME!!", video_buffer);
        Time_Delay(20);
        _fmemset((char far *)(video_buffer + 57600), 0, 3200);
    }

    x = 0;
    while(x < 4 && PlayerWantsToQuit == FALSE)
    {
        srand((unsigned int) *clock);
        randVorH     = (int)(rand() %  2);
        randCounterV = (int)(rand() % 12);
        randCounterH = (int)(rand() % 12);

        computerShip[x].coveredSquare1.x = randCounterH;
        computerShip[x].coveredSquare1.y = randCounterV;

        computerShip[x].x = ((randCounterH * 12) + 4);
        computerShip[x].y = ((randCounterV * 12) + 11);

        if(randVorH == 1) // the computer selected a horizantal ship
        {
            computerShip[x].coveredSquare3.y = computerShip[x].coveredSquare2.y =
                computerShip[x].coveredSquare1.y;
            computerShip[x].coveredSquare2.x = computerShip[x].coveredSquare1.x + 1;
            computerShip[x].coveredSquare3.x = computerShip[x].coveredSquare2.x + 1;

            if(randCounterH > 9)
                continue;

            if(bGrid[ computerShip[x].coveredSquare1.x ][ computerShip[x].coveredSquare1.y ].coveredByShip == TRUE ||
            bGrid[ computerShip[x].coveredSquare2.x ][ computerShip[x].coveredSquare2.y ].coveredByShip == TRUE ||
            bGrid[ computerShip[x].coveredSquare3.x ][ computerShip[x].coveredSquare3.y ].coveredByShip == TRUE)
            {
                continue;
            }

            bGrid[randCounterH][randCounterV].coveredByWhat = &computerShip[x].coveredSquare1.hit;
            bGrid[randCounterH][randCounterV].coveredByShip = TRUE;
            bGrid[randCounterH + 1][randCounterV].coveredByShip = TRUE;
            bGrid[randCounterH + 1][randCounterV].coveredByWhat = &computerShip[x].coveredSquare2.hit;
            bGrid[randCounterH + 2][randCounterV].coveredByShip = TRUE;
            bGrid[randCounterH + 2][randCounterV].coveredByWhat = &computerShip[x].coveredSquare3.hit;

            computerShip[x].x += 5;
            computerShip[x].y -= 5;
            x++;
        }            

        if(randVorH == 0) // the computer selected a vertical ship
        {
            if(randCounterV > 9)
                continue;

            computerShip[x].coveredSquare3.x = computerShip[x].coveredSquare2.x =
                computerShip[x].coveredSquare1.x;
            computerShip[x].coveredSquare2.y = computerShip[x].coveredSquare1.y + 1;
            computerShip[x].coveredSquare3.y = computerShip[x].coveredSquare2.y + 1;

            if(bGrid[ computerShip[x].coveredSquare1.x ][ computerShip[x].coveredSquare1.y ].coveredByShip == TRUE ||
            bGrid[ computerShip[x].coveredSquare2.x ][ computerShip[x].coveredSquare2.y ].coveredByShip == TRUE ||
            bGrid[ computerShip[x].coveredSquare3.x ][ computerShip[x].coveredSquare3.y ].coveredByShip == TRUE)
            {
                continue;
            }

            bGrid[randCounterH][randCounterV].coveredByWhat = &computerShip[x].coveredSquare1.hit;
            bGrid[randCounterH][randCounterV].coveredByShip = TRUE;
            bGrid[randCounterH][randCounterV + 1].coveredByShip = TRUE;
            bGrid[randCounterH][randCounterV + 1].coveredByWhat = &computerShip[x].coveredSquare2.hit;
            bGrid[randCounterH][randCounterV + 2].coveredByShip = TRUE;
            bGrid[randCounterH][randCounterV + 2].coveredByWhat = &computerShip[x].coveredSquare3.hit;            
            x++;
        }                        
    }// end the while loop for the computer's setup    

    if(PlayerWantsToQuit == FALSE)
    {
        Time_Delay(10);
        _fmemset((char far *)(video_buffer + 57600), 0, 3200);
        Tech_Print(95, 180, "OK. NOW I HAVE SET UP AND", video_buffer);
        Time_Delay(20);
        _fmemset((char far *)(video_buffer + 57600), 0, 3200);        
        Tech_Print(35, 180, "I AM FLIPPING A COIN TO SEE WHO GOES FIRST.", video_buffer);
        Time_Delay(40);
        _fmemset((char far *)(video_buffer + 57600), 0, 3200);
    }

    if(PlayerWantsToQuit == TRUE)
    {
        for(index = 0; index < x; index++)
            Sprite_Delete((sprite_ptr)&userShip[index]);

        Sprite_Delete((sprite_ptr)&shipPlacer);
    }

    Sound_Stop();
}

int PlayGame(int connected)
{
    int xMovePlacer = 166, yMovePlacer = 11, theyAreInPosition = FALSE, numUserShots = 4;
    int redraw = 0, randMove;
    int index = 0, randPhraze = 0, gameEndStatus;
    music endSong;
    char madPhraze[4][38] = {
        "HOW DARE YOU?!? I LOVED THAT SHIP!   ",
        "ACK! TWAS MY FAVORITE ONE YOU SANK!  ",
        "I CANNOT BELIEVE YOU DID THAT TO ME!!",
        "YOU WILL PAY FOR THAT!!!             "
    };

    gShipsGone = bShipsGone = 0;
    if(PlayerWantsToQuit != FALSE)
        return 0;

    PCX_Init((pcx_picture_ptr)&ships_back);
    PCX_Load("xhair.pcx", (pcx_picture_ptr)&ships_back, 0);
    PCX_Get_Sprite((pcx_picture_ptr)&ships_back, (sprite_ptr)&shipPlacer, 0, 1, 0);
//    PCX_Delete((pcx_picture_ptr)&ships_back);
    Sprite_Erase((sprite_ptr)&shipPlacer, video_buffer);
    Sprite_Under((sprite_ptr)&shipPlacer, video_buffer);
    Sprite_Draw((sprite_ptr)&shipPlacer, video_buffer, 1);

//    PCX_Init((pcx_picture_ptr)&ships_back);
    PCX_Load("xhair.pcx", (pcx_picture_ptr)&ships_back, 0);
    Sprite_Init((sprite_ptr)&shotCovering, 9, 11, 9, 11, 11, 11, 0, 0, 0, 0, 0);
    PCX_Get_Sprite((pcx_picture_ptr)&ships_back, (sprite_ptr)&shotCovering, 0, 3, 0);
//    PCX_Delete((pcx_picture_ptr)&ships_back);    
 //   Sprite_Delete((sprite_ptr)&shotCovering);

//    PCX_Init((pcx_picture_ptr)&ships_back);
    PCX_Load("xhair.pcx", (pcx_picture_ptr)&ships_back, 0);
    Sprite_Init((sprite_ptr)&missCovering, 9, 11, 9, 11, 11, 11, 0, 0, 0, 0, 0);
    PCX_Get_Sprite((pcx_picture_ptr)&ships_back, (sprite_ptr)&missCovering, 0, 2, 0);
    PCX_Delete((pcx_picture_ptr)&ships_back);    
 //   Sprite_Delete((sprite_ptr)&missCovering);

    srand((unsigned int) *clock);
    randMove = (rand()% 2);

    if(randMove == 0)
    {
        _fmemset((char far *)(video_buffer + 57600), 0, 3200);
        Tech_Print(95, 180, "YOU GET FIRST MOVE.", video_buffer);
        Music_Stop();
        Music_Unload((music_ptr)&song);
        Music_Load("mars.xmi", (music_ptr)&song);
        Music_Play((music_ptr)&song,0);
        Time_Delay(25);
        _fmemset((char far *)(video_buffer + 57600), 0, 3200);
    }

    if(randMove == 1)
    {
        _fmemset((char far *)(video_buffer + 57600), 0, 3200);
        Tech_Print(95, 180, "I GET FIRST MOVE!", video_buffer);
        Time_Delay(25);
        _fmemset((char far *)(video_buffer + 57600), 0, 3200);
        Music_Stop();
        computersTurn();
        if(cheat == 1)
            numUserShots = ((4 - gShipsGone) + 1);
        if(cheat == 0)
            numUserShots = 4 - gShipsGone;

}

    while(theyAreInPosition == FALSE)
    {
        if(shipPlacer.x < xMovePlacer)
        {
            if((xMovePlacer - shipPlacer.x) > (yMovePlacer - shipPlacer.y))
                shipPlacer.x++;

            else if((xMovePlacer - shipPlacer.x) == (yMovePlacer - shipPlacer.y))
                shipPlacer.x++;

            else
                shipPlacer.x+=3;
        }

        if(shipPlacer.x > xMovePlacer)
        {
            if((xMovePlacer - shipPlacer.x) > (yMovePlacer - shipPlacer.y))
                shipPlacer.x--;

            else if((xMovePlacer - shipPlacer.x) == (yMovePlacer - shipPlacer.y))
                shipPlacer.x--;

            else
                shipPlacer.x--;
        }

        if(shipPlacer.y < yMovePlacer)
        {
            if((xMovePlacer - shipPlacer.x) > (yMovePlacer - shipPlacer.y))
                shipPlacer.y++;

            else if((xMovePlacer - shipPlacer.x) == (yMovePlacer - shipPlacer.y))
                shipPlacer.y++;

            else
                shipPlacer.y+=3;
        }

        if(shipPlacer.y > yMovePlacer)
        {
            if((xMovePlacer - shipPlacer.x) > (yMovePlacer - shipPlacer.y))
                shipPlacer.y--;

            else if((xMovePlacer - shipPlacer.x) == (yMovePlacer - shipPlacer.y))
                shipPlacer.y--;

            else
                shipPlacer.y--;
        }

        if(shipPlacer.x == xMovePlacer && shipPlacer.y == yMovePlacer)
            theyAreInPosition = TRUE;

        Sprite_Erase((sprite_ptr)&shipPlacer, video_buffer);
        Sprite_Under((sprite_ptr)&shipPlacer, video_buffer);
        Sprite_Draw((sprite_ptr)&shipPlacer, video_buffer, 1);        
        // update old position
        shipPlacer.y_old = shipPlacer.y;
        shipPlacer.x_old = shipPlacer.x;
        Time_Delay(1);
    }

    while(!keys_active) //Wait for a key press to continue
    {
        if (Music_Status()==2 || Music_Status()==0)
        {
            Music_Stop();
            Music_Play((music_ptr)&song,0);
        }
    }

    Music_Stop();

    counterH = counterV = 0;

    while((bShipsGone < 4 && gShipsGone < 4) && PlayerWantsToQuit == FALSE) 
    {
        if(keyboard_state[MAKE_ESC])
        {
            PlayerWantsToQuit = TRUE;
            continue;
        }

        if (keyboard_state[MAKE_RIGHT])
        {
            if(++counterH > 11)
            {
                counterH = 0;
                shipPlacer.x = 166;
            }

            else
            {
                shipPlacer.x += 12;
            }
            Sound_Stop();
            Sound_Play((sound_ptr)&digital_FX[2]);
            redraw = 1;
        }

        if (keyboard_state[MAKE_LEFT])
        {
            if(--counterH < 0)
            {
                counterH = 11;
                shipPlacer.x = 298;
            }

            else
            {
                shipPlacer.x -= 12;
            }
            Sound_Stop();
            Sound_Play((sound_ptr)&digital_FX[2]);
            redraw = 1;
        }

        if (keyboard_state[MAKE_UP])
        {
            if(--counterV < 0)
            {
                counterV = 11;
                shipPlacer.y = 143;
            }

            else
            {
                shipPlacer.y -= 12;
            }
            Sound_Stop();
            Sound_Play((sound_ptr)&digital_FX[2]);
            redraw = 1;
        }

        if (keyboard_state[MAKE_DOWN])
        {
            if(++counterV > 11)
            {
                counterV = 0;
                shipPlacer.y = 11;
            }

            else
            {
                shipPlacer.y += 12;
            }
            Sound_Stop();
            Sound_Play((sound_ptr)&digital_FX[2]);
            redraw = 1;
        }

        if(keyboard_state[MAKE_ENTER])
        {
            keyboard_state[MAKE_ENTER] = 0;
            
            if(bGrid[counterH][counterV].coveredByShip == FALSE) // user shot and missed
            {
                if(bGrid[counterH][counterV].beenShotAt == FALSE)
                {
                    bGrid[counterH][counterV].beenShotAt = TRUE;
                    missCovering.x = missCovering.x_old = ((counterH * 12) + 166);
                    missCovering.y = missCovering.y_old = ((counterV * 12) +  11);
                    Sprite_Erase((sprite_ptr)&shipPlacer, video_buffer);
                    Sprite_Draw((sprite_ptr)&missCovering, video_buffer, 1);        
                    Sprite_Under((sprite_ptr)&shipPlacer, video_buffer);
                    Sprite_Draw((sprite_ptr)&shipPlacer, video_buffer, 1);
                    Sound_Stop();
                    Sound_Play((sound_ptr)&digital_FX[5]);

                    numUserShots--;

                    if(numUserShots == 0)
                    {
                        computersTurn();
                        if(cheat == 1)
                            numUserShots = ((4 - gShipsGone) + 1);
                        if(cheat == 0)
                        numUserShots = 4 - gShipsGone;
                    }
                    
                    continue;
                }

                else
                {
                    _fmemset((char far *)(video_buffer + 57600), 0, 3200);
                    Tech_Print(75, 180, "YOU ALREADY SHOT AND MISSED THERE, DAMNIT!", video_buffer);
                    Time_Delay(20);
                    _fmemset((char far *)(video_buffer + 57600), 0, 3200);
                    continue;
                }               
            }

            if(bGrid[counterH][counterV].coveredByShip == TRUE) // user shot and hit!
            {
                if(bGrid[counterH][counterV].beenShotAt == FALSE)
                {                
                    bGrid[counterH][counterV].beenShotAt = TRUE;
                    shotCovering.x = shotCovering.x_old = ((counterH * 12) + 166);
                    shotCovering.y = shotCovering.y_old = ((counterV * 12) +  11);
                    *bGrid[counterH][counterV].coveredByWhat = TRUE; //notify the ship that covered
                                                                     //this position that it was
                                                                     //hit!!
                    Sprite_Erase((sprite_ptr)&shipPlacer, video_buffer);
                    Sound_Stop();
                    Sound_Play((sound_ptr)&digital_FX[5]);

                    Time_Delay(50);
                    Sound_Stop();
                    Sprite_Draw((sprite_ptr)&shotCovering, video_buffer, 1);        
                    Sound_Play((sound_ptr)&digital_FX[6]);
                    Time_Delay(30);
                    Sprite_Under((sprite_ptr)&shipPlacer, video_buffer);
                    Sprite_Draw((sprite_ptr)&shipPlacer, video_buffer, 1);

                    numUserShots--;

                    for(index = 0; index < 4; index++) //loop through all the computer's ships
                    {
                        if(computerShip[index].coveredSquare1.x == counterH &&
                           computerShip[index].coveredSquare1.y == counterV ||
                           computerShip[index].coveredSquare2.x == counterH &&
                           computerShip[index].coveredSquare2.y == counterV ||
                           computerShip[index].coveredSquare3.x == counterH &&
                           computerShip[index].coveredSquare3.y == counterV)
                        {
                            computerShip[index].howManyTimesHit++;

                            if(computerShip[index].howManyTimesHit == 3)
                            {
                                srand((unsigned int) *clock);
                                randPhraze = (int)(rand() % 4);

                                _fmemset((char far *)(video_buffer + 57600), 0, 3200);
                                Tech_Print(75, 180, &madPhraze[randPhraze], video_buffer);
                                Time_Delay(20);
                                _fmemset((char far *)(video_buffer + 57600), 0, 3200);

                                bShipsGone++;
                                break;
                            }
                        }
                    }

                    if(numUserShots == 0)
                    {
                        computersTurn();
                        if(cheat == 1)
                            numUserShots = ((4 - gShipsGone) + 1);
                        if(cheat == 0)
                        numUserShots = 4 - gShipsGone;
                    }
                    continue;
                }

                else
                {
                    _fmemset((char far *)(video_buffer + 57600), 0, 3200);
                    Tech_Print(95, 180, "YOU ALREADY SHOT THERE, DAMNIT!", video_buffer);
                    Time_Delay(20);
                    _fmemset((char far *)(video_buffer + 57600), 0, 3200);
                    continue;
                }
            }
        }
        if (redraw == 1)
        {
            // erase sprite at old position
            Sprite_Erase((sprite_ptr)&shipPlacer, video_buffer);
            // scan the background at new postition
            Sprite_Under((sprite_ptr)&shipPlacer, video_buffer);
            // draw the sprite at the new position
            Sprite_Draw((sprite_ptr)&shipPlacer, video_buffer, 1);
            // update old position
            shipPlacer.y_old = shipPlacer.y;
            shipPlacer.x_old = shipPlacer.x;

            Time_Delay(3);
            redraw = 0;
        } // end if sprites needed to be redrawn
    } // end game loop

    if(bShipsGone == 4)
    {
        Screen_Transition(SCREEN_DARKNESS);
        Music_Stop();
        Music_Load("endhapy.xmi", (music_ptr)&endSong);
        Music_Play((music_ptr)&endSong,0);
        PCX_Init((pcx_picture_ptr)&background);
        PCX_Load("lose.pcx", (pcx_picture_ptr)&background, 0); //as in the computer lost
        PCX_Show_Buffer((pcx_picture_ptr)&background, 1);
        PCX_Delete((pcx_picture_ptr)&background);
        keys_active = 0;
        while(!keys_active) //Wait for a key press to continue
        {
        }
        Music_Stop();
        Music_Unload(&endSong);
        Screen_Transition(SCREEN_DARKNESS);
    }

    if(gShipsGone == 4)
    {
        Screen_Transition(SCREEN_DARKNESS);
        Music_Stop();
        Music_Load("farmer.xmi", (music_ptr)&endSong);
        Music_Play((music_ptr)&endSong,0);
        PCX_Init((pcx_picture_ptr)&background);
        PCX_Load("roundup.pcx", (pcx_picture_ptr)&background, 0);
        PCX_Show_Buffer((pcx_picture_ptr)&background, 1);
        PCX_Delete((pcx_picture_ptr)&background);
        keys_active = 0;
        while(!keys_active) //Wait for a key press to continue
        {
        }
        Music_Stop();
        Music_Unload(&endSong);
        Screen_Transition(SCREEN_DARKNESS);
    }
                
    Sprite_Delete((sprite_ptr)&shotCovering);
    return 1;
}

int computersTurn() // 8-)
{
    int theyAreInPosition = FALSE;
    int xMovePlacer = 9;
    int yMovePlacer = 11;
    int computerIsDone = FALSE, nextStopX, nextStopY;
    static int guessX, guessY;
    int index = 0, hangCounter = 0, tempDir = 0, tempGuessX, tempGuessY;

    counterH = counterV = 0;
    numComputerShots = 4 - bShipsGone;

    if(bShipsGone >= 4)
        return 0;

    while(theyAreInPosition == FALSE)
    {
        if(shipPlacer.x < xMovePlacer)
        {
            if((xMovePlacer - shipPlacer.x) > (yMovePlacer - shipPlacer.y))
                shipPlacer.x++;

            else if((xMovePlacer - shipPlacer.x) == (yMovePlacer - shipPlacer.y))
                shipPlacer.x++;

            else
                shipPlacer.x++;
        }

        if(shipPlacer.x > xMovePlacer)
        {
            if((xMovePlacer - shipPlacer.x) > (yMovePlacer - shipPlacer.y))
                shipPlacer.x-=3;

            else if((xMovePlacer - shipPlacer.x) == (yMovePlacer - shipPlacer.y))
                shipPlacer.x-=3;

            else
                shipPlacer.x-=3;
        }

        if(shipPlacer.y < yMovePlacer)
        {
            if((xMovePlacer - shipPlacer.x) > (yMovePlacer - shipPlacer.y))
                shipPlacer.y++;

            else if((xMovePlacer - shipPlacer.x) == (yMovePlacer - shipPlacer.y))
                shipPlacer.y++;

            else
                shipPlacer.y++;
        }

        if(shipPlacer.y > yMovePlacer)
        {
            if((xMovePlacer - shipPlacer.x) > (yMovePlacer - shipPlacer.y))
                shipPlacer.y-=3;

            else if((xMovePlacer - shipPlacer.x) == (yMovePlacer - shipPlacer.y))
                shipPlacer.y-=3;

            else
                shipPlacer.y-=3;
        }

        if(shipPlacer.x == xMovePlacer && shipPlacer.y == yMovePlacer)
            theyAreInPosition = TRUE;

        Sprite_Erase((sprite_ptr)&shipPlacer, video_buffer);
        Sprite_Under((sprite_ptr)&shipPlacer, video_buffer);
        Sprite_Draw((sprite_ptr)&shipPlacer, video_buffer, 1);        
        // update old position
        shipPlacer.y_old = shipPlacer.y;
        shipPlacer.x_old = shipPlacer.x;
        Time_Delay(1);
    }

    while(computerIsDone == FALSE)
    {
        srand((unsigned int) *clock);

        nextStopX = (rand() % 12);
        nextStopY = (rand() % 12);

        if(hitFlag == 0)
        {
              makeHarder(&guessX, &guessY);
//            guessX = (rand() % 12);        
//            guessY = (rand() % 12);
        }

        if(gGrid[guessX][guessY].beenShotAt == TRUE && hitFlag == 0)
            continue;


        if(hitFlag == 1)
        {
            tempGuessX = guessX; //holds old if need it
            tempGuessY = guessY;

            if(curDirection == 0) // up
            {
                tempGuessY = guessY;
                guessY--;
                direction[curDirection]++;
            }

            if(curDirection == 1) // down
            {
                tempGuessY = guessY;
                guessY++;
                direction[curDirection]++;
            }

            if(curDirection == 2) //left
            {
                tempGuessX = guessX;
                guessX--;
                direction[curDirection]++;
            }

            if(curDirection == 3) // right
            {
                tempGuessX = guessX;
                guessX++;
                direction[curDirection]++;
            }
            
            if(direction[0] > 0 && (guessY < 0 || gGrid[guessX][guessY + 1].coveredByShip == FALSE || gGrid[guessX][guessY].beenShotAt == TRUE)) //wants to go up; but can't
            {
                guessY += direction[curDirection];
                direction[0] = 0;
                while(curDirection == 0) //keep a-try'n
                {
                    curDirection = (rand()% 4);
                }
                continue;
            }

            if(direction[1] > 0 && (guessY > 11 || gGrid[guessX][guessY - 1].coveredByShip == FALSE || gGrid[guessX][guessY].beenShotAt == TRUE)) //wants to go down; but can't
            {
                guessY -= direction[curDirection];
                direction[1] = 0;
                while(curDirection == 1) //keep a-try'n
                {
                    curDirection = (rand()% 4);
                }
                continue;
            }

            if(direction[2] > 0 && (guessX < 0 || gGrid[guessX + 1][guessY].coveredByShip == FALSE || gGrid[guessX][guessY].beenShotAt == TRUE)) //wants to go left; but can't
            {
                guessX += direction[curDirection];
                direction[2] = 0;
                while(curDirection == 2) //keep a-try'n
                {
                    curDirection = (rand()% 4);
                }
                continue;
            }

            if(direction[3] > 0 && (guessX > 11 || gGrid[guessX - 1][guessY].coveredByShip == FALSE || gGrid[guessX][guessY].beenShotAt == TRUE)) //wants to go right; but can't
            {
                guessX -= direction[curDirection];
                direction[3] = 0;
                while(curDirection == 3) //keep a-try'n
                {
                    curDirection = (rand()% 4);
                }
                continue;
            }

        }

        if(gGrid[guessX][guessY].beenShotAt == TRUE && hitFlag == 1)
        {
            direction[curDirection] = 0;
            guessX = tempGuessX;
            guessY = tempGuessY;
            tempDir = curDirection;
            while(curDirection == tempDir) //keep a-try'n
            {
                curDirection = (rand()% 4);
            }
            continue;
        }

        theyAreInPosition = FALSE;
        while(theyAreInPosition == FALSE && hitFlag != 1)
        {
            if(counterH < nextStopX)
                counterH++;

            if(counterH > nextStopX)
                counterH--;

            if(counterV < nextStopY)
                counterV++;

            if(counterV > nextStopY)
                counterV--;

            shipPlacer.x = ((counterH * 12) + 9 );
            shipPlacer.y = ((counterV * 12) + 11);

            Sprite_Erase((sprite_ptr)&shipPlacer, video_buffer);
            Sprite_Under((sprite_ptr)&shipPlacer, video_buffer);
            Sprite_Draw((sprite_ptr)&shipPlacer, video_buffer, 1);

            shipPlacer.x_old = shipPlacer.x;
            shipPlacer.y_old = shipPlacer.y;

            if(counterH == nextStopX && counterV == nextStopY)
                theyAreInPosition = TRUE;

            Sound_Stop();
            Sound_Play((sound_ptr)&digital_FX[2]);
            Time_Delay((rand() % 5 + 7));
        }

        theyAreInPosition = FALSE;
        while(theyAreInPosition == FALSE)
        {
            if(counterH < guessX)
                counterH++;

            if(counterH > guessX)
                counterH--;

            if(counterV < guessY)
                counterV++;

            if(counterV > guessY)
                counterV--;

            shipPlacer.x = ((counterH * 12) + 9 );
            shipPlacer.y = ((counterV * 12) + 11);

            Sprite_Erase((sprite_ptr)&shipPlacer, video_buffer);
            Sprite_Under((sprite_ptr)&shipPlacer, video_buffer);
            Sprite_Draw((sprite_ptr)&shipPlacer, video_buffer, 1);

            shipPlacer.x_old = shipPlacer.x;
            shipPlacer.y_old = shipPlacer.y;

            if(counterH == guessX && counterV == guessY)
                theyAreInPosition = TRUE;

            Sound_Stop();
            Sound_Play((sound_ptr)&digital_FX[2]);
            Time_Delay((rand() % 5 + 7));
        }        

        //S H O O T !
        if(gGrid[counterH][counterV].coveredByShip == FALSE) // computer shot and missed
        {
            if(gGrid[counterH][counterV].beenShotAt == FALSE)
            {
                gGrid[counterH][counterV].beenShotAt = TRUE;
                missCovering.x = missCovering.x_old = ((counterH * 12) + 9);
                missCovering.y = missCovering.y_old = ((counterV * 12) +  11);
                Sprite_Erase((sprite_ptr)&shipPlacer, video_buffer);
                Sprite_Draw((sprite_ptr)&missCovering, video_buffer, 1);        
                Sprite_Under((sprite_ptr)&shipPlacer, video_buffer);
                Sprite_Draw((sprite_ptr)&shipPlacer, video_buffer, 1);
                Sound_Stop();
                Sound_Play((sound_ptr)&digital_FX[5]);
                Time_Delay(10);

                numComputerShots--;

                if(numComputerShots == 0)
                {
                    computerIsDone = TRUE;
                }
                                                        
                continue;
            } 
        }

        if(gGrid[counterH][counterV].coveredByShip == TRUE) // computer shot and hit!
        {
            if(gGrid[counterH][counterV].beenShotAt == FALSE)
            {                
                gGrid[counterH][counterV].beenShotAt = TRUE;
                shotCovering.x = shotCovering.x_old = ((counterH * 12) + 9);
                shotCovering.y = shotCovering.y_old = ((counterV * 12) +  11);
                *gGrid[counterH][counterV].coveredByWhat = TRUE; //notify the ship that covered
                                                                 //this position that it was
                                                                 //hit!!
                Sprite_Erase((sprite_ptr)&shipPlacer, video_buffer);
                Sound_Stop();
                Sound_Play((sound_ptr)&digital_FX[5]);

                Time_Delay(50);
                Sound_Stop();
                Sprite_Draw((sprite_ptr)&shotCovering, video_buffer, 1);        
                Sound_Play((sound_ptr)&digital_FX[6]);
                Time_Delay(30);
                Sprite_Under((sprite_ptr)&shipPlacer, video_buffer);
                Sprite_Draw((sprite_ptr)&shipPlacer, video_buffer, 1);
                if (hitFlag == 0)
                    curDirection = rand() %4; //random direction for the first go
                hitFlag = 1;
                numComputerShots--;

                for(index = 0; index < 4; index++) //loop through all the user's ships
                {
                    if((userShip[index].coveredSquare1.x == counterH &&
                       userShip[index].coveredSquare1.y == counterV) ||
                       (userShip[index].coveredSquare2.x == counterH &&
                       userShip[index].coveredSquare2.y == counterV) ||
                       (userShip[index].coveredSquare3.x == counterH &&
                       userShip[index].coveredSquare3.y == counterV))
                    {
                        userShip[index].howManyTimesHit++;

                        if(userShip[index].howManyTimesHit == 3)
                        {
                            /*srand((unsigned int) *clock);
                            randPhraze = (int)(rand() % 4);*/

                            _fmemset((char far *)(video_buffer + 57600), 0, 3200);
                            Tech_Print(75, 180, "HA HA! GOTCHA!", video_buffer);
                            Time_Delay(20);
                            _fmemset((char far *)(video_buffer + 57600), 0, 3200);

                            for(index = 0; index < 4; index++)
                                direction[index] = 0;

                            Sound_Stop();
                            Sound_Play((sound_ptr)&digital_FX[7]);
                            Time_Delay(120);                            
                            hitFlag = 0;
                            gShipsGone++;
                            break;
                        }
                    }
                }

                if(gShipsGone == 4)
                    return 0;

                if(numComputerShots <= 0)
                {
                    computerIsDone = TRUE;
                }
                continue;
            }
        }
        Time_Delay(18);
    } // end while coputerIsDone == FALSE

    xMovePlacer = 166;
    yMovePlacer = 11;
    
    theyAreInPosition = FALSE;
    while(theyAreInPosition == FALSE)
    {
        if(shipPlacer.x < xMovePlacer)
        {
            if((xMovePlacer - shipPlacer.x) > (yMovePlacer - shipPlacer.y))
                shipPlacer.x+=3;

            else if((xMovePlacer - shipPlacer.x) == (yMovePlacer - shipPlacer.y))
                shipPlacer.x+=3;

            else
                shipPlacer.x+=3;
        }

        if(shipPlacer.x > xMovePlacer)
        {
            if((xMovePlacer - shipPlacer.x) > (yMovePlacer - shipPlacer.y))
                shipPlacer.x--;

            else if((xMovePlacer - shipPlacer.x) == (yMovePlacer - shipPlacer.y))
                shipPlacer.x--;

            else
                shipPlacer.x--;
        }

        if(shipPlacer.y < yMovePlacer)
        {
            if((xMovePlacer - shipPlacer.x) > (yMovePlacer - shipPlacer.y))
                shipPlacer.y+=3;

            else if((xMovePlacer - shipPlacer.x) == (yMovePlacer - shipPlacer.y))
                shipPlacer.y+=3;

            else
                shipPlacer.y+=3;
        }

        if(shipPlacer.y > yMovePlacer)
        {
            if((xMovePlacer - shipPlacer.x) > (yMovePlacer - shipPlacer.y))
                shipPlacer.y-=3;

            else if((xMovePlacer - shipPlacer.x) == (yMovePlacer - shipPlacer.y))
                shipPlacer.y-=3;

            else
                shipPlacer.y-=3;
        }

        if(shipPlacer.x == xMovePlacer && shipPlacer.y == yMovePlacer)
            theyAreInPosition = TRUE;

        Sprite_Erase((sprite_ptr)&shipPlacer, video_buffer);
        Sprite_Under((sprite_ptr)&shipPlacer, video_buffer);
        Sprite_Draw((sprite_ptr)&shipPlacer, video_buffer, 1);        
        // update old position
        shipPlacer.y_old = shipPlacer.y;
        shipPlacer.x_old = shipPlacer.x;
        Time_Delay(1);
    }

    counterH = 0;
    counterV = 0;
}

void creadits(void)
{
    sprite bouncer;
    pcx_picture cool_back;
    int xVelo, yVelo;
    Sound boing;

    Sound_Load("boing.voc",(sound_ptr)&boing,1);

    srand((unsigned int) *clock);

    xVelo = ((rand()%3) + 1);
    yVelo = ((rand()%3) + 1);

    Screen_Transition(SCREEN_DARKNESS);
    PCX_Init((pcx_picture_ptr)&cool_back);
    PCX_Load("credits.pcx", (pcx_picture_ptr)&cool_back, 0);
    PCX_Show_Buffer((pcx_picture_ptr)&cool_back, 1);
    
//    PCX_Init((pcx_picture_ptr)&cool_back);
    PCX_Load("vShip.pcx", (pcx_picture_ptr)&cool_back, 0);
    Sprite_Init((sprite_ptr)&bouncer, 160, 100, 160, 100, 23, 35, 0, 0, 0, 0, 0);

    PCX_Get_Sprite((pcx_picture_ptr)&cool_back, (sprite_ptr)&bouncer, 0, 0, 0);

    Tech_Print(10, 40,  "TOM NELSON",video_buffer);
    Tech_Print(20, 50,  "DEBUGGING DUDE",video_buffer);
    Tech_Print(10, 60,  "JOE NELSON",video_buffer);
    Tech_Print(20, 70,  "SUPER CODER!",video_buffer);
    Tech_Print(10, 80,  "NATE SOBERG",video_buffer);
    Tech_Print(20, 90,  "SOUND DISTRIBUTER",video_buffer);
    Tech_Print(10, 100, "CORDELL WESSELINK",video_buffer);
    Tech_Print(20, 110, "TESTING GUY",video_buffer);
    Tech_Print(10, 120, "BRIAN HOSCHEIT",video_buffer);
    Tech_Print(20, 130, "AWESOME ARTIST!",video_buffer);
    Tech_Print(10, 140, "MATIAS RUDOLPH",video_buffer);
    Tech_Print(20, 150, "GOOD INTENTION GUY :-)",video_buffer);
    Tech_Print(10, 160, "STACY KINGSTON",video_buffer);
    Tech_Print(20, 170, "CHEAT-CODE INSPIRATION! XOXOXOXOXO!!!",video_buffer);

    Sprite_Under((sprite_ptr)&bouncer, video_buffer);
    Sprite_Draw((sprite_ptr)&bouncer, video_buffer, 1);

    keys_active = 0;
    while(!keys_active) //Wait for a key press to continue
    {
        if (Music_Status()==2 || Music_Status()==0) //keep the music go'n
        {
            Music_Stop();
            Music_Play((music_ptr)&song, 0);
        }

        if(bouncer.x < 4  )
        {
            Sound_Stop();
            Sound_Play((sound_ptr)&boing);
            xVelo = -xVelo;
        }
        
        if(bouncer.x > 294)
        {
            Sound_Stop();
            Sound_Play((sound_ptr)&boing);
            xVelo = -xVelo;
        }
        
        if(bouncer.y < 4  )
        {
            Sound_Stop();
            Sound_Play((sound_ptr)&boing);
            yVelo = -yVelo;
        }
        
        if(bouncer.y > 152)
        {
            Sound_Stop();
            Sound_Play((sound_ptr)&boing);
            yVelo = -yVelo;
        }

        bouncer.x += xVelo;
        bouncer.y += yVelo;

        Sprite_Erase((sprite_ptr)&bouncer, video_buffer);
        Sprite_Under((sprite_ptr)&bouncer, video_buffer);
        Sprite_Draw((sprite_ptr)&bouncer, video_buffer, 1);
        bouncer.x_old = bouncer.x;
        bouncer.y_old = bouncer.y;
        Wait_For_Vertical_Retrace();
    }

    Sound_Unload((sound_ptr)&boing);
    Sprite_Delete(&bouncer);
    PCX_Delete(&cool_back);
    Screen_Transition(SCREEN_DARKNESS);
}

int intro(void)
{
    sprite ship, theShell;
    music theMusic;
    Sound boom;
    int notDone = FALSE, index = 0;

    Music_Stop();
    Music_Load("sweet.xmi", (music_ptr)&theMusic);
    Music_Play((music_ptr)&song,0);
    Screen_Transition(SCREEN_DARKNESS);
    PCX_Init((pcx_picture_ptr)&background);
    PCX_Load("scene.pcx", (pcx_picture_ptr)&background, 0);
    PCX_Show_Buffer((pcx_picture_ptr)&background, 1);

    PCX_Load("bShip1.pcx", (pcx_picture_ptr)&background, 0);
    Sprite_Init((sprite_ptr)&ship, 80, 130, 80, 130, 200, 78, 0, 0, 0, 0, 0);
    PCX_Get_Sprite((pcx_picture_ptr)&background, (sprite_ptr)&ship, 0, 0, 0);

    Sprite_Under((sprite_ptr)&ship, video_buffer);
    Sprite_Draw((sprite_ptr)&ship, video_buffer, 1);

    PCX_Load("sTorp.pcx", (pcx_picture_ptr)&background, 0);
    Sprite_Init((sprite_ptr)&theShell, 0, 0, 0, 0, 24, 24, 0, 0, 0, 0, 0);
    PCX_Get_Sprite((pcx_picture_ptr)&background, (sprite_ptr)&theShell, 0, 0, 0);

    for(index = 0; index < 100; index++)
    {
        if(keyboard_state[MAKE_ESC])
        {
            Sprite_Delete(&theShell);
            Sprite_Delete(&ship);
            Sound_Stop();
            Sound_Unload((sound_ptr)&boom);
            Music_Load("menu.xmi", (music_ptr)&song);
            Music_Play((music_ptr)&song,0);
            return 0;
        }
        Time_Delay(1);
    }

    Sound_Load("shot.voc",(sound_ptr)&boom,1);
    Sound_Play((sound_ptr)&boom);

    for(index = 0; index < 25; index++)
    {
        if(keyboard_state[MAKE_ESC])
        {
            Sprite_Delete(&theShell);
            Sprite_Delete(&ship);
            Sound_Stop();
            Sound_Unload((sound_ptr)&boom);
            Music_Load("menu.xmi", (music_ptr)&song);
            Music_Play((music_ptr)&song,0);
            return 0;
        }
        Time_Delay(1);
    }


    Sprite_Under((sprite_ptr)&theShell, video_buffer);
    Sprite_Draw((sprite_ptr)&theShell, video_buffer, 1);

    while(notDone == FALSE && !keyboard_state[MAKE_ESC])
    {
        if(theShell.x >= 100 && theShell.y >= 121)
            notDone = TRUE;

        theShell.x += 5;
        theShell.y += 5;
        // erase sprite at old position
        Sprite_Erase((sprite_ptr)&theShell, video_buffer);
        // scan the background at new postition
        Sprite_Under((sprite_ptr)&theShell, video_buffer);
        // draw sprite at new position
        Sprite_Draw((sprite_ptr)&theShell, video_buffer, 1);
        // update old position
        theShell.x_old = theShell.x;
        theShell.y_old = theShell.y;
        Time_Delay(1);
    }

    notDone = FALSE;
    if(keyboard_state[MAKE_ESC])
    {
        Sprite_Delete(&theShell);
        Sprite_Delete(&ship);
        Sound_Stop();
        Sound_Unload((sound_ptr)&boom);
        Music_Load("menu.xmi", (music_ptr)&song);
        Music_Play((music_ptr)&song,0);
        return 0;
    }

    // erase sprite at old position
    Sprite_Erase((sprite_ptr)&theShell, video_buffer);
    Sprite_Erase((sprite_ptr)&ship, video_buffer);

    PCX_Load("expShip.pcx", (pcx_picture_ptr)&background, 0);
    PCX_Get_Sprite((pcx_picture_ptr)&background, (sprite_ptr)&ship, 0, 0, 0);

    // scan the background at new postition
    Sprite_Under((sprite_ptr)&ship, video_buffer);
    // draw sprite at new position
    Sprite_Draw((sprite_ptr)&ship, video_buffer, 1);

    Sound_Stop();
    Sound_Unload((sound_ptr)&boom);
    Sound_Load("blowup.voc",(sound_ptr)&boom,1);
    Sound_Play((sound_ptr)&boom);
    Music_Stop();
    Music_Unload((music_ptr)&song);
    Music_Load("menu.xmi", (music_ptr)&song);
    Music_Play((music_ptr)&song,0);

    for(index = 0; index < 50; index++)
    {
        if(keyboard_state[MAKE_ESC])
        {
            Sprite_Delete(&theShell);
            Sprite_Delete(&ship);
            Sound_Stop();
            Sound_Unload((sound_ptr)&boom);
            Music_Load("menu.xmi", (music_ptr)&song);
            Music_Play((music_ptr)&song,0);
            return 0;
        }
        Time_Delay(1);
    }

    PCX_Load("sign.pcx", (pcx_picture_ptr)&background, 0);
    Sprite_Init((sprite_ptr)&theShell, 80, 0, 80, 0, 182, 82, 0, 0, 0, 0, 0);
    PCX_Get_Sprite((pcx_picture_ptr)&background, (sprite_ptr)&theShell, 0, 0, 0);
    Sound_Stop();
    Sound_Unload((sound_ptr)&boom);
    Sound_Load("shot.voc",(sound_ptr)&boom,1);
    Sound_Play((sound_ptr)&boom);
    for(index = 0; index < 35; index++)
    {
        if(keyboard_state[MAKE_ESC])
        {
            Sprite_Delete(&theShell);
            Sprite_Delete(&ship);
            Sound_Stop();
            Sound_Unload((sound_ptr)&boom);
            Music_Load("menu.xmi", (music_ptr)&song);
            Music_Play((music_ptr)&song,0);
            return 0;
        }
        Time_Delay(1);
    }


    // scan the background at new position
    Sprite_Under((sprite_ptr)&theShell, video_buffer);
    // draw sprite at new position
    Sprite_Draw((sprite_ptr)&theShell, video_buffer, 1);    

    while(theShell.y < 70 && !keyboard_state[MAKE_ESC])
    {
        theShell.y += 5;
        // erase sprite at old position
        Sprite_Erase((sprite_ptr)&theShell, video_buffer);
        // scan the background at new postition
        Sprite_Under((sprite_ptr)&theShell, video_buffer);
        // draw sprite at new position
        Wait_For_Vertical_Retrace();
        Sprite_Draw((sprite_ptr)&theShell, video_buffer, 1);
//        Time_Delay(1);
        // update old position
        theShell.y_old = theShell.y;
        theShell.x_old = theShell.x;
    }

    for(index = 0; index < 50; index++)
    {
        if(keyboard_state[MAKE_ESC])
        {
            Sprite_Delete(&theShell);
            Sprite_Delete(&ship);
            Sound_Stop();
            Sound_Unload((sound_ptr)&boom);
            Music_Load("menu.xmi", (music_ptr)&song);
            Music_Play((music_ptr)&song,0);
            return 0;
        }
        Time_Delay(1);
    }

    Sprite_Delete(&theShell);
    Sprite_Delete(&ship);
    Sound_Stop();
    Sound_Unload((sound_ptr)&boom);
    return 0;
}

void selectDifficulty(void)
{
    int counter = 0, done = FALSE, redraw = 0, index = 0, pal_reg = 0;
    RGB_color color;

    Screen_Transition(SCREEN_DARKNESS);
    PCX_Init((pcx_picture_ptr)&background);    
    PCX_Load("hardLev.pcx", (pcx_picture_ptr)&background, 0);
    PCX_Show_Buffer((pcx_picture_ptr)&background, 1);
    PCX_Delete((pcx_picture_ptr)&background);    

    shell.x_old = shell.x = 41;
    shell.y_old = shell.y = 18;
    Sprite_Under((sprite_ptr)&shell, video_buffer);
    Sprite_Draw((sprite_ptr)&shell, video_buffer, 1);

        while(done != 1)
        {
            if (Music_Status()==2 || Music_Status()==0)
            {
                Music_Stop();
                Music_Play((music_ptr)&song,0);
            }

            if(keys_active > 0)
            {
                // what is user doing
                if (keyboard_state[MAKE_UP])
                {
                    shell.y-=36;

                    // test if we need to wrap around bottom

                    if (--counter < 0)
                    {
                        counter = 4;
                        shell.y = 162;
                    } // end if wrap around
                    //keyboard_state[MAKE_UP] = 0;
                    Sound_Stop();
                    Sound_Play((sound_ptr)&digital_FX[0]);
                    redraw = 1;
                } // end if up

                if (keyboard_state[MAKE_DOWN])
                {
                    shell.y+=36;

                    // test if we need to wrap around bottom

                    if (++counter > 4)
                    {
                        counter = 0;
                        shell.y = 18;
                    } // end if wrap around
                    //keyboard_state[MAKE_DOWN] = 0;
                    Sound_Stop();
                    Sound_Play((sound_ptr)&digital_FX[0]);
                    redraw = 1;
                } // end if down

                if(keyboard_state[MAKE_HOME])
                {
                    shell.y = 18;
                    counter = 0;
                    Sound_Stop();
                    Sound_Play((sound_ptr)&digital_FX[0]);
                    redraw = 1;
                }

                if(keyboard_state[MAKE_END])
                {
                    shell.y = 162;
                    counter = 4;
                    Sound_Stop();
                    Sound_Play((sound_ptr)&digital_FX[0]);
                    redraw = 1;
                }

                if(keyboard_state[MAKE_ENTER])
                {
                    switch(counter)
                    {
                        case 0:
                            Screen_Transition(SCREEN_WHITENESS);
                            Screen_Transition(SCREEN_DARKNESS);
                            difficulty = EASY_AS_SNOT;
                            done = TRUE;
                            break;
                        case 1:
                            for (index=0; index<20; index++)
                            {
                                // loop thru all palette registers

                                for (pal_reg=0; pal_reg<256; pal_reg++)
                                {
                                    Read_Color_Reg(pal_reg,(RGB_color_ptr)&color);
                                    // get the color to fade
                                    color.blue+=4;

                                    if (color.blue > 63)
                                        color.blue = 63;

                                    // set the color to a brightend intensity

                                    Write_Color_Reg(pal_reg,(RGB_color_ptr)&color);
                                } // end for pal_reg

                                // wait a bit

                                Time_Delay(1);

                            } // end for index
                            difficulty = A_GOOD_BELCH;
                            Screen_Transition(SCREEN_DARKNESS);
                            done = TRUE;
                            break;
                        case 2:
                            for (index=0; index<20; index++)
                            {
                                // loop thru all palette registers

                                for (pal_reg=0; pal_reg<256; pal_reg++)
                                {
                                    Read_Color_Reg(pal_reg,(RGB_color_ptr)&color);
                                    // get the color to fade
                                    color.green+=4;

                                    if (color.green > 63)
                                        color.green = 63;

                                    // set the color to a brightend intensity

                                    Write_Color_Reg(pal_reg,(RGB_color_ptr)&color);
                                } // end for pal_reg

                                // wait a bit

                                Time_Delay(1);

                            } // end for index
                            difficulty = PUKE_GRAVY;
                            Screen_Transition(SCREEN_DARKNESS);
                            done = TRUE;
                            break;
                        case 3:
                            for (index=0; index<20; index++)
                            {
                                // loop thru all palette registers

                                for (pal_reg=0; pal_reg<256; pal_reg++)
                                {
                                    Read_Color_Reg(pal_reg,(RGB_color_ptr)&color);
                                    // get the color to fade
                                    color.green+=4;
                                    color.red+=4;

                                    if (color.green > 63)
                                        color.green = 63;

                                    if (color.red > 63)
                                        color.red = 63;

                                    // set the color to a brightend intensity

                                    Write_Color_Reg(pal_reg,(RGB_color_ptr)&color);
                                } // end for pal_reg

                                // wait a bit

                                Time_Delay(1);

                            } // end for index
                            difficulty = TOUGH_AS_SHIT;
                            Screen_Transition(SCREEN_DARKNESS);
                            done = TRUE;
                            break;
                        case 4:
                            for (index=0; index<20; index++)
                            {
                                // loop thru all palette registers

                                for (pal_reg=0; pal_reg<256; pal_reg++)
                                {
                                    Read_Color_Reg(pal_reg,(RGB_color_ptr)&color);
                                    // get the color to fade
                                    color.red+=4;

                                    if (color.red > 63)
                                        color.red = 63;

                                    // set the color to a brightend intensity

                                    Write_Color_Reg(pal_reg,(RGB_color_ptr)&color);
                                } // end for pal_reg

                                // wait a bit

                                Time_Delay(1);

                            } // end for index
                            difficulty = A_FARTS_CHANCE;
                            Screen_Transition(SCREEN_DARKNESS);
                            done = TRUE;
                            break;
                    }
                }
            }

            if (redraw)
            {
                // erase sprite at old position
                Sprite_Erase((sprite_ptr)&shell, video_buffer);
                // scan the background at new postition
                Sprite_Under((sprite_ptr)&shell, video_buffer);
                // draw sprite at new position
                Sprite_Draw((sprite_ptr)&shell, video_buffer, 1);
                // update old position
                shell.y_old = shell.y;
                Time_Delay(3);
                redraw = 0;
            } // end if sprites needed to be redrawn
        } //end while(done != 1)
}

void makeHarder (int * xptr, int * yptr)
{

    int bogusShip, bogusGuess, done = FALSE;
    int randEdge;
    
    switch(difficulty)
        {
        case 1:
            *xptr = rand() % 12;
            *yptr = rand() % 12;
            break;

        case 2:
            while(done == FALSE)
            {
                *xptr = rand() % 12;
                *yptr = rand() % 12;

                if((*xptr == 0 || *xptr == 12) || (*yptr == 0 || *yptr == 12))
                {
                    if((randEdge = rand() % 4) == 1)
                    {
                        done = TRUE;
                        continue;
                    }
                }
                done = TRUE;
            }
            break;

        case 3:
            bogusGuess = rand() % 14;
            if (bogusGuess == 0)
                {
                do
                 {
                    bogusShip = rand() % 4;
                    }
                while (gGrid[userShip[bogusShip].x]
                        [userShip[bogusShip].y].beenShotAt == TRUE);
                *xptr = userShip[bogusShip].coveredSquare1.x;
                *yptr = userShip[bogusShip].coveredSquare1.y;
                }                    
            else
                { 
                *xptr = rand() % 12;
                *yptr = rand() % 12;
                }
            break;

        case 4:
            bogusGuess = rand() % 8;
            if (bogusGuess == 0)
                {
                do
                    {
                    bogusShip = rand() % 4;
                    }
                while (gGrid[userShip[bogusShip].x]
                        [userShip[bogusShip].y].beenShotAt == TRUE);
                *xptr = userShip[bogusShip].coveredSquare1.x;
                *yptr = userShip[bogusShip].coveredSquare1.y;
                }                    
            else
                { 
                *xptr = rand() % 12;
                *yptr = rand() % 12;
                }
            break;

        case 5:
            do
                {
                bogusShip = rand() % 4;
                }
            while (gGrid[userShip[bogusShip].x]
                        [userShip[bogusShip].y].beenShotAt == TRUE);
            *xptr = userShip[bogusShip].coveredSquare1.x;
            *yptr = userShip[bogusShip].coveredSquare1.y;
        }
}
