USES AnsiCrt;
{ I wrote this program to put the AnsiCrt Unit through its paces in relation
  to the TextColor, TextBackground, HighVideo, LowVideo procedures.
  It can be used to compare the speed of Ansi-based 'CRT replacement Units'
  but comparison between speed of different ANSI.SYS replacements might also
  be interesting, though not definitive.
  Strings of length 10 are written to the screen for each foreground colour,
  then the background colour is incremented and the cycle  of foreground
  colours starts again.
  For each foreground colour:
   1. The Text is switched into HighVideo or LowVideo after it has been
      displayed 'normally'. e.g. Red would become LightRed, but if the colour
      was initially LightRed it would be switched to Red.
      A string of length 10 is then displayed in that foreground colour.
   2. Blinking is then added to the foreground colour and the 2 length 10
      strings written as above (i.e. being switched into low or high depending).

  Hence for each fore/background colour combination the foreground goes
  through 2 intensity states by 2 blink states
  i.e 4 x 10 characters = half line.
  There are 16 foregound colours to test so this takes 8 lines for each
  background colour.
  There are 8 background colours, therefore one cycle of the test takes
  64 lines. The test is cycled through 25 times to give better timing accuracy.
  Therefore 1600 lines are written which is 64 screens.

Results:
1) Using the ANSI.SYS supplied with DOS5 the test took 128.63 secs which is
about 2 secs per screen. Not bad for _intensive_ Ansi.
2) AnsCrt written in 1988 by Rick Housh took 200.56 secs. In any case, it
has a fault with HighVideo i.e. HighVideo after blinking text switches off
the blink and then doesn't actually produce the bold text required.
  }

VAR fgcol, bgcol, forecol: BYTE;
    times, testcycles: INTEGER;
    StartTime,StopTime: LONGINT;
    TimerTicks: LONGINT ABSOLUTE $40:$6C;
    Duration: REAL;

BEGIN
  Writeln('Start');
  StartTime := TimerTicks;
  FOR testcycles := 1 to 25 do
  begin
    FOR bgcol := Black TO LightGray DO
    BEGIN
      TextBackground(bgcol);
      FOR fgcol := Black TO LightGray DO
      BEGIN
        forecol := fgcol; { the extra var forecol is to protect the fg count}
        FOR times := 1 TO 2 DO
        BEGIN
          TextColor(forecol);
          Write('NormColour');
          HighVideo;
          Write(' HighVideo');
          IF times = 1 THEN forecol := forecol+ Blink
        END
      END;
      FOR fgcol := DarkGray TO White DO
      BEGIN
        forecol := fgcol;
        FOR times := 1 TO 2 DO
        BEGIN
          TextColor(forecol);
          Write('NormColour');
          LowVideo;
          Write(' LowVideo ');
          IF times = 1 THEN forecol := forecol + Blink
        END
      END
    END
  END;
  StopTime := TimerTicks;
  NormVideo;
  Writeln;
  Duration := (StopTime-StartTime);
  Duration := Duration/18.2;
  Writeln(#7,'The test took ',duration,' seconds.')
END.


