unit list;
interface
uses crt,dos;
{$s-}
const
  maxline = 250;
  t_none = 0;
  t_mod = 1;
  t_zip = 2;
  t_dir = 3;
  t_drive = 4;

type
t_memarray = array[0..8000] of byte;
t_line = record
           s : array[0..2] of string[20];
           t : integer;
           tagged : boolean;
         end;  
t_linea = array[0..maxline] of t_line;
p_linea = ^t_linea;
t_list = object
           x1,y1,x2,y2 : integer;
           c1x,c2x,c3x : integer;
           size,len : integer;
           curline,startline : integer;
           lines : p_linea;
           tilt : t_line;
           numtagged : integer;
           procedure insline(s,s2,s3 : string;t : integer);
           procedure delline;
           procedure delete;
           procedure init(maxline,minx,miny,maxx,maxy : integer;pic : pointer);
           procedure done;
           procedure draw;
           procedure drawline(cline : integer);
           procedure upline;
           procedure downline;
           procedure uppage;
           procedure downpage;
           procedure goend;
           procedure gohome;
           procedure gotokey(key : char);
           procedure tagline;
           procedure strswap(s1,s2 : integer);
           function compare(a : integer):integer;
           procedure sort(top,bottom : integer);
           procedure qsort;
         end;


implementation
var
piccy : ^t_memarray;

procedure hiline(x,y,xl,c : integer); assembler;
asm
  dec  y
  push ds
  mov  ds,word ptr piccy+2
  mov  ax,160
  mul  y
  add  ax,x
  add  ax,x
  mov  di,ax
  mov  si,ax
  mov  ax,0b800h
  mov  es,ax
  mov  cx,xl
  mov  bx,c
@@1:
  mov  al,[si+1]
  and  al,15
  or   al,16
  mov  es:[di+1],al
  add  di,2
  add  si,2
  loop @@1
  pop  ds
end;

procedure orgline(x,y,xl : integer);
var
o : word;
begin
  o := (y-1)*160+x*2;
  move(piccy^[o],mem[$b800:o],xl*2);
end;

procedure fastwrite(x,y : word;s : string);
begin
{l := byte(s[0]);
if l = 0 then exit;
for n := 1 to l do mem[$b800:(y-1)*160+(x-1)*2+n*2-2] := byte(s[n]);}
asm
    push ds
    mov  ax,ss
    mov  ds,ax
    mov  ax,0b800h
    mov  es,ax
    lea  si,s
    lodsb
    cmp  al,0
    jne  @@2
    jmp  @@end
@@2:
    mov  cl,al
    xor  ch,ch
    mov  di,y
    dec  di
    dec  x
    mov  ax,160
    mul  di
    mov  di,ax
    add  di,x
    add  di,x
@@1:
    movsb
    inc  di
    loop @@1
@@end:
    pop  ds
end;
end;

procedure t_list.init(maxline,minx,miny,maxx,maxy : integer;pic : pointer);
begin
  piccy := pic;
  size := maxline;
  len := 0;
  curline := 0;
  startline := 1;
  x1 := minx;
  y1 := miny;
  y2 := maxy;
  x2 := maxx;
  c1x := 1;
  c2x := 20;
  c3x := 40;
  numtagged := 0;
  getmem(lines,sizeof(t_line)*size);
end;

procedure t_list.done;
begin
  freemem(lines,sizeof(t_line)*size);
end;

procedure t_list.delete;
begin
  startline := 1;
  curline := 1;
  len := 0;
end;

procedure t_list.delline;
begin
  if len > 0 then dec(len);
  if curline > len then curline := len;
  if startline > curline then startline := curline;
end;

procedure t_list.insline(s,s2,s3 : string;t : integer);
begin
  if len >= size then exit;
  inc(len);
  lines^[len].s[0] := s;
  lines^[len].s[1] := s2;
  lines^[len].s[2] := s3;
  lines^[len].t := t;
  lines^[len].tagged := false;
  if curline = 0  then curline := 1;
end;

procedure t_list.upline;
begin
  if curline > 1 then dec(curline);
  if curline < startline then begin
    dec(startline);
    draw;
  end
  else begin
    drawline(curline+1);
    drawline(curline);
  end;
end;

procedure t_list.downline;
begin
  if curline < len then inc(curline);
  if curline > startline+y2-y1 then begin
    inc(startline);
    draw;
  end
  else begin
    drawline(curline-1);
    drawline(curline);
  end;
end;

procedure t_list.uppage;
begin
  if curline > startline then begin
    curline := startline;
  end
  else begin
    if curline > (y2-y1) then begin
      dec(curline,y2-y1);
      startline := curline;
    end
    else begin
      curline := 1;
      startline := 1;
    end;
  end;
  draw;
end;

procedure t_list.downpage;
begin
  if curline < startline+y2-y1 then begin
    curline := startline+y2-y1;
    if curline > len then curline := len;
  end
  else begin
    inc(curline,y2-y1);
    if curline > len then curline := len;
    startline := curline-y2+y1;
  end;
  draw;
end;

procedure t_list.goend;
begin
  curline := len;
  if curline > y2-y1 then startline := curline-y2+y1
  else startline := 1;
  draw;
end;

procedure t_list.gohome;
begin
  curline := 1;
  startline := 1;
  draw;
end;

procedure t_list.gotokey(key : char);
var
n,i : integer;
sline,dline : integer;
begin
  dline := 1;
  sline := curline;
  while (dline < len) and (lines^[dline].s[0][1] < key) do inc(dline);
  if dline > curline then
    for i := dline-1 downto sline do downline
  else if dline < curline then
    for i := dline+1 to sline do upline;
  draw;
end;

procedure t_list.tagline;
begin
  if lines^[curline].tagged then begin
    lines^[curline].tagged := false;
    dec(numtagged);
  end
  else begin
    lines^[curline].tagged := true;
    inc(numtagged);
  end;
  drawline(curline);
end;

procedure t_list.draw;
var
n,cline : integer;
wmin,wmax : integer;
begin
  for n := 1 to y2-y1+1 do begin
    cline := startline+n-1;
    if cline <= len then begin
      if cline=curline then begin
        orgline(x1-1,n+y1-1,50);
        hiline(x1-1,n+y1-1,12,16);
      end
      else orgline(x1-1,n+y1-1,50);
      fastwrite(x1,n+y1-1,lines^[cline].s[0]);
      fastwrite(c2x+x1-1,n+y1-1,lines^[cline].s[1]);
      fastwrite(c3x+x1-1,n+y1-1,lines^[cline].s[2]);
    end;
  end;
end;

procedure t_list.drawline(cline : integer);
var
n : integer;
wmin,wmax : integer;
begin
  n := cline-startline+1;
  if (n > 0) and (n <= y2-y1+1) then if cline <= len then begin
    if cline=curline then hiline(x1-1,n+y1-1,12,16)
    else orgline(x1-1,n+y1-1,50);
    fastwrite(x1,n+y1-1,lines^[cline].s[0]);
    fastwrite(c2x+x1-1,n+y1-1,lines^[cline].s[1]);
    fastwrite(c3x+x1-1,n+y1-1,lines^[cline].s[2]);
  end;
end;


procedure t_list.strswap(s1,s2 :integer);
var
t : t_line;
begin
  t := lines^[s1];
  lines^[s1] := lines^[s2];
  lines^[s2] := t;
end;

function t_list.compare(a : integer):integer;
var
s : string;
t1,t2 : integer;
begin
  t1 := lines^[a].t;
  t2 := tilt.t;
  {if t1 = t_zip then t1 := t_mod;
  if t2 = t_zip then t2 := t_mod;}
  if t1 < t2 then compare := -1
  else if t1 > t2 then compare := 1
  else if lines^[a].s[0] < tilt.s[0] then compare := -1
  else if lines^[a].s[0] > tilt.s[0] then compare := 1
  else compare := 0;
end;

procedure t_list.sort(top,bottom : integer);
var
i,j : integer;
x : string[20];
begin
  i := top;
  j := bottom;
  x := lines^[(top+bottom) div 2].s[0];
  tilt.s[0] := x;
  tilt.t := lines^[(top+bottom) div 2].t;
  repeat
    while {lines^[i].s[0] < x]} compare(i)=-1 do inc(i);
    while {(x < lines^[j].s[0])} compare(j)=1 do dec(j);
    if i < j then begin
      strswap(i,j);
    end;
    if i <= j then begin
      inc(i);
      dec(j);
    end;
  until i > j;
  if top < j then sort(top,j);
  if i < bottom then sort(i,bottom);
end;

procedure t_list.qsort;
begin
  sort(1,len);
end;

end.

