;       FULL VERSION  V1.6 DECRYPTING INCLUDED. (ADULT CHANNEL ONLY)

;       WARNING:: THIS PROGRAM MUST NOT BE USED OR COPIED IN 
;                 ANY WAY, OTHER THAN FOR SELF EDUCATIONAL PURPOSES
;                 IN PROGRAMMING. USE OF THIS PROGRAM FOR FREE SKY
;                 VIEWING IS ILLEGAL!.


    ;   setup all data memory address pointers
	
    ;   locations used for MAIN and COMMS routeen.

        MEMRST  EQU     0900H   ;answer on reset message from card address 
        MEM7C   EQU     0910H   ;info from card to decoder                             
        MEM72   EQU     0920H   ;prevous card info from decoder to card
        MEM70   EQU     0930H   ;issue no. of card to decoder
        MEM78   EQU     0940H   ;hash gen value out to decoder 8 bytes
        MEM74   EQU     0950H   ;hash gen value in to the card 32 bytes
        MEM7A   EQU     0970H   ;on screen text to decoder
    MEMCOMMAND  EQU     0990H   ;command class from decoder (5 bytes)
	
    ;   locations used by the DECODE ALGORYTM routeen.

;memory locations for various data sections.
answ            equ     mem78                  ;set answ base address        
msg             equ     mem74                  ;set msg base address
display         equ     0a40h                  ;set display memory
comments        equ     0a70h                  ;set comments memory
errortext       equ     0e50h                  ;set errortext memory
parms           equ     080h                   ;parameter PSP memory
keytab          EQU     09a0H                  ;start of keys   
comport         equ     answ+8                 ;comport number


;kernel register locations.

        REGS       equ 0fe0h   ;start of registers
        var        equ regs    ;
        oi         equ regs+1  ;
        in         equ regs+2  ;
        status     equ regs+3  ;
        key        equ regs+4  ;
        b          equ regs+5  ;


        ;waste time between bytes

        STOP_TIME  EQU  0400h


	   code    segment 
	   org 100h 
	   assume cs:code,ds:code 
				 
;        ************   PROGRAM STARTS HERE    ****************

;This section tests for valid parameter setup.

init:   mov bx,0                ;pointer = 0
        mov al,parms[bx]        ;get first byte in PSP
        cmp al,0                ;test for 00h
        jnz p_ok                ;if <> 0 jmp p_ok and continue
        
        mov di,0                ;set pointer to 0
        mov ah,09               ;request display
        lea dx,errortext[di]    ;set pointer to 'errortext' memory
        int 21h                 ;call DOS to diplay errortext
        mov ax,0                ;request exit
        int 21h                 ;exit to dos after displaying ERROR message
p_ok:

;This section initialises the com port.

        mov bx,0                ;pointer = 0
        mov dl,parms[bx+2]      ;get com number from parm memory
        sub dl,31h              ;convert number into com value (0-3)
        mov comport[bx],dl      ;save updated value of com port
        mov dh,0                ;setup dx for the com port value
        mov ah,00               ;request for init port
        mov al,11101111b        ;set parameters 9600,o,8,2 
	int 14h                 ;call bios com routeen 

;This section initialises the text mode (on or off).

        mov bx,0                ;pointer = 0
        mov al,parms[bx+3]      ;get the text command from parm memory
        cmp al,"T"              ;test for "T" (text on)
        jz text_on              ;if set jmp text_on
        cmp al,"t"              ;test for "t" (text on)
        jz text_on              ;if set jmp text_on
        mov al,0c0h             ;set text mode to off
        mov mem7a[bx],al        ;update text memory
        jmp end_t_parm          ;
text_on:
        mov al,0d8h             ;set text mode to on 24 chars
        mov mem7a[bx],al        ;update text memory
end_t_parm:

        call diswords           ;call the PC display routeen to show comments.

init1:
	call reset              ;call the reset testing routeen.

main:                           ;this is the main function operating on
				;the commands as they come in.

	call getinst            ;get an instruction from decoder        
        call test_key
        call textupdate         ;call status checking & display it.
	mov bx,01               ;set pointer to instruction byte in memory
	mov al,memcommand[bx]   ;load the instruction byte into al        
	cmp al,00               ;test for missing instruction
	jz init1                ;if missing start from init1
	
	cmp al,70h              ;test for 70
	jz j70                  ;
	cmp al,72h              ;test for 72
	jz j72                  ;
	cmp al,74h              ;test for 74
	jz j74                  ;
	cmp al,76h              ;test for 76
	jz j76                  ;
	cmp al,78h              ;test for 78
	jz j78                  ;
	cmp al,7ah              ;test for 7a
	jz j7a                  ;
	cmp al,7ch              ;test for 7c
	jz j7c                  ;
	cmp al,7eh              ;test for 7e
	jz j7e                  ;
	cmp al,80h              ;test for 80
	jz j80                  ;
	cmp al,82h              ;test for 82
	jz j82                  ;
	 
	jmp init1               ;this jmp should never be reached!
				;but its here all the same.
				
;vector list for procedures:-

j70:    call p70
	jmp main
j72:    call p72
	jmp main
j74:    call p74
	jmp main
j76:    call p76
	jmp main
j78:    call p78
	jmp main
j7a:    call p7a
	jmp main
j7c:    call p7c
	jmp main
j7e:    call p7e        
	jmp main
j80:    call p80
	jmp main
j82:    call p82
	jmp main


;******* various routeens follow:-  *********

send:                           ;send one byte using the AH reg.
        push bx                 ;save value of bx
	not ah                  ;invert the data byte 
	mov dl,8                ;set reverse bits loop to 8 bits   
ls:     rcl ah,1                ;rotate ah data byte left into carry 
	rcr dh,1                ;rotate carry into dh result reversed. 
	dec dl                  ;dl=dl-1 
	jnz ls                  ;if not completed continue rotating. 
				;byte reversed & inverted, now send it. 
	mov al,dh               ;copy result byte in sending reg. al 
        mov bx,0                ;pointer = 0
        mov dx,comport[bx]      ;direct to com port
        mov ah,01h              ;request for tx to com port
	int 14h                 ;call bios tx routeen  
not_tx:                         ;this next section waits until tx is done.
        mov bx,0                ;pointer = 0
        mov dx,comport[bx]      ;load the com number into dx
        mov ah,03               ;request status of port
        int 14h                 ;call the bios status routeen
        and ah,01000000b        ;test for tx shift register is empty.
        jz not_tx               ;if bit 0 set of status, wait.
        mov cx,stop_time        ;waste some time to extend stop bits!
pad:    loop pad                ;loop
        pop bx                  ;restore value of bx
        ret                     ;byte now sent, return


getb:                           ;get one byte, result is in AH reg.
        push bx                 ;save value of bx
        mov bx,0                ;pointer = 0
        mov dx,comport[bx]      ;set com port no.
        mov ah,02               ;request rx byte from bios routeen
	int 14h                 ;call the bios comms routeen, data in al        
	not al                  ;invert the data byte 
	mov dl,8                ;set reverse bits loop to 8 bits   
lg:     rcl al,1                ;rotate al data byte left into carry 
	rcr dh,1                ;rotate carry into dh result reversed. 
	dec dl                  ;dl=dl-1 
	jnz lg                  ;if not completed continue rotating. 
				;byte reversed & inverted now ready 
	mov ah,dh               ;copy result byte in rx reg ah 
        pop bx                  ;restore bx
        ret                     ;return

textupdate:                     ;display memory is updated depending
				;on the STATUS bits 1 & 2.
	mov bx,0
	mov al,msg[bx]          ;get the msg[0] (scrambled or soft) byte
	and al,11110000b        ;mask out low nibble
	cmp al,11000000b        ;test for unscrambled or soft encyption
	jnz test_st
				;soft encryption detected
	mov ah,"X"
	mov mem7a[bx+7],ah      ;text = 'X' for both test
	mov mem7a[bx+19],ah
	jmp textret             ;bypass status testing

test_st:
	mov al,status[bx]       ;get the status byte into al
	mov dl,al               ;test bit 1 of status
	and dl,1
	jz sig0
	mov ah,"1"
	mov mem7a[bx+7],ah      ;store '1' in sig text memory
	jmp bit2
sig0:   mov ah,"0"
	mov mem7a[bx+7],ah      ;store '0' in sig text memory
	
bit2:   mov dl,al               ;test bit 2 of status
	and dl,2
	jz crc0
	mov ah,"1"
	mov mem7a[bx+19],ah     ;store '1' in crc text memory
	jmp textret
crc0:   mov ah,"0"
	mov mem7a[bx+19],ah     ;store '0' in crc text memory
textret:
	ret

getinst:                        ;this routeen gets a command from
				;the decoder. The resulting bytes of
				;the header are placed in memcommand. 
				;if there is no command, then result = 00.
	
	call getb               ;clear the echo rx byte
	call getb               ;get a byte 
	cmp ah,53h              ;test if its a command 53h
	jnz ins00               ;if not ins=00
				;got it! now update the command memory
	mov bx,0                ;set index mem pointer to 0
	mov memcommand[bx],ah   ;put the 53h into command memory (optional)
	inc bx                  ;index pointer +1
get:    call getb               ;get the next data
	mov memcommand[bx],ah   ;put into command memory
	inc bx                  ;index pointer +1
	cmp bx,05h              ;have 5 chars been stored?
	jnz get                 ;if not get another one
	jmp ok                  ;all received so return
ins00:  mov ah,00               ;set the result ins to 00
	mov bx,01               ;pointer to ins byte in memcommand
	mov memcommand[bx],ah   ;store the byte
ok:     ret                     ;return                         


;*******   procedure routeens follow:-  *********


				;SEND ID NUMBER AND CARD INFO TO DECODER.
p70:    mov ah,70h              ;send procedure byte 70h
	call send               ;call the send routeen
	mov bx,0                ;reset the memory pointer
p70l:   mov ah,mem70[bx]        ;get a byte from memory to send
	call send               ;call the send byte routeen
	inc bx                  ;bx=bx+1
	cmp bx,06               ;test for 6 bytes sent yet
	jnz p70l                ;if not finished then get another one
	call endproc            ;call the end of procedure routeen
	ret

				;PREVIOUS CARD INFO VIA DECODER.
p72:    mov ah,72h              ;send procedure byte 72h
	call send               ;call the send routeen
	mov bx,0                ;reset the memory pointer
	call getb               ;clear echo from rx buffer
p72l:   call getb               ;call the getbyte routeen
	mov mem72[bx],ah        ;put ah data into memory
	inc bx                  ;bx=bx+1
	cmp bx,10h              ;test for 16 bytes sent yet
	jnz p72l                ;if not finished then get another one
	call endproc            ;call the end of procedure routeen
	ret

				;32 BYTES OF STATION MESSAGE FROM DECODER.
p74:    mov ah,74h              ;send procedure byte 74h
	call send               ;call the send routeen
	mov bx,0                ;reset the memory pointer
	call getb               ;clear echo from rx buffer
p74l:   call getb               ;call the getbyte routeen
	mov mem74[bx],ah        ;put ah data into memory
	inc bx                  ;bx=bx+1
	cmp bx,20h              ;test for 32 bytes sent yet
	jnz p74l                ;if not finished then get another one
	call endproc            ;call the end of procedure routeen
	ret
 
				;AUTHORISE BUTTON PRESSED FROM DECODER.
p76:    mov ah,76h              ;send procedure byte 76h 
	call send               ;call the send routeen
	call endproc            ;call the end of procedure routeen
	mov ax,0                ;now EXIT to dos.
	int 21h                 

				;SEND 8 BYTE ANSWER TO DECODER.
p78:    call decrypt            ;CALL THE DECRYPTING ROUTEEN NOW.
	mov ah,78h              ;send procedure byte 78h
	call send               ;call the send routeen
	mov bx,0                ;reset the memory pointer
p78l:   mov ah,mem78[bx]        ;get a byte from memory to send
	call send               ;call the send byte routeen
	inc bx                  ;bx=bx+1
	cmp bx,08               ;test for 8 bytes sent yet
	jnz p78l                ;if not finished then get another one
	call endproc            ;call the end of procedure routeen
	ret

				;SEND ON SCREEN TEXT MESSAGE TO DECODER.
p7a:    mov ah,7ah              ;send procedure byte 7ah
	call send               ;call the send routeen
	mov bx,0                ;reset the memory pointer
p7al:   mov ah,mem7a[bx]        ;get a byte from memory to send
	call send               ;call the send byte routeen
	inc bx                  ;bx=bx+1
	cmp bx,25               ;test for 25 bytes sent yet
	jnz p7al                ;if not finished then get another one
	call endproc            ;call the end of procedure routeen
	ret

				;SEND CARD INFO TO DECODER.
p7c:    mov ah,7ch              ;send procedure byte 7ch
	call send               ;call the send routeen
	mov bx,0                ;reset the memory pointer
p7cl:   mov ah,mem7c[bx]        ;get a byte from memory to send
	call send               ;call the send byte routeen
	inc bx                  ;bx=bx+1
	cmp bx,10h              ;test for 16 bytes sent yet
	jnz p7cl                ;if not finished then get another one
	call endproc            ;call the end of procedure routeen
	ret

				;SEND 64 BYTES TO DECODER (00).
p7e:    mov ah,7eh              ;send procedure byte 7eh
	call send               ;call the send routeen
	mov bx,0                ;reset the memory pointer
p7el:   mov ah,00               ;just send 00h for all bytes
	call send               ;call the send byte routeen
	inc bx                  ;bx=bx+1
	cmp bx,40h              ;test for 64 bytes sent yet
	jnz p7el                ;if not finished then get another one
	call endproc            ;call the end of procedure routeen
	ret

				;GET ONE BYTE FROM DECODER (NULL BYTE).
p80:    mov ah,80h              ;send procedure byte 80h
	call send               ;call the send routeen
	call getb               ;get echo from decoder
	call getb               ;call getbyte routeen for the 1 byte data
	call endproc            ;call the end of procedure routeen
	ret

				;SEND 64 BYTES TO DECODER (00).
p82:    mov ah,82h              ;send procedure byte 82h
	call send               ;call the send routeen
	mov bx,0                ;reset the memory pointer
p82l:   mov ah,00               ;just send 00h for all bytes
	call send               ;call the send byte routeen
	inc bx                  ;bx=bx+1
	cmp bx,40h              ;test for 64 bytes sent yet
	jnz p82l                ;if not finished then get another one
	call endproc            ;call the end of procedure routeen
	ret

endproc:                        ;SEND END PROCEDURE BYTE, THEN 00.
	mov ah,90h              ;send 90 (end of procedure byte)
	call send               ;call the send routeen
	mov ah,00               ;send the last byte 00
	call send               ;call the send routeen
	ret

;this routeen first waits for a DCD (reset) = 1 condition.
;then it sends the answer to reset (ATR) message.
;if at any time while sending, DCD goes to 0 (low), then it starts again.

reset:  mov di,0                ;i = 0, ATR string pointer to 0
        mov bx,0                ;pointer = 0
re1:    call test_key           ;call the keyboard for a key
        mov dl,comport[bx]      ;setup dx for the com port value
        mov dh,0                ;
        mov ah,03               ;request status byte
	int 14h                 ;call bios for status
	and al,10000000b        ;test the DCD bit 
	jnz reset               ;if DCD = 0 then reset pointer & start again 
        mov ah,memrst[di]       ;get a data byte from ATR string [i]
	call send               ;call the send routeen data in AH. 
        inc di                  ;i = i + 1 
        cmp di,010h             ;test if 16 bytes sent 
	jz resret               ;if done, continue to the main program. 
        jmp re1
resret: ret                     ;reset successful, return to main program.

test_key:                       ;this routeen does a single key test.
        mov ah,0bh              ;request for keyboard status
        int 21h                 ;call dos
        cmp al,0ffh             ;test for a key
        jz end_all              ;if pressed jmp end all
        ret                     ;no key, return
end_all:mov ax,0                ;request exit
        int 21h                 ;call dos and exit


; *************   DECRYPTING ALGORYTHM ROUTEEN HERE    *******************

DECRYPT:                        ;the result of the decoded message bytes 
				;are placed into the answ bytes in memory.
				;if any error occurs while decoding
				;ie. checksum or digital signature error,
				;then STATUS bits 1 or 2 are set.
				
                                ;this section clears all variable bytes
	mov bx,00               ;set pointer 00
varclr: mov al,00               ;clear byte
	mov var[bx],al          ;clear bytes in variable list
	inc bx                  ;pointer = pointer +1
        cmp bx,8                ;test for 8 variable bytes cleared
	jnz varclr              ;if not complete then do another

				;this section clears all 8 answer bytes
	mov bx,00               ;set pointer 00
ansclr: mov al,00               ;clear byte
	mov answ[bx],al         ;clear bytes in answer bytes
	inc bx                  ;pointer = pointer +1
	cmp bx,8                ;test for 8 variable bytes cleared
	jnz ansclr              ;if not complete then do another


;  *************   initial hashing  ************                                
	
        mov cx,0                ;i = 0 (cx used for i)                           
				;set up IN for kernal calls, IN = msg[i].
h1:     mov bx,cx               ;set up pointer with i
	mov al,msg[bx]          ;copy msg[i] into al
	mov bx,0                ;set pointer to 0
        mov in[bx],al           ;IN = msg[i]
	call kernal             ;call the kernal routeen
	inc cx                  ;cx = cx + 1   
        cmp cx,27               ;if 27 calls not completed, do another.
	jnz h1                  ;loop if not done

;*************   4 signature bytes hashing  ***********

                                ;i (cx) = 27
	mov bx,0                ;IN = 0
        mov al,0                ;
	mov in[bx],al           ;
	mov ch,0                ;ch pointer high = 0                        

h2:     call kernal             ;call the kernal routeen
	call kernal             ;''     ''      ''      ''
	
				;IN = msg[i]
	mov bx,cx               ;set bx with i , where cx = i
	mov al,msg[bx]          ;get message byte indexed to (i) into al
	mov bx,0                ;set pointer to 0
	mov in[bx],al           ;IN = msg[i]
				 
				;if answ[oi]<>msg[i] then set status flag
	mov dl,oi[bx]           ;dl = oi
	mov dh,0                ;clear high nibble of pointer
	mov bx,dx               ;copy oi offset into pointer
	mov ah,answ[bx]         ;copy answ[oi] into ah
	mov bx,cx               ;set pointer to i
	mov al,msg[bx]          ;copy msg[i] into al
	cmp al,ah               ;test for answ[oi] <> msg[i]
	jnz st1                 ;if <> set status flag for signature byte
	jmp h3                  ;match found so all ok, continue       
	
st1:                            ;set the status flag
	mov bx,0                ;set pointer to 0     
	mov al,1                ;set bit 1
	or  status[bx],al       ;logic or the status byte so set error1

				;oi=oi+1 then and with 7
h3:     mov bx,0                ;set pointer to 0
	mov al,1                ;increment value = 1
	add oi[bx],al           ;oi = oi + 1 
	mov al,7                ;set mask value 7
	and oi[bx],al           ;mask out higher bits, limit count 0 - 7

	inc cl                  ;i = i + 1
        cmp cl,31               ;test for i = 31
	jnz h2                  ;if not completed, go again

;****************   final 64 hashes on last byte ***************

	mov cx,0                ;i=0
h4:     mov bx,0                ;set up IN for kernal calls

;-----
;    ECM as from 24.5.95

        mov al,0dh              ;input data = 0dh
        mov in[bx],al           ;copy data byte into in
;-----
        call kernal             ;call the kernal routeen
        inc cx                  ;i = i + 1
        cmp cl,64               ;test for last call count
	jnz h4                  ;if not complete, call another one


;***********   checksum testing here on last byte msg[31]  *******

				;B=0
        mov bx,0                ;set pointer to 00
	mov al,0                ;data = 0
	mov b[bx],al            ;b=0

				;add msg[0..31] to B
	mov cx,0                ;i=0
addb:   mov bx,cx               ;set pointer to msg
	mov al,msg[bx]          ;get msg[0..31] byte into al
	mov bx,0                ;set pointer to 0
	mov ah,b[bx]            ;get B byte into ah
	add al,ah               ;add B to msg[0..31]
	mov b[bx],al            ;store answer into B
	inc cx                  ;i = i + 1
	cmp cx,32               ;check if all 32 bytes in msg added to B
	jnz addb                ;if not completed, add another

				;does B (now status) <> 0 ?
	
	mov al,b[bx]            ;get B into al
	cmp al,0                ;test for 0
	jnz st2                 ;if <> 0 then set error = st2
	jmp maskout             ;jump maskout

st2:                            ;set status flag to 2
	mov al,2                ;set data to error 2
	or status[bx],al        ;logic or status with 2

maskout:                        ;mask out answ[7] hi nibble (not used)

	mov bx,7                ;set pointer to offset byte 7
        mov al,0fh              ;set data to 0fh
	and answ[bx],al         ;mask out high nibble of answ [7]
	
	ret                     ;hashing completed, now return to main.


;****************   critical kernal routeen   ****************        

kernal:                         ;this is the critical algorythm used to
				;convert bytes into correct answer bytes.
				;do not use cx (i) in this routeen.                         
	
				;answ[oi] = answ[oi] ex-or in.
	mov bx,0                ;set pointer to 0
	mov bl,oi[bx]           ;get oi into pointer low
	mov bh,0                ;clear high byte of pointer
	mov dx,bx               ;copy offset [oi] into dx for later  
	mov al,answ[bx]         ;get answ[oi] into al
	mov bx,0                ;set pointer to 0
	xor al,in[bx]           ;ex-or answ[oi] with in
	mov bx,dx               ;set pointer back to [oi]
	mov answ[bx],al         ;result back in answ[oi]
	
				;upper nibble of answ[oi] as first pointer.
	mov bx,0                ;set pointer to 0
	mov al,oi[bx]           ;get oi into al
	mov ah,0                ;clear high byte of pointer
	mov bx,ax               ;set oi offset into bx
	mov al,answ[bx]         ;get answ[io] into al
	clc                     ;clear carry to insert a zero into bit 7
	rcr al,1                ;rotate the answ[oi] byte 4 places right
	clc                     ;
	rcr al,1                ;making the hi nibble to low nibble
	clc                     ;
	rcr al,1                ;
	clc                     ;
	rcr al,1                ;
	mov bx,0                ;set pointer to 00
	add al,key[bx]          ;add card type offset to key pointer
	mov bl,al               ;copy low nibble + offset into pointer low
	mov bh,0                ;clear pointer high
	mov dl,keytab[bx]       ;dl = key[ hi made low nibble of answ[oi] ]
	
				;lower nibble of answ[oi] + 16 as second. 
	mov bx,0                ;set pointer to 0
	mov al,oi[bx]           ;get oi into al
	mov ah,0                ;clear high byte of pointer
	mov bx,ax               ;set oi offset into bx
	mov al,answ[bx]         ;get answ[io] into al
	and al,0fh              ;mask out high nibble
	add al,16               ;add 16 giving a +16 further offset 
	mov bx,0                ;set pointer to 0
	add al,key[bx]          ;add card type offset to key value
	mov bl,al               ;low nibble + 16 + card type into pointer low
	mov bh,0                ;clear pointer high
	mov dh,keytab[bx]       ;dh = keys[ low nibble only + 16 ]

	add dl,dh               ;add both fetched keys bytes dl and dh
	not dl                  ;complement dl (c)

				;rotate C to 1 left, bit 7 enters bit 0
	rol dl,1                ;shift left 1 bit

				;C = C + in
	mov bx,0                ;set pointer to 0
	add dl,in[bx]           ;add in into C
	
				;rotate C to 3 right, bit 0 enters bit 7 
	ror dl,1                ;shift right 3 bits
	ror dl,1                ;
	ror dl,1                ;

				;oi=oi+1 then and with 7
	mov al,oi[bx]           ;copy oi into al
	inc al                  ;oi = oi + 1
	and al,7                ;and oi with 7 to limmit count
	mov oi[bx],al           ;update oi
				
				;answ[oi] = answ[oi] ex-or C.
	mov al,oi[bx]           ;get oi into al
	mov ah,0                ;clear high byte of pointer
	mov bx,ax               ;set oi offset into bx
	mov al,answ[bx]         ;get answ[oi] into al
	xor al,dl               ;ex-or answ[oi] with C
	mov answ[bx],al         ;result back in answ[oi]
	ret                     ;return to hash function.


diswords:                       ;display a string (used for text)
        mov di,0                ;set pointer to 0
        mov ah,09               ;request display
        lea dx,comments[di]     ;set pointer to 'comments' memory
        int 21h                 ;call DOS to diplay start screen
        ret                     ;return

;*************    data section     ***************************
  
	org memrst
;ATR message to decoder
db 3fh,0fah,11h,25h,05h,00h,01h,0b0h,05h,3bh,34h,4dh,59h,00,81h,80h
	
	org mem7a
;on screen diagnosic text
db 000h
db "DSIG........CKSM........"

        org comments

db 10
db" _______________________________________________________________",13,10
db 10,10,10
db"       FULL VERSION  V1.6 DECRYPTING INCLUDED (adult only).     ",13,10
db"       *** ADULT CARD EMULATOR ****                             ",13,10
db"           DATE: 31.5.95                                        ",13,10
db"                                                                ",13,10
db"       WARNING:: THIS PROGRAM MUST NOT BE USED OR COPIED IN     ",13,10
db"                 ANY WAY, OTHER THAN FOR SELF EDUCATIONAL       ",13,10
db"                 PURPOSES IN PROGRAMMING. USE OF THIS PROGRAM   ",13,10
db"                 FOR FREE SKY VIEWING IS ILLEGAL.               ",13,10
db"                 ============================================   ",13,10
db 10,10
db"     Press any key or AUTHORISE to EXIT...                      ",13,10
db 10
db" _______________________________________________________________",13,10
db"$"

        org errortext

db 10,13
db"Error - Com port number must be specified as  1,2,3 or 4.       ",13,10
db"        eg. ADULTx 1t (where '1' selects com1.)                 ",13,10
db"                      (where 't' is diagnostic Text enable.)    ",13,10
db"$"
             
        org keytab

  db 048h, 09bh, 04dh, 0a6h, 0f9h, 0d9h, 0dfh, 06eh 
  db 0ach, 084h, 0fah, 08bh, 02eh, 0b6h, 076h, 019h 
  db 0c1h, 0b0h, 0a3h, 0bbh, 00ch, 0fdh, 070h, 072h 
  db 0cah, 055h, 0efh, 0a0h, 07fh, 0bfh, 059h, 0adh 


	
	code ends 
	end INIT
