/** 3DGPL *************************************************\
 *  ()                                                    *
 *  Header for the 3D engine.                             *
 *                                                        *
 *  Defines:                                              *
 *   M_render_polygon        rendering a generic polygon; *
 *                                                        *
 *  (6/1995) By Sergei Savhenko. (savs@cs.mcgill.ca).     *
 *  Copyright (c) 1995 Sergei Savchenko.                  *
 *  THIS SOURCE CODE CAN'T BE USED FOR COMERCIAL PURPOSES *
 *  WITHOUT AUTHORISATION                                 *
\**********************************************************/

#include "../hardware/hardware.h"           /* fast memory moves */
#include "../graphics/graphics.h"           /* 2-D rendering */
#include "../trans/trans.h"                 /* 3-D transformations */
#include "../clipper/clipper.h"             /* 2-D/3-D clipping */
#include "../engine/engine.h"               /* 3-D engine */

/**********************************************************\
 *  Rendering a generic polygon in perspective.           *
\**********************************************************/

void M_render_polygon(struct M_polygon *poly,int *vertex,int *vectors)
{
 int tmp1[M_POLYGON_LENGTH_LIMIT],tmp2[M_POLYGON_LENGTH_LIMIT];
 int *tuples1=tmp1,*tuples2=tmp2,number,cnd;

 if((cnd=C_volume_clipping(poly->m_edges,tuples1,vertex,poly->m_id,
                           1+(number=poly->m_no_edges)))!=0)
 {
  if(cnd==-1) number=C_polygon_z_clipping(tuples2=tmp1,tuples1=tmp2,
                                          poly->m_id,number
                                         );
  T_perspective(tuples1,tuples2,poly->m_id,number+1);
  switch(poly->m_id)
  {
   case M_AMBIENT: G_ambient_polygon(tuples2,number,poly->m_colour);
                   break;
   case M_SHADED:  G_shaded_polygon(tuples2,number);
                   break;
   case M_TEXTURED:G_textured_polygon(tuples2,number,tuples1,
                                      &vectors[poly->m_u_index],
                                      &vectors[poly->m_v_index],
                                      poly->m_texture,
                                      poly->m_log_texture_size,
                                      poly->m_log_texture_scale
                                     );
                   break;
  }
 }
}

/**********************************************************/
