/*
 * Copyright (c) 1995, by Thinkage Ltd.
 *
 * stdlib.h - standard library definitions
 */

#ifndef _D_STDLIB
#	 define _D_STDLIB
#	 pragma idempotent

#	 protoset stdlib

#	 include	<stddef.h>
#	 include <limits.h>

#	 define EXIT_FAILURE	(-1)
#	 define EXIT_SUCCESS	(0)
#	 define RAND_MAX		INT_MAX
#	 define MB_CUR_MAX	  sizeof(wchar_t)

	typedef struct {
		int rem;
		int quot;
	} div_t;

	typedef struct {
		long rem;
		long quot;
	} ldiv_t;

#ifndef BUILTIN_FUNCTION_PTR_TYPES

	int
atexit( void (*)(void) );

/* Searching and sorting utilities */

	void *
bsearch( const void *, const void *, size_t, size_t,
		 int (*)(const void *, const void *));

	void
qsort( void *, size_t, size_t,
	   int (*)(const void *, const void *) );
#endif

#	 define mblen(s,n)	  ( mbtowc( (wchar_t *) 0, s, n ) )

#endif /* _D_STDLIB */
