// $Revision: 1.6 $
char escape_code = '\033';

extern "C" {
    void test();
    void test2();
    void test3(void);
}

#endif
int foo3(int bar3);


int foobar(int barfoo); 
#endif
int foo(int bar);

int foobar2(int barfoo2);   

#endif
int foo2(int bar2);
        
#define FOO 1
#define BAR 2
#define BAZ 3

class X {};
class B: X {};
class C;

inline Vector3D operator+(Vector3D& v1, Vector3D& v2)
{  
	Vector3D sum = v1;
	sum.add(v2);
	return sum;
}

class constClassTest {
	int a = 8;
	int f() const;
	int g() {return a};
	int h() const {return a};
};

#ifndef STRING_HPP
#define STRING_HPP

class String
{
  public:
	String(const char * = NULL, ULONG = 0);
	~String();
	
	operator char*();
	String operator+[]%(const char *);
	String &operator=(const char *);
	String &append(const char *);
	String &set(const char *, ULONG = 0);
	virtual String &size(ULONG) = 0;
	ULONG size();
	
  protected:
	void _size(ULONG);
	ULONG	m_size;
	char	*m_string;
};

inline
String::operator char*()
{
	return m_string;
}

#endif

struct ResourceRecord: public Link<ResourceRecord> {
	ResourceRecord(List<ResourceRecord> *, ULONG, ULONG);
	ULONG m_from;
	ULONG m_to;
};

ResourceRecord::
ResourceRecord(List<ResourceRecord> *list,
			   ULONG from,
			   ULONG to):
	Link<ResourceRecord>(list),
	m_from(from),
	m_to(to)
{
}

MapRid::
MapRid(ReplayControl &control):
	m_control(control),
	m_list(new List<ResourceRecord>)
{
}

MapRid::
~MapRid()
{
	delete m_list;
}

void
MapRid::
setMask(ULONG mask)
{
	m_mask = mask;
}


void
MapRid::
relate(ULONG from,
	   ULONG to)

{
	ListIterator<ResourceRecord> it(m_list);
	ResourceRecord *r;

	for (r = it.head(); r; r = it.next())
	{
		if (r -> m_from == from)
		{
			if (r -> m_to != to)
			{
				Throw(Remapped);
			}
			else
			{
				break;
			}
		}
	}

	new ResourceRecord(m_list, from, to);
}

void
MapRid::
remap(ULONG from,
	  ULONG to)

{
	ListIterator<ResourceRecord> it(m_list);
	ResourceRecord *r;

	for (r = it.head(); r; r = it.next())
	{
		if (r -> m_from == from)
		{
			r -> m_to = to;		// just do it...
			return;
		}
	}

	new ResourceRecord(m_list, from, to);
}

ULONG
MapRid::
mapRid(ULONG rid)
{
	ULONG id = rid;

	// why???
	if (MaxReservedResource < rid)
	{
		ListIterator<ResourceRecord> it(m_list);
		ResourceRecord *r;
		ULONG base = ~m_mask & rid;
		BOOL match = FALSE;

		for (r = it.head(); r; r = it.next())
		{
			if (r -> m_from == rid)
			{
				return r -> m_to;
			}
			if (base == r -> m_from)
			{
				match = TRUE;
				id = r -> m_to | m_mask & rid;
			}
		}	

		if (!match)
		{
			Log(("maprid: not found: %d (%x)\n", rid, rid));
			if (!m_control.strictResourceMapDisabled())
			{
				Throw(NotFound);
			}
		}
	}

	return id;
}
