/* $Revision: 1.11 $ */
/*
 
 compile.c  This file provided by Premia Corp to support the
			Codewright database format.
 
 */
/*
 J. Kercheval Thu, 08/31/1995 20:14:58  Initial revision obtained
			from Premia 08-29-95.  Last modification from Premia
			08-03-93.  Ported back to DOS and NT console mode.
 */

#include <stdio.h>
#include <string.h>
#include <malloc.h>

#include "flags.h"
#include "tagio.h"
#include "compile.h"
#include "log.h"

typedef struct {
	WORD    wFileNum;
	DWORD   dwStrOffset;
	BYTE    bLen, bType;
	WORD    wLineNum;
} SymInfo, *pSymInfo;

static FILE    *m_inf, *m_outf;
static char    m_strSymbol[255], m_strFileName[255], m_cTmp, m_strClassName[255];
static WORD    m_wNumOfFiles;
static DWORD   m_dwTmp, m_dwNumSyms, m_dwSymOffset; 
static BOOL    m_Initialized;
static int     m_ReadResult;
static void    *m_ptr;
static SymInfo m_CurrentSymInfo;


BOOL Init(char *ProjectName, char *OutputName);
BOOL ReadSymbol(void);
BOOL ProcessSymbol(void);


//--------------------------- support routines --------------------------------
#define TAG_ENTRY_INC   500
typedef struct _TagHStruct 
{
	LPVOID gptr;
	LPSTR ghandle;
} TagHStruct;
typedef TagHStruct *LPTagHStruct;


LPTagHStruct TAGContexts = NULL;
int TAGContextsCnt = 0;


static LPVOID 
new(size_t size)
{
	LPVOID mem = (LPVOID) malloc(size);
	LPSTR  ptr = (LPSTR)mem;
	
	if (ptr)
		memset(ptr, 0, size);
	return mem;
}

void
expandTagContexts(void)
{
	int    ocnt = TAGContextsCnt;
	int    ncnt = TAGContextsCnt + TAG_ENTRY_INC;
	LPVOID olp  = (LPVOID)TAGContexts;
	LPVOID nlp  = (LPVOID)new(ncnt  * sizeof(TagHStruct));
	
	memcpy(nlp, olp, ocnt * sizeof(TagHStruct));
	free(olp);
	
	TAGContextsCnt = ncnt;
	TAGContexts    = (LPTagHStruct)nlp;
}


static void
SetAt(LPSTR hTmp, LPVOID lpTmp)
{
	int i;
	LPSTR tstr;
	
	for (i = 0; i < TAGContextsCnt; i++)
	{
		if (TAGContexts[i].ghandle == NULL)
		{
			TAGContexts[i].gptr = lpTmp;
			tstr = new(strlen(hTmp) + 1);
			strcpy(tstr, hTmp);
			TAGContexts[i].ghandle = tstr;
			break;
		}
	}
	if (i >= TAGContextsCnt)
	{
		expandTagContexts();
		SetAt(hTmp, lpTmp);
	}
}

static BOOL
Lookup(LPSTR lph, LPVOID *lpv)
{
	int i;
	BOOL status = FALSE;
	
	*lpv = NULL;
	
	for (i = 0; i < TAGContextsCnt; i++)
	{
		if (TAGContexts[i].ghandle
			&& lph
			&& (stricmp(TAGContexts[i].ghandle, lph) == 0))
		{
			*lpv = TAGContexts[i].gptr;
			status = TRUE;
			break;
		}
	}
	return status;
}

//--------------------------- Init and cleanup --------------------------------

void 
CDB_cleanup()
{
	int i;
	if (m_Initialized) {
		if(m_inf != NULL)
			tfclose(m_inf);
		if(m_outf != NULL)
			tfclose(m_outf);
	}
	for (i = 0; i < TAGContextsCnt; i++)
	{
		if (TAGContexts[i].ghandle)
		{
			free(TAGContexts[i].ghandle);
		}
	}
	free(TAGContexts);
}

void
CDB_init(char *ProjectName, char *OutputName)
{
	TAGContexts = (LPTagHStruct)new(sizeof(TagHStruct) * TAG_ENTRY_INC);
	TAGContextsCnt = TAG_ENTRY_INC;
	
	m_inf = NULL;
	m_outf = NULL;
	m_wNumOfFiles = 0;
	m_dwNumSyms = 0;
	m_dwSymOffset = 0;
	m_Initialized = FALSE;
	Init(ProjectName, OutputName);
}

BOOL
Init(char *ProjectName, char *OutputName)
{
	if(!m_Initialized)
	{
		strcpy(&m_strFileName[0], ProjectName);
		m_inf = fopen(&m_strFileName[0], "r");
		if(m_inf != NULL)
		{
			strcpy(&m_strFileName[0], OutputName);
			m_outf = fopen(&m_strFileName[0], "wb+");
			if(m_outf != NULL){
				m_Initialized = TRUE;
				
				tfwrite(&m_strFileName[0], 20, 1, m_outf);
				return(TRUE);
			}
		}
	}
	return(FALSE);
}

//--------------------------- process database --------------------------------

BOOL
ProcessDB(void)
{
	WORD wIndex, wStrLen;
	
	if(!m_Initialized) return(FALSE);
	while(!feof(m_inf)){
		if(ReadSymbol()){
			if(!ProcessSymbol())
				return(FALSE);
		}
	}
	
	fseek(m_inf, 0, SEEK_SET);
	for(wIndex = 0;wIndex<m_wNumOfFiles;wIndex++)
	{
		do 
		{
			ReadSymbol();
			Lookup(&m_strFileName[0], &m_ptr);
		} while(LOWORD(m_ptr) != wIndex);
		
		tfwrite(&m_dwSymOffset, sizeof(DWORD), 1, m_outf);
		wStrLen = (WORD) strlen(&m_strFileName[0]);
		m_dwSymOffset+=wStrLen;
		tfwrite(&wStrLen, 1, 1, m_outf);
	}
	fseek(m_inf, 0, SEEK_SET);
	while(!feof(m_inf))
	{
		if(ReadSymbol())
		{
			if(m_cTmp == '!')
			{
				strcat(m_strClassName, "::");
				strcat(m_strClassName, m_strSymbol);
				wStrLen = (WORD) strlen(m_strClassName);
				tfwrite(m_strClassName, 1, wStrLen, m_outf);
			} 
			else 
			{
				wStrLen = (WORD) strlen(&m_strSymbol[0]);
				tfwrite(&m_strSymbol[0], 1, wStrLen, m_outf);
			}
		}
	}
	
	fseek(m_inf, 0, SEEK_SET);
	for(wIndex = 0;wIndex<m_wNumOfFiles;wIndex++)
	{
		do {
			ReadSymbol();
			Lookup(&m_strFileName[0], &m_ptr);
		} while(LOWORD(m_ptr) != wIndex);
		wStrLen = (WORD) strlen(&m_strFileName[0]);
		tfwrite(&m_strFileName[0], 1, wStrLen, m_outf);
	}
	
	fseek(m_outf, 0, SEEK_SET);
	tfwrite(&m_wNumOfFiles, sizeof(WORD), 1, m_outf);
	tfwrite(&m_dwNumSyms, sizeof(DWORD), 1, m_outf);
	
	m_dwTmp = m_dwNumSyms;
	m_dwTmp *= 10;
	m_dwTmp += (20 + (5 * m_wNumOfFiles));
	tfwrite(&m_dwTmp, sizeof(DWORD), 1, m_outf);
	
	fflush(m_outf);
	return(TRUE);
}


BOOL
ReadSymbol(void)
{
	m_ReadResult = fscanf(m_inf, "%s %[^(](%d)%c", 
						&m_strSymbol[0], &m_strFileName[0], &m_CurrentSymInfo.wLineNum, 
						&m_cTmp);
	if(m_ReadResult != EOF){
		if(m_cTmp == '!') 
			fscanf(m_inf, "%s ", m_strClassName);
		return(TRUE);
	} else
		return(FALSE);
}

BOOL 
ProcessSymbol(void)
{
	if(m_ReadResult != 4)
		return(FALSE);
	if(!Lookup(&m_strFileName[0], &m_ptr)){//got a new file
		m_ptr = (void *)MAKELONG(m_wNumOfFiles, 0);
		m_CurrentSymInfo.wFileNum = m_wNumOfFiles;
		m_wNumOfFiles+=1; 
		SetAt(&m_strFileName[0], m_ptr);
	} else 
		m_CurrentSymInfo.wFileNum = LOWORD(m_ptr);
	
	m_CurrentSymInfo.dwStrOffset = m_dwSymOffset;
	
	m_CurrentSymInfo.bLen = (BYTE) strlen(&m_strSymbol[0]);
	if (m_cTmp == '!') {
		m_CurrentSymInfo.bLen = (BYTE)(m_CurrentSymInfo.bLen + (strlen(m_strClassName) + 2));
	}	
	
#if defined(TEST) && defined(DEBUG_PRINT)
	printf("%s %d\n", m_strSymbol, m_CurrentSymInfo.bLen);
#endif
	
	m_dwSymOffset+=m_CurrentSymInfo.bLen;
	
	switch (m_cTmp) {
	case 'V': m_CurrentSymInfo.bType = 0x12; break;
	case 'D': m_CurrentSymInfo.bType = 0x05; break;
	case 'M': m_CurrentSymInfo.bType = 0x06; break;
	case 'S': m_CurrentSymInfo.bType = 0x08; break;
	case 'T': m_CurrentSymInfo.bType = 0x07; break;
	case 'E': m_CurrentSymInfo.bType = 0x09; break;
	case 'K': m_CurrentSymInfo.bType = 0x0A; break;
	case 'U': m_CurrentSymInfo.bType = 0x0B; break;
	case 'F': m_CurrentSymInfo.bType = 0x01; break;
	case 'P': m_CurrentSymInfo.bType = 0x01; break;
	case 'I': m_CurrentSymInfo.bType = 0x12; break;
	case 'C': m_CurrentSymInfo.bType = 0x0F; break;
	case '!': m_CurrentSymInfo.bType = 0x10; break;
	}
	
#if defined(TEST) && defined(DEBUG_PRINT)
	fprintf(stderr, 
			"FILE:%6d  OFFSET:%6ld  LEN:%6d  TYPE:%6d  LINE:%6d\n", 
			m_CurrentSymInfo.wFileNum, 
			m_CurrentSymInfo.dwStrOffset, 
			m_CurrentSymInfo.bLen, 
			m_CurrentSymInfo.bType, 
			m_CurrentSymInfo.wLineNum);
#endif
	tfwrite(&m_CurrentSymInfo, sizeof(SymInfo), 1, m_outf);
	fflush(m_outf);
	
	m_dwNumSyms+=1;
	
	return(TRUE);
}



BOOL
compileTagFile(LPSTR InName, LPSTR OutName)
{
	BOOL status = FALSE;
	
	if (InName && OutName)
	{
		CDB_init(InName, OutName);
		if(ProcessDB())
			status = TRUE;
		CDB_cleanup();
	}
	return status;
}

#ifdef TEST

void main(int argc, char *argv[])
{
	if(argc != 2){
		 printf("SYNTAX:\nBSBCOMP (PROJECTNAME)\n");
	} else {
		CDB_init(argv[1]);

		if(ProcessDB())
			printf("Process Complete\n");
		else
			printf("Process Failed\n");

		CDB_cleanup();
	}
}

extern int __argc;
extern char **__argv;

int PASCAL 
WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	main(__argc, __argv);
    return 0;
}

#endif
