/*  Project leowl_1
	 xor@hawk.usr.pu.ru
	 Copyright  1996. Andrey B. Yastrebov. All Rights Reserved.

	 SUBSYSTEM:    leowl_1.exe Application
	 FILE:         leowl_1e.cpp
	 AUTHOR:       Andrey B. Yastrebov


	 OVERVIEW
	 ========
	 Source file for implementation of leowl_1Edit (TEditFile).
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include "leowl_1.h"
#include "leowl_1e.h"

//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(leowl_1Edit, TLEditFile)
//{{leowl_1EditRSP_TBL_BEGIN}}
    EV_WM_SETTEXT,
    EV_COMMAND(CM_FILENEW, CmFileNew),
    EV_COMMAND(CM_FILEOPEN, CmFileOpen),
//{{leowl_1EditRSP_TBL_END}}
END_RESPONSE_TABLE;

//{{leowl_1Edit Implementation}}

IMPLEMENT_STREAMABLE1(leowl_1Edit,TLEditFile);
//////////////////////////////////////////////////////////
// leowl_1Edit
// ==========
// Construction/Destruction handling.
leowl_1Edit::leowl_1Edit (TWindow* parent,
								  int id,
								  const char far* /*text*/,
								  int x, int y, int w, int h,
								  const char far* fileName,
								  TModule* module)
	 : TLEditFile(parent, id, fileName, x, y, w, h,
	 ES_CANCHANGEFILE | ES_SMALLINDENT | ES_SMALLSPACING | ES_CANCHANGEFONT
	 | ES_FOLLOWFILENAME, module)
{
	 // Change a little LEdit behavour
	 SetFileMask("CPP/C++ files/*.cpp/Header files/*.h/All files/*.*/");
	 lpFont = new TFont((HFONT) GetStockObject(DEVICE_DEFAULT_FONT));
	 SetSyntax("0");

	 // It's extremely important to ensure streaming by reference
	 SetFlag(wfStreamTop);
}

leowl_1Edit::~leowl_1Edit ()
{
	 Destroy();
}

BOOL leowl_1Edit::Create ()
{
    BOOL result = TLEditFile::Create();

    if (result)
      {
        char Buf[255];
        GetCaption(Buf,255);
        Parent->SetWindowText(Buf);
      }
    return result;
}


void leowl_1Edit::EvSetText (LPSTR text)
{
    Parent->SetWindowText(text);
    DefaultProcessing();
}

//////////////////////////////////////////////////////////////////
/// Streamable implementation
///
void *
leowl_1Edit::Streamer::Read(ipstream& is, uint32) const
{
  leowl_1Edit* Obj = GetObject();
  ReadBaseObject((TLEditFile*) Obj, is);
  return Obj;
}

void
leowl_1Edit::Streamer::Write(opstream& os) const
{
  leowl_1Edit* Obj = GetObject();
  WriteBaseObject((TLEditFile*) Obj, os);
}




