
/***************************************************************/
/*Copyright (c) by Continocean Tech Inc. 	       	       */
/*12 Mountain Ave., Montville, New Jersey, USA 07045           */
/*All rights reserved. No part of this work covered by the     */
/*copyright hereon may be reproduced or used in any form or by */
/*any means----graphic, electronic, or mechanical, including   */
/*photocopying, recording, taping, or information storage and  */
/*retrieval systems----without written permission of 	       */
/*Continocean Tech inc.					       */
/***************************************************************/


#ifndef _CMATRIX_H
#define _CMATRIX_H	1	//prevent multiple #includes





#define HH	hermitian
class matrix;
class Complex;

class cmatrix{
	friend class matrix;
	friend class cmatrixn;
protected:
	 int		M;			// number of rows
	 int		N;			// number of columns
	 Complex		*X;


public:

	 cmatrix ();
	 cmatrix (int m, int n=1);
	 cmatrix (const cmatrix &a);
	 cmatrix (const matrix &a);
	~cmatrix ();


	 cmatrix&	operator  = (const cmatrix& a);
	 cmatrix&	operator  = (const matrix& a);
	 Complex&        operator () (int i,int j) const;
    Complex&        operator () (int i) const;
	cmatrix dtocmember(const matrix &); 
	cmatrix dtoc(const matrix &); 

	friend cmatrix operator +(const cmatrix&, const cmatrix&);
	friend cmatrix operator +(const cmatrix&, const matrix&);
	friend cmatrix operator +(const matrix&, const cmatrix&);
	friend cmatrix operator -(const cmatrix&, const cmatrix&);
	friend cmatrix operator -(const cmatrix&, const matrix&);
	friend cmatrix operator -(const matrix&, const cmatrix&);
	friend cmatrix operator -(const cmatrix&);
	friend cmatrix operator *(double, const cmatrix&);
	friend cmatrix operator *(const Complex&, const cmatrix&);
	friend cmatrix operator *(const cmatrix&, double);
	friend cmatrix operator *(const cmatrix&, const Complex&);
	friend cmatrix operator *(const cmatrix&, const cmatrix&);
	friend cmatrix operator *(const matrix&, const Complex&);
	friend cmatrix operator *(const Complex&, const matrix&);
	friend cmatrix operator *(const cmatrix&, const matrix&);
	friend cmatrix operator *(const matrix&, const cmatrix&);
	friend cmatrix operator ~(const cmatrix&); //conjugate
	friend Complex **array(const cmatrix& a);	//make cmatrix a(m,n) into array aa[][] for
						//faster addressing.
	friend cmatrix operator /(const cmatrix&,const cmatrix&);  
	friend cmatrix operator /(const Complex&,const cmatrix&);  
	friend cmatrix operator /(double,const cmatrix&);  

	friend cmatrix operator /(const cmatrix&,const Complex&);  
	friend cmatrix operator /(const cmatrix&,double);  
	friend cmatrix operator /(const cmatrix&,const matrix&);  
	friend cmatrix operator /(const matrix&,const cmatrix&);  
	friend cmatrix operator /(const matrix&,const Complex&);  
	friend cmatrix operator /(const Complex&, const matrix&);  

	friend int operator ==(const cmatrix&, const cmatrix&);  
	friend int operator !=(const cmatrix&, const cmatrix&);  


	friend double abs(const cmatrix &a); //sqrt(sum a(i,j)*~a(i,j)) 
	friend double normsq(const cmatrix &a); //sum a(i,j)*a(i,j) 
	friend cmatrix corrm(const cmatrix &x,const cmatrix &y, int n); 
	//return n-by-n correlation matrix of x and y

	friend Complex det(const cmatrix &a); 
	friend cmatrix diag(const cmatrix &a); 
	friend cmatrix hermitian(const cmatrix&);  //Hermitian (conjugate and transpose)
        friend cmatrix init(cmatrix& a, Complex x ...);
        //friend matrix init(cmatrix& a, double x ...);
	friend cmatrix joinr(const cmatrix &a, const cmatrix &b); //right join cmatrices a,b as (a b)
	friend cmatrix joinr(const cmatrix &a, const Complex& b); //right join row-vector a 
						  //with Complex b as (a b)
	friend cmatrix joinr(const Complex& a, const cmatrix & b); //right join Complex a 
						  //with row-vector b as (a b)
	friend cmatrix joind(const cmatrix &a, const cmatrix &b);
	friend cmatrix joinl(const cmatrix &a, const cmatrix &b); //lower join cmatrices a,b as |a|
						       //			    |b|	
	friend cmatrix joinl(const cmatrix &a, const Complex& b);  //lower join column-vector a   |a|
						   //with Complex b as	 	     |b|
	friend cmatrix joinl(const Complex& a, const cmatrix& b);  //lower join Complex a with |a|
						   //column-vector b as		  |b|
	friend cmatrix shiftl(const cmatrix&);//shift left
	friend cmatrix shiftr(const cmatrix&);//shift right
	friend cmatrix shiftu(const cmatrix&);//shift up
	friend cmatrix shiftd(const cmatrix&);//shift down
	friend matrix real(const cmatrix& a);//real of Complex matrix
	friend matrix imag(const cmatrix& a);//imaginary of Complex matrix
	friend cmatrix sub(const cmatrix& a, int m1, int n1, int m2, int n2);//Take subcmatrix	
				//beginning at a(m1,n1) and ending at a(m2,n2)
	friend cmatrix TT(const cmatrix&);  //transpose
	friend void printf(const cmatrix &a);  //Usage:printf(a)
        friend void printw(const cmatrix &a);  //Usage:printf(a)
	friend void fprintf(FILE *fp,const cmatrix &a);  //Usage:fprintf(fp,a)
	friend void fscanf(FILE *fp, cmatrix &a);  //Usage:fscanf(fp,a)

	friend cmatrix convol(cmatrix &x, cmatrix &y);

	friend cmatrixn corr(cmatrix &x, cmatrix &y);
	friend cmatrixn corrnorm(cmatrix &x, cmatrix &y);

};/*end of class*/


#endif
