
#ifndef _MATRIXN_H
#define _MATRIXN_H 1




#define In	identityn
#define Un	unitaryn

class cmatrixn;
class imatrixn;
class matrix;

class matrixn{
	friend class cmatrixn;
protected:
	 int		M;			// number of rows
	 int		N;			// number of columns
	 double		*X;


public:

	 matrixn ();
	 matrixn (int m, int n=0);
	 matrixn (const matrixn &a);
	 matrixn (const imatrixn &a);
	~matrixn ();


	 matrixn&	operator  = (const matrixn& a);
	 double&        operator () (int i,int j) const;
	 double&        operator () (int i) const;


	friend matrixn operator +(const matrixn&, const matrixn&);
	friend matrixn operator -(const matrixn&, const matrixn&);
	friend matrixn operator -(const matrixn&);
	friend matrixn operator *(double, const matrixn&);
	friend matrixn operator *(const matrixn&, double);
	friend matrixn operator *(const matrixn&, const matrixn&);
	friend matrixn operator /(const matrixn&, const matrixn&);  
	friend matrixn operator /(double,const matrixn&);  
	friend matrixn operator /(const matrixn&, double);  

	friend matrixn operator |(const matrixn&, const matrixn&);  //or
	friend matrixn operator &(const matrixn&, const matrixn&);  //and
	friend matrixn operator ^(const matrixn&, const matrixn&);  //X-or
        
	friend int operator ==(const matrixn&, const matrixn&);  
	friend int operator !=(const matrixn&, const matrixn&);  


	friend double abs(const matrixn &a); //sqrt(sum a(i,j)*a(i,j)) 
	friend double normsq(const matrixn &a); //sum a(i,j)*a(i,j) 
	friend double det(const matrixn &a); 
	friend matrixn identityn(int); 
        friend matrixn init(matrixn& a, double x ...);
	friend matrixn TT(const matrixn&);  //transpose
	friend void printf(const matrixn &a);  //Usage:printf(a)
	friend void printw(const matrixn& a);
	friend void fprintf(FILE *fp,const matrixn &a);  //Usage:fprintf(fp,a)
	friend void fscanf(FILE *fp, matrixn &a);  //Usage:fscanf(fp,a)

	friend matrix sub(const matrixn& a, int m1, int n1, int m2, int n2);

	friend matrixn convol(matrixn &x, matrixn &y);

	friend void plot(matrixn &a);
	friend void plot(matrixn &a, matrixn &b);
	friend void plot(matrixn &a, matrixn &b1, matrixn &b2);
	friend void plot(matrixn &a, matrixn &b1, matrixn &b2, matrixn &b3);
	friend void plot(matrixn &a, matrixn &b1, matrixn &b2, matrixn &b3, matrixn &b4);
	friend void plot(matrixn &a, matrixn &b1, matrixn &b2, matrixn &b3, matrixn &b4, matrixn &b5);


	friend void	plot(matrixn &x, matrixn &y, char *legend);
	friend void	plot(matrixn &y, char *legend);
	friend void	plot(matrixn &x, matrixn &y1, char *legend1, matrixn &y2, char *legend2);
	friend void	plot(matrixn &x, matrixn &y1, char *legend1, matrixn &y2, char *legend2, 
	 matrixn &y3, char *legend3);
	friend void	plot(matrixn &x, matrixn &y1, char *legend1, matrixn &y2, char *legend2, 
	 matrixn &y3, char *legend3,matrixn &y4, char *legend4);
	friend void	plot(matrixn &x, matrixn &y1, char *legend1, matrixn &y2, char *legend2, 
       matrixn &y3, char *legend3,matrixn &y4, char *legend4,matrixn &y5, char *legend5);


	friend matrix mn2m(matrixn &a);

};/*end of class*/




#endif


















