
/***************************************************************/
/*Copyright (c) by Continocean Tech Inc. 	       	       */
/*12 Mountain Ave., Montville, New Jersey, USA 07045           */
/*All rights reserved. No part of this work covered by the     */
/*copyright hereon may be reproduced or used in any form or by */
/*any means----graphic, electronic, or mechanical, including   */
/*photocopying, recording, taping, or information storage and  */
/*retrieval systems----without written permission of 	       */
/*Continocean Tech inc.					       */
/***************************************************************/

#ifndef _IMATRIXN_H
#define _IMATRIXN_H 1



class imatrixn{
//	friend class matrixn;
protected:
	 int		M;			// number of rows
	 int		N;			// number of columns
	 int		*X;


public:

	 imatrixn ();
	 imatrixn (int m, int n=0);
	 imatrixn (const imatrixn &a);
	~imatrixn ();


	 imatrixn&	operator  = (const imatrixn& a);
	 int&        operator () (int i,int j) const;
	 int&        operator () (int i) const;


	friend imatrixn operator +(const imatrixn&, const imatrixn&);
	friend imatrixn operator -(const imatrixn&, const imatrixn&);
	friend imatrixn operator -(const imatrixn&);
	friend imatrixn operator *(int, const imatrixn&);
	friend imatrixn operator *(const imatrixn&, int);
	friend imatrixn operator *(const imatrixn&, const imatrixn&);

	friend imatrixn operator |(const imatrixn&, const imatrixn&);  //or
	friend imatrixn operator &(const imatrixn&, const imatrixn&);  //and
	friend imatrixn operator ^(const imatrixn&, const imatrixn&);  //X-or

	friend int operator ==(const imatrixn&, const imatrixn&);  
	friend int operator !=(const imatrixn&, const imatrixn&);  

	friend int normsq(const imatrixn &a); //sum a(i,j)*a(i,j) 
        friend imatrixn init(imatrixn& a, int x ...);
	friend imatrixn TT(const imatrixn&);  //transpose
	friend void printf(const imatrixn &a);  //Usage:printf(a)
	friend void printw(const imatrixn &a);  //Usage:printf(a)
	friend void fprintf(FILE *fp,const imatrixn &a);  //Usage:fprintf(fp,a)
	friend void fscanf(FILE *fp, imatrixn &a);  //Usage:fscanf(fp,a)


};/*end of class*/


#endif



