
#ifndef _CMATRIXN_H
#define _CMATRIXN_H     1       //prevent multiple #includes

 


#define HHn      hermitian
class matrixn;
class Complex;
class cmatrix;
class matrix;

class cmatrixn{
        friend class matrixn;
protected:
         int            M;                      // number of rows
         int            N;                      // number of columns
         Complex                *X;


public:

         cmatrixn ();
         cmatrixn (int m, int n=0);
         cmatrixn (const cmatrixn &a);
         cmatrixn (const matrixn &a);
        ~cmatrixn ();


         cmatrixn&       operator  = (const cmatrixn& a);
         cmatrixn&       operator  = (const matrixn& a);
         Complex&        operator () (int i,int j) const;
         Complex&        operator () (int i) const;
        cmatrixn dtocmember(const matrixn &); 
        cmatrixn dtoc(const matrixn &); 

        friend cmatrixn operator +(const cmatrixn&, const cmatrixn&);
        friend cmatrixn operator +(const cmatrixn&, const matrixn&);
        friend cmatrixn operator +(const matrixn&, const cmatrixn&);
        friend cmatrixn operator -(const cmatrixn&, const cmatrixn&);
        friend cmatrixn operator -(const cmatrixn&, const matrixn&);
        friend cmatrixn operator -(const matrixn&, const cmatrixn&);
        friend cmatrixn operator -(const cmatrixn&);
        friend cmatrixn operator *(double, const cmatrixn&);
        friend cmatrixn operator *(const Complex&, const cmatrixn&);
        friend cmatrixn operator *(const cmatrixn&, double);
        friend cmatrixn operator *(const cmatrixn&, const Complex&);
        friend cmatrixn operator *(const cmatrixn&, const cmatrixn&);
        friend cmatrixn operator *(const matrixn&, const Complex&);
        friend cmatrixn operator *(const Complex&, const matrixn&);
        friend cmatrixn operator *(const cmatrixn&, const matrixn&);
        friend cmatrixn operator *(const matrixn&, const cmatrixn&);
        friend cmatrixn operator ~(const cmatrixn&); //conjugate
        friend cmatrixn operator /(const cmatrixn&,const cmatrixn&);  
        friend cmatrixn operator /(const Complex&,const cmatrixn&);  
        friend cmatrixn operator /(double,const cmatrixn&);  

        friend cmatrixn operator /(const cmatrixn&,const Complex&);  
        friend cmatrixn operator /(const cmatrixn&,double);  
        friend cmatrixn operator /(const cmatrixn&,const matrixn&);  
        friend cmatrixn operator /(const matrixn&,const cmatrixn&);  
        friend cmatrixn operator /(const matrixn&,const Complex&);  
        friend cmatrixn operator /(const Complex&, const matrixn&);  

	friend int operator ==(const cmatrixn&, const cmatrixn&);  
	friend int operator !=(const cmatrixn&, const cmatrixn&);  


        friend double abs(const cmatrixn &a); //sqrt(sum a(i,j)*a(i,j)) 
        friend double normsq(const cmatrixn &a); //sum a(i,j)*a(i,j) 
        friend cmatrixn corrm(const cmatrixn &,const cmatrixn &, int n);
        friend Complex det(const cmatrixn &a); 
        friend cmatrixn hermitian(const cmatrixn&);  //Hermitian (conjugate and transpose)
        //friend matrixn init(cmatrixn& a, double x ...);
        friend cmatrixn init(cmatrixn& a, Complex x ...);
        friend matrixn real(const cmatrixn&);//real of Complex matrix
        friend matrixn imag(const cmatrixn&);//imaginary of Complex matrix
        friend cmatrixn TT(const cmatrixn&);  //transpose
        friend void printf(const cmatrixn &a);  //Usage:printf(a)
        friend void printw(const cmatrixn& a);
        friend void fprintf(FILE *fp,const cmatrixn &a);  //Usage:fprintf(fp,a)
        friend void fscanf(FILE *fp, cmatrixn &a);  //Usage:fscanf(fp,a)

	friend cmatrixn convol(cmatrixn &x, cmatrixn &y);

};/*end of class*/




#endif
