#	Search for occurrences of a simple string in all the files with a
#	given extension anywhere in a directory tree.

#	Copyright (c) 1990-1992 by Hamilton Laboratories.  All rights reserved.

#	ts works by pushing the directory to be searched onto the directory
#	stack making it the current disk and directory.  ls and grep are used
#	to recursively list all files (not directories) any where in the tree
#	that end with .ext where ext is whatever the caller requests.   Assuming
#	there are some files, fgrep is used to search them, ignoring character
#	case and showing line numbers.  The test is needed since calling fgrep
#	without a filename argument would cause it to try to read stdin.  The
#	text argument is inside double quotes in case the search text is more
#	than one word.

proc ts(startdir,ext, text)

  pushd -s $startdir
  set files = `ls -rD1 | grep -i \.$ext^$`
  if (files != '') fgrep -in "$text" $files | more
  popd -s

end

ts $argv
