#	Convert an ordinary DOS-style pathname into POSIX format:

#		1.	Set it into correct mixed case since POSIX is case-
#			sensitive.
#		2.	If there's an explicit drive letter, be sure the name
#			is a fullpath since there's no way to refer to the
#			current directory on anything but the current drive
#			under POSIX rules.
#		3.	Change any from \'s to /'s.
#		4.	Convert any drive specification from the usual c: format
#			to the POSIX //C/ format.

#	This routine is particularly useful for creating C shell script
#	"wrappers" around POSIX applications such as those on the Microsoft
#	NT Resource Kit CD to convert filename arguments to POSIX format
#	before the applications are invoked.

#	Note:  This procedure does not work on UNC (network) names because
#	there is no way to convert a UNC name.

#	Copyright (c) 1994 by Hamilton Laboratories.  All rights reserved.

proc posxpath( file )
	if (file =~ "?:*") then
		if (file == substr(file, 3, 1) != "/") @ file = fullpath(file)
		set file = $file:m:gSx\x/x
		@ file = "//$upper(substr(file, 1, 1))/$substr(file, 4)"
	else
		set file = $file:m:gSx\x/x
	end
	return $file
end

posxpath $argv
