#	Fixup source files to discard any extraneous tabs or spaces at the
#	end of the lines, to ensure that all lines end properly with \r\n
#	and to ensure that timestamp can be represented exactly on a FAT
#	or HPFS partition.

#	Copyright (c) 1994-1996 by Hamilton Laboratories.  All rights reserved.

proc fixup( files )
	local i, ts, tf
	foreach i ($files)
		if (-e $i) then
			set ts = `timestmp $i`
			#	Construct a temporary name by pasting the seconds+hundredths
			#	onto the root of the file.
			set tf = $i:r.$substr(`date`:4,8):s/.//
			tr -n < $i | sed 's/^[ 	][ 	]*$//' > $tf
			touch -2 $ts $tf
			mv $tf $i
		else
			echo $i does not exist.
		end
	end
end

fixup $argv
