/***************************************************************************/
/*																									*/
/*																									*/
/*			Print the Win32 message corresponding the given error code.			*/
/*		Copyright (c) 1993 by Hamilton Laboratories.  All rights reserved.	*/
/*																									*/
/*																									*/
/***************************************************************************/

#include <windows.h>
#include <ctype.h>
#include <stdlib.h>
#include "internat.h"

void main( int argc, char **argv )
	{
	int i;
	HANDLE Stdout = GetStdHandle(STD_OUTPUT_HANDLE);
	Internationalize();

	if (Stdout == INVALID_HANDLE_VALUE)
		ExitProcess(GetLastError());

	for (i = 1;  i < argc;  i++)
		{
		register char *p, c;
		DWORD bytes;
		for (p = argv[i];  c = *p, c && isdigit(c);  p++)
			;
		if (c == 0)
			{
			char msg_buf[1024], errno_buf[20],
				NoHelp[] = "No help is available for this error.\r\n";
			DWORD Errno = (DWORD)atoi(argv[i]);
			_itoa(Errno, errno_buf, 10);
			for (p = errno_buf;  *p;  p++)
				;
			*p++ = ':';
			*p++ = ' ';
			*p++ = ' ';
			WriteFile(Stdout, errno_buf, p - errno_buf, &bytes, NULL);

			if (bytes = FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, Errno,
					MAKELANGID(LANG_NEUTRAL, SUBLANG_NEUTRAL), msg_buf,
					sizeof(msg_buf), NULL))
				WriteFile(Stdout, msg_buf, bytes, &bytes, NULL);
			else
				WriteFile(Stdout, NoHelp, sizeof(NoHelp) - 1, &bytes, NULL);
			}
		else
			{
			char NotNumeric[] = ":  No help available.  Error codes must "
					"be numeric.\r\n";
			while (*p)
				p++;
			WriteFile(Stdout, argv[i], p - argv[i], &bytes, NULL);
			WriteFile(Stdout, NotNumeric, sizeof(NotNumeric) - 1, &bytes, NULL);
			}
		}
	ExitProcess(0);
	}
