float spectrum_function(float x);


void lab07a(void){

	printw("Please use File-PrintPreview to view multiple plots and long text printouts.\n");	
	printw("\n\n");

	int n=1024*4,i;	//
	matrix sp_amp(n/2), sp_freq(n/2), sp_phase(n/2);
	float T=float(41.0e-6);


//compute spectrum of a function
	spectrum(spectrum_function, sp_freq, sp_amp, sp_phase, n, T*100);
	set_caption("Spectrum of a continuous function");
//	return;
	set_axis_title("Frequency (Hz)"," ");
	plot(sp_freq, sp_amp, "Amp", sp_phase, "Phase");


//given an FIR filter (square-root raised-cosine pulse shaping filter) taps h(1),...,h(33), 
	matrix h(n); 

	float b=(float)0.3;
	rcos_ps(h, 33, b, T);	//4-times oversampling is the default

	for(i=34;i<=n;i++) h(i)=0.0;
	float Ts=T/4; //Ts=sampling period

// return Complex array H(k) of FFT of h(k)
     cmatrix H(n);
     matrix H_amp(n),H_phase(n),H_freq(n);
	fft(h, H_freq, H, n, Ts);

	H_amp=amplitude(H);
	H_phase=phase(H);
	set_axis_title("Frequency (Hz)"," ");
	set_caption("Spectrum of an FIR filter using FFT (Ts=41.0e-6)");
	plot(H_freq,H_amp,"Amplitude",H_phase,"Phase");

//If you assume the sampling rate is 1 (Ts=1) then you may use a simpler form
	matrix hh(n-10);
	hh=sub(h,1,1,n-10,1);

	H=fft(hh); //dimension of hh is smaller than 2^r, 
		   //will be automatically appended by 0's
	H_amp=amplitude(H);
	H_phase=phase(H);
	for(i=1;i<=n;i++) H_freq(i)=i-1;
	set_axis_title("Frequency (Hz)"," ");
	set_caption("Spectrum of an FIR filter using FFT (Ts=1)");
	plot(H_freq,H_amp,"Amplitude",H_phase,"Phase");

//For the same FIR filter taps h(1),...,h(33), compute its 
//freq response using Z transform
	int m=33;

	ztransform(h, sp_freq, sp_amp, sp_phase, m, n, Ts);
	set_axis_title("Frequency (Hz)"," ");
	set_caption("Spectrum of an FIR filter using Z transform");
	plot(sp_freq, sp_amp, "Amp");

 
}//end function


float spectrum_function(float x){
  float T=float(40.0e-6);
  if(x>=T) return float(0.0);
  else if(x<float(0.0)) return float(0.0);
  else return float(1.0);
}


 






