
/***************************************************************/
/*Copyright (c) by Continocean Tech Inc. 	       	       */
/*12 Mountain Ave., Montville, New Jersey, USA 07045           */
/*All rights reserved. No part of this work covered by the     */
/*copyright hereon may be reproduced or used in any form or by */
/*any means----graphic, electronic, or mechanical, including   */
/*photocopying, recording, taping, or information storage and  */
/*retrieval systems----without written permission of 	       */
/*Continocean Tech inc.					       */
/***************************************************************/

#ifndef _SMATRIX_H
#define _SMATRIX_H 1



class smatrix{
protected:
	 int		M;			// number of rows
	 int		N;			// number of columns
	 char		*X;


public:

	 smatrix ();
	 smatrix (int m, int n=1);
	 smatrix (const smatrix &a);
	~smatrix ();


	 smatrix&	operator  = (const smatrix& a);
	 char&        operator () (int i,int j) const;
	 char&        operator () (int i) const;

	friend int operator ==(const smatrix&, const smatrix&);  
	friend int operator !=(const smatrix&, const smatrix&);  

        friend smatrix init(smatrix& a, char x ...);

	friend smatrix TT(const smatrix&);  //transpose
	friend void printf(const smatrix &a);  //Usage:printf(a)
	friend void printw(const smatrix &a);  //Usage:printf(a)
	friend void fprintf(FILE *fp,const smatrix &a);  //Usage:fprintf(fp,a)
	friend void fscanf(FILE *fp, smatrix &a);  //Usage:fscanf(fp,a)
	friend void int2string(int ia, smatrix &sa, int &len);
	friend void float2string(double fa, smatrix &sa, int &len);

	friend void fprintf(char *file, const smatrix& a);
};/*end of class*/

void float2strings(double fa, smatrix &sa, int &len); //short output
void float2stringg(double x, smatrix &sa, int &len); //output g format

#endif
