
/***************************************************************/
/*Copyright (c) by Continocean Tech Inc. 	       	       */
/*12 Mountain Ave., Montville, New Jersey, USA 07045           */
/*All rights reserved. No part of this work covered by the     */
/*copyright hereon may be reproduced or used in any form or by */
/*any means----graphic, electronic, or mechanical, including   */
/*photocopying, recording, taping, or information storage and  */
/*retrieval systems----without written permission of 	       */
/*Continocean Tech inc.					       */
/***************************************************************/


#ifndef _MATRIX_H
#define _MATRIX_H	1	//prevent multiple #includes





#include "win.h"

class cmatrix;
class imatrix;
void printw(char *fmt, ...);

class matrix{
	friend class cmatrix;
	friend class imatrix;
protected:
	 int		M;			// number of rows
	 int		N;			// number of columns
	 double		*X;


public:

	 matrix ();
	 matrix (int m, int n=1);
	 matrix (const matrix &a);
	 matrix (const imatrix &a);
	~matrix ();


	 matrix&	operator  = (const matrix& a);
	 matrix&	operator  = (const imatrix& a);
	 double&        operator () (int i,int j) const;
	 double&        operator () (int i) const;

	friend matrix operator +(const matrix&, const matrix&);
	friend matrix operator -(const matrix&, const matrix&);
	friend matrix operator -(const matrix&);
	friend matrix operator *(double, const matrix&);
	friend matrix operator *(const matrix&, double);
	friend matrix operator *(const matrix&, const matrix&);
	friend double **array(const matrix& a);	//make matrix a(m,n) into array aa[][] for
						//faster addressing.
	friend matrix operator /(const matrix&, const matrix&);  
	friend matrix operator /(double,const matrix&);  
	friend matrix operator /(const matrix&, double);  

	friend matrix operator |(const matrix&, const matrix&);  //or
	friend matrix operator &(const matrix&, const matrix&);  //and
	friend matrix operator ^(const matrix&, const matrix&);  //X-or

	friend int operator ==(const matrix&, const matrix&);  
	friend int operator !=(const matrix&, const matrix&);  

	friend matrix abs(const matrix &a); 
	friend double norm(const matrix &a); //sqrt(sum a(i,j)*a(i,j)) 
	friend double normsq(const matrix &a); //sum a(i,j)*a(i,j) 
	friend double det(const matrix &a); 
	friend matrix diag(const matrix &a); 
	friend matrix init(matrix& a, double x ...);
	friend matrix identity(int); 
	friend matrix joinr(const matrix &a, const matrix &b); //right join matrices a,b as (a b)
	friend matrix joinr(const matrix &a, double b); //right join row-vector a 
						  //with double b as (a b)
	friend matrix joinr(double a, const matrix & b); //right join double a 
						  //with row-vector b as (a b)
	friend matrix joind(const matrix &a, const matrix &b);
//	friend matrix joinl(const matrix &a, const matrix &b); //lower join matrices a,b as |a|
						   //				|b|	
	friend matrix joind(const matrix &a, double b);  //lower join column-vector a   |a|
						   //with double b as	 	  |b|
	friend matrix joind(double a, const matrix& b);  //lower join double a with    |a|
						   //column-vector b as		 |b|
	friend void phasecontinue(const matrix& p);
	friend void phasefollow(const matrix& p1,const matrix& p2);
	//p1 follows p2.

	friend matrix shiftl(const matrix&);//shift left
	friend matrix shiftr(const matrix&);//shift right
	friend matrix shiftu(const matrix&);//shift up
	friend matrix shiftd(const matrix&);//shift down
	friend matrix sub(const matrix& a, int m1, int n1, int m2, int n2);//Take submatrix	
				//beginning at a(m1,n1) and ending at a(m2,n2)
	friend matrix TT(const matrix&);  //transpose
	friend void printf(const matrix &a);  //Usage:printf(a)
	friend void printw(const matrix &a);  //Usage:printf(a)
	friend void fprintf(FILE *fp,const matrix &a);  //Usage:fprintf(fp,a)
	friend void fscanf(FILE *fp, matrix &a);  //Usage:fscanf(fp,a)

	friend double Max(const matrix &a);
	friend double Min(const matrix &a);
	friend double Max(const matrix &a, double &y_max, int &i_max, int &j_max);
	friend double Min(const matrix &a, double &y_min, int &i_min, int &j_min);

	friend matrix convol(const matrix &x, const matrix &y);

	friend void plot(const matrix &a);
	friend void plot(const matrix &a, const matrix &b);
	friend void plot(const matrix &a, const matrix &b1, const matrix &b2);
	friend void plot(const matrix &a, const matrix &b1, const matrix &b2, const matrix &b3);
	friend void plot(const matrix &a, const matrix &b1, const matrix &b2, const matrix &b3, const matrix &b4);
	friend void plot(const matrix &a, const matrix &b1, const matrix &b2, const matrix &b3, const matrix &b4, const matrix &b5);

	friend matrixn corr(const matrix& x, const matrix& y);
	friend matrixn corrnorm(const matrix &x, const matrix &y);

	friend void eigen(matrix &aa, matrix &d, matrix &z); 
	       //for symmetric matrix only
	friend void eigen(matrix &aa, cmatrix &d, cmatrix &z); 
	       //for general matrix aa

	friend double sum(const matrix &a); 
	friend double mean(const matrix &a); 
	friend double var(const matrix &a);  //variance

	friend void fprintf(char *file, const matrix& a);
	friend void fscanf(char *file, matrix &a);

	friend cmatrix fft(const matrix &h);
	friend matrix select(int k,  const matrix & a);
	friend double median(const matrix &a);
	friend double t_stat(const matrix & data1,  const matrix & data2);
	friend double t_test(const matrix & data1,  const matrix & data2);
	friend double t_testv(const matrix & data1, const matrix & data2);
	friend double t_statv(const matrix & data1, const matrix & data2);
	friend double f_test(const matrix & data1, const matrix & data2);
	friend double f_stat(const matrix & data1, const matrix & data2);
	friend void pdf(matrix& a, matrix& x, matrix& y, int n=10);

	friend void plot3(const matrix &x, const matrix &y, const matrix &z);
	friend void plot3(const matrix &x, const matrix &y, const matrix &z,char *legend);
	friend void plot3t(const matrix &a, const matrix &b,
	      double max_x2,double max_y2,double min_x2,double min_y2);
	friend void plot3(const matrix &z1, const matrix &x1, const matrix &y1,const matrix &z2, const matrix &x2, const matrix &y2);
	friend void plot3(const matrix &z1, const matrix &x1, const matrix &y1,char *legend1,
	       const matrix &z2, const matrix &x2, const matrix &y2,char *legend2);
	friend void plot3t(const matrix &a, const matrix &b1, const matrix &b2, 
	       double max_x2,double max_y2,double min_x2,double min_y2);

	friend cmatrix czt(const matrix &x, int m, const Complex &w, const Complex &a);

};/*end of class*/


matrix unitary(int n);
matrix unitary(int m,int n);
double round_max(double &max_x);
double round_min(double &min_x);
double log2(double x);
double log(double x, int n);
double gamma(double xx);
double betai(double a, double b, double x);
void round_small(double &max_x, double &min_x);
void round_max_small(double &max_x);
void round_min_small(double &min_x);
void set_axis_title(char *x_title, char *y_title,char *z_title);
void set_rotation_angle(double x, double y, double z);
void set_focal_distance(double d);
void delete_axis(void);


#endif 	


