

void lab07b(void){

	printw("Please use File-PrintPreview to view multiple plots and long text printouts.\n");	
	printw("\n\n");

	int n=1024*4,i;	//
	float T=float(41.0e-6);


//given an FIR filter (square-root raised-cosine pulse shaping filter) taps h(1),...,h(33), 
//compute its freq using FFT
	matrix h(n); 

	float b=(float)0.3;
	rcos_ps(h, 33, b, T);	//4-times oversampling is the default

	for(i=34;i<=n;i++) h(i)=0.0;
	float Ts=T/4; //Ts=sampling period
	float fs=(float)1.0/Ts/n; //fs=unit-freq

//draw h(t) before fft
	matrix h_k(33);
	for(i=1;i<=33;i++) h_k(i)=i;
	set_axis_title("time (k*Ts, Ts=10.25e-6)"," ");
	set_caption("Taps of an FIR filter");
	plot(h_k,h);

// return Complex array H(k) of FFT of h(k)
     cmatrix H(n);
     matrix H_amp(n),H_phase(n),H_freq(n);
	fft(h, H_freq, H, n, Ts);

//inverse FFT
	matrix hh(n),h_time(n);
	ifft(H, h_time, hh, n, fs);

	set_axis_title("time (k*Ts, Ts=10.25e-6)"," ");
	set_caption("Taps of the FIR filter after FFT and inverse FFT");
	plot(h_k,hh);

}//end function










