
/***************************************************************/
/*Copyright (c) by Continocean Tech Inc. 	       	       */
/*12 Mountain Ave., Montville, New Jersey, USA 07045           */
/*All rights reserved. No part of this work covered by the     */
/*copyright hereon may be reproduced or used in any form or by */
/*any means----graphic, electronic, or mechanical, including   */
/*photocopying, recording, taping, or information storage and  */
/*retrieval systems----without written permission of 	       */
/*Continocean Tech inc.					       */
/***************************************************************/

#ifndef _BINARY_h
#define _BINARY_h 1



class sbinary;


class binary{
	friend class sbinary;
	friend class smatrix;
protected:
	 int		M;			// number of rows
	 int		*X;


public:

	 binary ();
	 binary (int m);
	 binary (const binary &a);
	 binary (const sbinary &a);
	~binary ();


	 binary&	operator  = (const binary& a);
	 int&        operator () (int i) const;


	friend int bin2int(const binary& a);  
	friend binary int2bin(int a, int m=16);  //convert a to m-binary  

	friend binary operator +(const binary&, const binary&);
	friend binary operator *(int, const binary&);
	friend binary operator *(const binary&, int);
	friend binary operator *(const binary&, const binary&);
	friend binary operator /(const binary&, const binary&);  
	friend binary operator /(int,const binary&);  
	friend binary operator /(const binary&, int);  

	friend binary operator ~(const binary& a);     	//invert all bits (1's complement)

	friend binary operator |(const binary&, const binary&);  //or
	friend binary operator &(const binary&, const binary&);  //and
	friend binary operator ^(const binary&, const binary&);  //X-or
        
	friend binary operator >>(const binary& a, int n); //shift right
	friend binary operator <<(const binary& a, int n); //shift left        

	friend int operator ==(const binary&, const binary&);  
	friend int operator !=(const binary&, const binary&);  

	friend int operator >(const binary&, const binary&);  
	friend int operator >=(const binary&, const binary&);  
	friend int operator <(const binary&, const binary&);  
	friend int operator <=(const binary&, const binary&);  

	friend void printf(const binary &a);  //Usage:printf(a)
	friend void printw(const binary &a);  //Usage:printf(a)
	friend void fprintf(FILE *fp,const binary &a);  //Usage:fprintf(fp,a)
	friend void fscanf(FILE *fp, binary &a);  //Usage:fscanf(fp,a)

	friend void fprintf(char *file, const binary& a);

	friend double pcmd(const binary &b);
	friend double pcmd(const binary &b,double mu);
	friend double pcmad(const binary &b,double mu);

};/*end of class*/


#endif
