unit wsc;

interface

const
   (* COMM Ports *)
   COM1 = 0;
   COM2 = 1;
   COM3 = 2;
   COM4 = 3;
   COM5 = 4;
   COM6 = 5;
   COM7 = 6;
   COM8 = 7;
   COM9 = 8;
   (* Baud Rate Codes *)
   Baud300  = 0;
   Baud600  = 1;
   Baud1200 = 2;
   Baud2400 = 3;
   Baud4800 = 4;
   Baud9600 = 5;
   Baud19200  = 6;
   Baud38400  = 7;
   Baud57600  = 8;
   Baud115200 = 9;
   (* Parity Codes *)
   NoParity    = 0;
   OddParity   = 1;
   EvenParity  = 2;
   MarkParity  = 3;
   SpaceParity = 4;
   (* Stop Bit Codes *)
   OneStopBit  = 0;
   TwoStopBits = 2;
   (* Word Length Codes *)
   WordLength5 = 5;
   WordLength6 = 6;
   WordLength7 = 7;
   WordLength8 = 8;
   (* WSC errors *)
   WSC_NO_DATA  = -100;
   WSC_RANGE    = -101;
   WSC_ABORTED  = -102;
   WSC_WIN32ERR = -103;
   WSC_EXPIRED  = -104;
   (* Windows comm errors *)
   IE_BADID      = -1;
   IE_OPEN       = -2;
   IE_NOPEN      = -3;
   IE_MEMORY     = -4;
   IE_DEFAULT    = -5;
   IE_HARDWARE   = -10;
   IE_BYTESIZE   = -11;
   IE_BAUDRATE   = -12;
   (* SioGetError masks *)
   WSC_RXOVER   = $0001;
   WSC_OVERRUN  = $0002;
   WSC_PARITY   = $0004;
   WSC_FRAME    = $0008;
   WSC_BREAK    = $0010;
   WSC_TXFULL   = $0100;

function SioBaud(Port, BaudCode : Integer) : Integer;
function SioCTS(Port : Integer) : Integer;
function SioDCD(Port : Integer) : Integer;
function SioDebug(Cmd : Integer) : Integer;
function SioDone(Port : Integer) : Integer;
function SioDSR(Port : Integer) : Integer;
function SioDTR(Port : Integer; Cmd : Char) : Integer;
function SioFlow(Port: Integer; Cmd : Char) : Integer;
function SioGetc(Port: Integer) : Integer;
function SioGets(Port : Integer; BufPtr : PChar; Size : Word) : Integer;
function SioInfo(Cmd : Char) : Integer;
function SioParms(Port, ParityCode, StopBitsCode, DataBitsCode : Integer) : Integer;
function SioPutc(Port : Integer; Ch : Char) : Integer;
function SioPuts(Port : Integer; BufPtr : PChar; Size : Word) : Integer;
function SioRead(Port : Integer; Reg : Integer) : Integer;
function SioReset(Port, RxQueSize, TxQueSize : Integer) : Integer;
function SioRI(Port : Integer) : Integer;
function SioRTS(Port : Integer; Cmd : Char ) : Integer;
function SioRxClear(Port : Integer) : Integer;
function SioRxQue(Port : Integer) : Integer;
function SioStatus(Port : Integer; Mask : Word) : Integer;
function SioTxClear(Port : Integer) : Integer;
function SioTxQue(Port : Integer) : Integer;

implementation

function SioBaud; external 'WSC16';
function SioCTS; external 'WSC16';
function SioDCD; external 'WSC16';
function SioDebug; external 'WSC16';
function SioDone; external 'WSC16';
function SioDSR; external 'WSC16';
function SioDTR; external 'WSC16';
function SioFlow; external 'WSC16';
function SioGetc; external 'WSC16';
function SioGets; external 'WSC16';
function SioInfo; external 'WSC16';
function SioParms; external 'WSC16';
function SioPutc; external 'WSC16';
function SioPuts; external 'WSC16';
function SioRead; external 'WSC16';
function SioReset ; external 'WSC16';
function SioRI; external 'WSC16';
function SioRTS; external 'WSC16';
function SioRxClear; external 'WSC16';
function SioRxQue; external 'WSC16';
function SioStatus; external 'WSC16';
function SioTxClear; external 'WSC16';
function SioTxQue; external 'WSC16';
end.  
