unit regexp;

interface
uses SysUtils, Registry, Dialogs, Controls, Forms;

procedure InstallAutoDBExpert;

const
  REGSTR_PATH_AUTODBEXPERT = 'Software\Borland\Delphi\2.0\Experts';
  REGSTR_NAME_AUTODBEXPERT = 'AFExpert';
  FILE_NAME_AUTODBEXPERT = 'afexpert.dll';
implementation

procedure InstallAutoDBExpert;
Var
  reg : TRegIniFile;
  flag : Boolean;
  fod :  TOpenDialog;
  St : String;
begin
  reg := TRegIniFile.Create(REGSTR_PATH_AUTODBEXPERT);
  reg.LazyWrite := True;
  if  Not (reg.ValueExists(REGSTR_NAME_AUTODBEXPERT)) then
    if(MessageDlg('Auto Expert doesn''t install. Do you want to install it now ?',
            mtConfirmation, [mbYes, mbNo], -1) = mrYes) then begin
        fod := TOpenDialog.Create(Application);
        fod.Filter := 'Auto Expert (' + FILE_NAME_AUTODBEXPERT + ') |'+ FILE_NAME_AUTODBEXPERT;
        if(fod.Execute) then begin
          reg.WriteString('', REGSTR_NAME_AUTODBEXPERT, fod.FileName);
          St := 'Auto Expert is installed' + Char(9) + Char(13) +
           'Restart Delphi and go to File -> New -> AutoFormExperts';
          MessageDlg(St,  mtInformation, [mbOk], -1);
        end;
        fod.Free; 
     end;
  reg.Free;
end;


end.
