unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids, Buttons, StdCtrls, ExtCtrls, DB, DBTables,
  afilter, AutoDB, adbgrid, acheat;

type
  TMainForm = class(TForm)
    DataSource1: TDataSource;
    Panel1: TPanel;
    Panel2: TPanel;
    Button1: TButton;
    BitBtn1: TBitBtn;
    AutoDBGrid1: TAutoDBGrid;
    AutoQuery1: TAutoQuery;
    AutoQuery1Name: TStringField;
    AutoQuery1Capital: TStringField;
    AutoQuery1Continent: TStringField;
    AutoQuery1Population: TFloatField;
    FilterLink1: TFilterLink;
    AutoCheat1: TAutoCheat;
    procedure Button1Click(Sender: TObject);
    procedure AutoDBGrid1DrawFieldCellEvent(Sender: TObject; Field: TField;
      var Color: TColor; var Font: TFont);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses About, regexp;



{$R *.DFM}

procedure TMainForm.Button1Click(Sender: TObject);
begin
  fmAboutBox.ShowModal;
end;

procedure TMainForm.AutoDBGrid1DrawFieldCellEvent(Sender: TObject;
  Field: TField; var Color: TColor; var Font: TFont);
Var
  p : Integer;
begin
  if(Field = AutoQuery1.FindField('population')) then begin
    p := AutoQuery1.FindField('population').AsInteger;
    if(p < 1000000) then begin
      Color := clWhite;
      Font.Style := [fsItalic];
    end;
    if(p >= 1000000) And (p < 50000000) then
      Color := clSilver;
    if(p >= 5000000) And (p < 10000000) then
      Color := clGray;
    if(p >= 5000000) And (p < 10000000) then
      Color := clOlive;
    if(p >= 10000000) And (p < 50000000) then
      Color := clRed;
    if(p > 50000000) then begin
      Color := clMaroon;
      Font.Style := [fsBold];
    end;
  end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  InstallAutoDBExpert;
end;

end.
