unit wserver;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms, StdCtrls,
  WapCalls;

type
  TWapSrv = class(TForm)
    Label1: TLabel;
    THitLabel: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    iiHits  :integer;
  public
    procedure WebRequest(var msg: TMessage); message wm_User + 1;
  end;

var
  WapSrv: TWapSrv;

implementation
{$R *.DFM}


procedure TWapSrv.FormCreate(Sender: TObject);
var
  liRet      :integer;
begin
   liRet := StartServing(handle, wm_user + 1, '0.0.0.0', 80);
   if liRet <> 1 then
     THitLabel.Caption := 'Could not start Wapapi: ' + IntToStr(liRet);
   iiHits := 0;
end;

procedure TWapSrv.FormDestroy(Sender: TObject);
begin
   StopServing();
end;

// WebRequest:  this is a user-defined event on the form that
//              has been hooked to a window's message.
//              the message number: wm_User + 1 has been used
//              but any number above 1024 (wm_User) may be used, as long
//              as the same event number that is used to declare the
//              user event is passed to Wapapi in the StartServing call.
//
procedure TWapSrv.WebRequest(var msg :TMessage);
var
  lbparms  :boolean;
  lsDoc                    :pchar;
  liRet, liParms                  :integer;
begin
   lsDoc := StrAlloc(512);
   liRet := GetDocName(lsDoc, liParms);
   if (lsDoc='\') or (lsDoc = '') then StrPCopy(lsDoc, 'index.htm');
   if Pos('.', lsDoc) = 0 then lsDoc := StrCat(lsDoc, '.htm');

   liRet := SendDocument(lsDoc);
   StrDispose(lsDoc);
   Inc(iiHits);
   THitLabel.Caption := IntToStr(iiHits);
   THitLabel.Refresh();
end;

end.
