//===============================================
//===== REALISATION DES CLASSES D'EXCEPTION =====
//===============================================

#include "state.cfg"

#include "stateerr.hpp"
#include "msgerror.h"

#include <string.h>

//----- conditionnel car affichage
#if STATE_SYSTEME == STATE_DOS
#include <iostream.h>    // pour les COUT
#endif
#if STATE_SYSTEME == STATE_WINDOWS
#include <owl\dialog.h>
#include <owl\controlb.h>
#endif

/* ===== Classe "StateError" ===== */
StateError::StateError(int code)
{
  codeError = code;
}
StateError::~StateError()
{
}
void StateError::display()
{ /* Cette methode ne doit normalement jamais etre executee          */
  /* En effet, Il ne doit jamais exister d'instance de cette classe. */
  /* Cependant, pourqu'il soit possible d'ecrire des gestionnaires   */
  /* d'exception de la forme :                                       */
  /*      catch(StateError erreur) { erreur.display(); }             */
  /* la classe "StateError" ne peut pas etre rendue virtuelle en     */
  /* faisant de la methode "StateError::display" une methode         */
  /* virtuelle pure. Serait-ce une limitation du C++ [:->            */

#if STATE_SYSTEME == STATE_DOS
  cout << "Erreur: Classe de l'exception incorrecte !!!"  << endl;
#endif
#if STATE_SYSTEME == STATE_WINDOWS
  MessageBox(0,"Erreur: Classe de l'exception incorrecte !!!","STATE EXCEPTION",MB_OK);
#endif
}

/* ===== Classe "StateInternalError" ===== */
StateInternalError::StateInternalError(int code):StateError(code)
{
}
StateInternalError::~StateInternalError()
{
}
void StateInternalError::display()
{
#if STATE_SYSTEME == STATE_DOS
  cout << "StateInternalError : "  << InternalErrorMsg[codeError] << endl;
#endif
#if STATE_SYSTEME == STATE_WINDOWS
  char texte[512];
  strcpy(texte,"StateInternalError :\n");
  strcat(texte,InternalErrorMsg[codeError]);
  MessageBox(0,texte,"STATE EXCEPTION",MB_OK);
#endif
}

/* ===== Classe "StateBehaviorError" ===== */
char StateBehaviorError::textInfo[text_info_size]; 
  /* definition OBLIGATOIRE car dans "stateerr.hpp" */
  /* il ne s'agit que d'une DECLARATION.            */

StateBehaviorError::StateBehaviorError(int code,char* texte):StateError(code)
{
  if (texte)
  {
    strcpy(StateBehaviorError::textInfo,texte);
#ifdef TRACE
#if STATE_SYSTEME == STATE_DOS
    cout << "Creation StateBehaviorError. textInfo = " <<  textInfo << endl;
#endif
#endif
  }
  else
  {
#ifdef TRACE
#if STATE_SYSTEME == STATE_DOS
    cout << "Creation StateBehaviorError SANS textInfo " << endl;
#endif
#endif
    StateBehaviorError::textInfo[0]='\0';
  }
}

StateBehaviorError::~StateBehaviorError()
{
#ifdef TRACE
#if STATE_SYSTEME == STATE_DOS
    cout << "Destruction StateBehaviorError << endl;
#endif
#endif
}
void StateBehaviorError::display()
{
#if STATE_SYSTEME == STATE_DOS
  cout << "StateBehaviorError : "  << BehaviorErrorMsg[codeError]; 
  if (StateBehaviorError::textInfo[0])
  {
    cout << " [" << StateBehaviorError::textInfo << "]";
  }
  cout << endl;
#endif
#if STATE_SYSTEME == STATE_WINDOWS
  char texte[512];
  strcpy(texte,"StateBehaviorError :\n");
  if (StateBehaviorError::textInfo[0])
  {
    strcat(texte,StateBehaviorError::textInfo);
  }
  MessageBox(0,texte,"STATE EXCEPTION",MB_OK);
#endif
}
