Define InvRepPageHead(doc, head, page, line, linesperpage) {
    if (page)
        PdPageFeed(doc);
    PdWrite(doc, PfFormat(head, "", 
                        StrCat("page ", page = page + 1)));
                        line = linesperpage;
}
Define InvRepProcType(doc, scr, head, dtl, des, 
                      page, line, linesperpage, type, desc) {
    if (line <= 3)
        InvRepPageHead(doc, head, &page, &line, linesperpage);
    PdWrite(doc, PfFormat(des, "", desc));
    line -= 3;

    while (1) {
        Explode(next(glob^inv_stat^[type]^[code]^[nvar]), "^", &p1, &p2, &code);
        
        if (p1 != "inv_stat" || p2 != type)
            break;
        if (abort = MsgShow(scr, desc . " " . code))
            break;
        if (line <= 1) 
            InvRepPageHead(doc, head, &page, &line, linesperpage);
        PdWrite(doc, PfFormat(dtl, "", 
                              code, 
                              univ^[type]_code^[code],
                              glob^inv_stat^[type]^[code]^cnt,
                              glob^inv_stat^[type]^[code]^vamt,
                              glob^inv_stat^[type]^[code]^base,
                              glob^inv_stat^[type]^[code]^extr));
        line -= 1;
        nvar = "zzzz";
    }
    return abort;
}
Define InvRepStat() {
/*
    glob^inv_stat^vtyp^mv^cnt           (I know base comes before cnt)
    .....................^base
    .....................^extr
    .....................^vamt
    ..................^nmv^cnt
    ......................^base
    ......................^vamt
    .............^ptyp^d^cnt
    ....................^base
    ....................^extr
    ....................^vamt
    ..................^ft^cnt
    .....................^base
    .....................^extr
    .....................^vamt
    etc
*/
    if (PeriodStartEndGet("Invoice Statistics Report", &fromDate, &toDate) != 1)
        return;
    scr = MsgCreate("Invoice Statistics Report");

    while (1) {                     /* clear where we accumulate stats */
                                    /* other way is to open the temp file ! */
        Explode(next(glob^inv_stat^[type]^[code]^[item]),
                "^", &p1, &type, &code, &item);
        if (p1 != "inv_stat")
            break;
        glob^inv_stat^[type]^[code]^[item] = "";
    }
    glob^inv_stat^total^cnt = 0;
    glob^inv_stat^total^vamt = 
    glob^inv_stat^total^base =
    glob^inv_stat^total^extr = 0.0;

    date = fromDate;
    code = "";
    while (1) {
        Explode(next(data^inv_date^[date]^[code]), "^", &p1, &date, &code);

        if (p1 != "inv_date" || date > toDate)
            break;

        if (abort = MsgShow(scr, date . " Invoice " . code))
            break;

        vtyp = data^inv^[code]^vtyp;
        vamt = data^inv^[code]^vamt;
        base = data^inv^[code]^base;
        extr = data^inv^[code]^extr;
        glob^inv_stat^vtyp^[vtyp]^cnt  += 1;
        glob^inv_stat^vtyp^[vtyp]^vamt += vamt;
        glob^inv_stat^vtyp^[vtyp]^base += base;
        glob^inv_stat^vtyp^[vtyp]^extr += extr;

        ptyp = data^inv^[code]^ptyp;
        glob^inv_stat^ptyp^[ptyp]^cnt  += 1;
        glob^inv_stat^ptyp^[ptyp]^vamt += vamt;
        glob^inv_stat^ptyp^[ptyp]^base += base;
        glob^inv_stat^ptyp^[ptyp]^extr += extr;

        glob^inv_stat^total^cnt += 1;
        glob^inv_stat^total^vamt += vamt;
        glob^inv_stat^total^base += base;
        glob^inv_stat^total^extr += extr;
    }

    if (!abort) {
        doc = PdCreate(parm^prt^def^name, "InvRepStat", parm^prt^def^append, 
                       parm^prt^def^copies, parm^prt^def^browse, 
                       0, 85, 0, "",
                       parm^prt^def^start, parm^prt^def^end);
        PdPageSize(doc, parm^page^def^height, 
                        parm^page^def^width,
                        parm^page^def^margin^top, 
                        parm^page^def^margin^bottom,
                        parm^page^def^margin^left, 
                        parm^page^def^margin^right);

        head = PfCreate();
        PfPrompt(head, 0,  0, univ^spar^coname);
        PfPrompt(head, 0, 50, DateToday());
        PfPrompt(head, 0, 62, TimeNow());
        PfString(head, 0, 71, 10, "R");
        PfPrompt(head, 0, 82, "of");
        PfPrompt(head, 2, 20, StrCat("Invoice Statistics for ", fromDate, " to ", toDate));
        PfPrompt(head, 4,  0, "Code     Description");
        PfPrompt(head, 4, 51, "#Vals    Val Amt  Base Fees    Extras");
        PfPrompt(head, 5,  0, " ");

        dtl = PfCreate();
        PfString(dtl,  0,  0, 8);
        PfString(dtl,  0,  9, 40);
        PfInt   (dtl,  0, 50, 6);
        PfFloat (dtl,  0, 56, 11, 0);
        PfFloat (dtl,  0, 67, 11, 2);
        PfFloat (dtl,  0, 78, 10, 2);

        des = PfCreate();
        PfString(des,  1,  0, 50);
        PfPrompt(des,  2,  0, " ");


        PdWrite(doc, PfFormat(head, "", StrCat("page ", page = page + 1)));
        linesperpage = line = parm^page^def^height -
                            parm^page^def^margin^top - 
                            parm^page^def^margin^bottom - 5;

        while (1) {
            if (abort = InvRepProcType(doc, scr, head, dtl, des, 
                                       &page, &line, linesperpage, 
                                       "vtyp", "Valuation Types"))
                break;
            if (abort = InvRepProcType(doc, scr, head, dtl, des,
                                       &page, &line, linesperpage, 
                                       "ptyp", "Property Types"))
                break;

            if (line <= 4)
                InvRepPageHead(doc, head, &page, &line, linesperpage);
            PdWrite(doc, PfFormat(des, "", "Total Valuations"));
            PdWrite(doc, PfFormat(dtl, "", "", "", glob^inv_stat^total^cnt,
                                                   glob^inv_stat^total^vamt,
                                                   glob^inv_stat^total^base,
                                                   glob^inv_stat^total^extr));
            break;
        }

        PfDestroy(head);
        PfDestroy(dtl);
        PfDestroy(des);
        PdClose(doc, abort);
    }
    MsgDestroy(scr);
}
