Define InvPrint(code) {
    InvPrintCreate();
    abort = InvPrintSingle(code);
    InvPrintDestroy(abort);
}
Define InvPrintCreate() {
    glob^invp^doc = PdCreate(parm^prt^inv^name, "InvPrint",
                            parm^prt^inv^append, 
                            parm^prt^inv^copies,
                            parm^prt^inv^browse,
                            0, 0, 0, "",
                            parm^prt^inv^start,
                            parm^prt^inv^end);
    PdPageSize(glob^invp^doc, parm^page^inv^height, 
                             parm^page^inv^width,
                             parm^page^inv^margin^top, 
                             parm^page^inv^margin^bottom,
                             parm^page^inv^margin^left, 
                             parm^page^inv^margin^right);

    glob^invp^scr = MsgCreate("Invoice Print Progress");

    glob^invp^fmt10 = fmt = PfCreate();
    PfDate  (fmt,  0,  0, 10);              /* todays date */
    PfPrompt(fmt,  5,  0, " ");

    glob^invp^fmt20 = fmt = PfCreate();
    PfString(fmt,  0,  0, 12);              /* client attention */
    PfString(fmt,  0, 14, 50);
    PfPrompt(fmt,  1,  0, " ");

    glob^invp^fmt30 = fmt = PfCreate();     /* client address */
    PfString(fmt,  0,  0, 50);
    PfString(fmt,  2,  0, 50);
    PfString(fmt,  4,  0, 50);
    PfString(fmt,  6,  0, 50);
    PfPrompt(fmt,  6, 50, "Our Ref:");
    PfInt   (fmt,  6, 59, 6);
    PfPrompt(fmt,  9,  0, " ");

    glob^invp^fmt40 = fmt = PfCreate();
    PfPrompt(fmt,  0,  0, "Re:  Valuation  -");
    PfString(fmt,  0, 18, 40);              /* property address */
    PfString(fmt,  1, 18, 40);
    PfString(fmt,  2, 18, 40);
    PfString(fmt,  3, 18, 40);
    PfPrompt(fmt,  5,  0, " ");

    glob^invp^fmt50 = fmt = PfCreate();     /* applicant name */
    PfString(fmt,  0,  5, 11);
    PfString(fmt,  0, 18, 40);
    PfPrompt(fmt,  1,  0, " ");

    glob^invp^fmt60 = fmt = PfCreate();     /* loan account number */
    PfString(fmt,  0,  5, 16);
    PfString(fmt,  0, 23, 20);
    PfPrompt(fmt,  3,  0, " ");

    glob^invp^fmt70 = fmt = PfCreate();     /* fee */
    PfString(fmt,  0,  0, 49, "l", ".");
    PfPrompt(fmt,  0, 49, "$");
    PfFloat (fmt,  0, 50, 10, 2, "l");
}
Define InvPrintDestroy(abort) {
    PfDestroy(glob^invp^fmt70);
    PfDestroy(glob^invp^fmt60);
    PfDestroy(glob^invp^fmt50);
    PfDestroy(glob^invp^fmt40);
    PfDestroy(glob^invp^fmt30);
    PfDestroy(glob^invp^fmt20);
    PfDestroy(glob^invp^fmt10);
    MsgDestroy(glob^invp^scr);
    PdClose(glob^invp^doc, abort);
}
Define InvPrintSingle(code) {
    if (!(abort = MsgShow(glob^invp^scr, "Invoice Number : " . code))) {

        PdWrite(glob^invp^doc, PfFormat(glob^invp^fmt10, "", 
                                        data^inv^[code]^date));

        client = data^inv^[code]^clnt;
        branch = data^inv^[code]^brch;
        if (!branch) {
            preFld  = StrCat("clnt^", client);
            preCode = StrCat("clnt_code^", client);
        }
        else {
            preFld  = StrCat("clbr^", client, "^", branch);
            preCode = StrCat("clbr_code^", client, "^", branch);
        }

        if (attn = univ^[preFld]^attn)
            attnPrompt = "Attention:";
        PdWrite(glob^invp^doc, PfFormat(glob^invp^fmt20, "", 
                                        attnPrompt, 
                                        attn));

        PdWrite(glob^invp^doc, PfFormat(glob^invp^fmt30, "", 
                                        univ^[preCode],
                                        univ^[preFld]^add1,
                                        univ^[preFld]^add2,
                                        univ^[preFld]^add3,
                                        data^inv^[code]^job));

        PdWrite(glob^invp^doc, PfFormat(glob^invp^fmt40, "", 
                                        data^inv^[code]^add1,
                                        data^inv^[code]^add2,
                                        data^inv^[code]^add3,
                                        data^inv^[code]^add4));

        if (appl = data^inv^[code]^appl)
            applPrompt = "Applicant:";
        PdWrite(glob^invp^doc, PfFormat(glob^invp^fmt50, "", 
                                        applPrompt, 
                                        appl));

        if (loan = data^inv^[code]^loan)
            loanPrompt = "Loan Account No:";
        PdWrite(glob^invp^doc, PfFormat(glob^invp^fmt60, "", 
                                        loanPrompt,
                                        loan));

        if (!(feet = data^inv^[code]^feet))
            feet = "Fees";
        PdWrite(glob^invp^doc, PfFormat(glob^invp^fmt70, "", 
                                        feet,
                                        data^inv^[code]^base +
                                        data^inv^[code]^extr));
    }
    return abort;
}

