Define DosBackupRestore(type) {
    if (type == "b")
        title = "File Backup";
    else
        title = "File Restore";

    scr = SdCreate(,-2, -2, 15, 64, title);
    SdPrompt(scr, 1, 3, "Diskette Device :");
    SdRadio (scr, "deva", 1, 1, 21,  6, &parm^bkup^dev, "A:", "a");
    SdRadio (scr, "devb", 1, 1, 30,  6, &parm^bkup^dev, "B:", "b");

    SdPrompt(scr, 3, 3, "Data Directory  :");
    SdString(scr, "dir", 1,  3, 21, 40, &parm^bkup^dir);
    SdPrompt(scr, 4, 43, "(\\ is added)");

    SdPrompt(scr, 6, 3, "Filename        :");
    SdString(scr, "file", 1,  6, 21, 20, &parm^bkup^file);
    SdPrompt(scr, 6, 43, "(Wildcard allowed)");

    if (type == "b") {
        SdPrompt(scr,  9, 3, "Remember : BACKUP will copy the specified Filename(s)");
        SdPrompt(scr, 10,14, "FROM the Data Directory TO the Diskette Device");
    }
    else {
        SdPrompt(scr,  9, 3, "Remember : RESTORE will copy the specified Filename(s)");
        SdPrompt(scr, 10,14, "FROM the Diskette Device TO the Data Directory");
    }
    SdPrompt(scr, 11,14, " ");  // so that previous line isnt highlighted

    SdButton(scr, "", 1,    13, 21, 10, "OK",     "", 1);
    SdButton(scr, "", 1,    13, 34, 10, "Cancel", "", 2);

    while (1) {
        if (SdEdit(scr, cursor) == 1) {
            if (!SdFieldGet(scr, cursor = "file")) {
                MsgWait("", "You must enter something in filename (eg *.dat)");
                continue;
            }
            if (!SdFieldGet(scr, cursor = "deva") && !SdFieldGet(scr, "devb")) {
                MsgWait("", "You must choose a Backup Device");
                continue;
            }

            SdUpdate(scr);
            if (type == "b")
                SystemRestart("compause backup " . parm^bkup^dir . "\\" .
                              parm^bkup^file . " " . parm^bkup^dev . ":");
            else
                SystemRestart("compause restore " . parm^bkup^dev . ": " . 
                       parm^bkup^dir . "\\" . parm^bkup^file);
        }
        break;
    }
    SdDestroy(scr);
}
Define SysFileRecover(name) {
    check = 1;
    while (1) {
        scr = SdCreate(,-1, -1, 18, 72, "System Startup");
        SdPrompt(scr, 2,  9, StrCat(name, " has been improperly closed"));
        SdButton(scr, "", 1,     5,  9, 20, "Restore Files", "r", 30);
        SdButton(scr, "", check, 7,  9, 20, "Check File", "c", 31);
        SdButton(scr, "", 1,     9,  9, 20, "Rebuild File", "b", 32);
        SdButton(scr, "", 1,    16, 55, 10, "Cancel", "", 2);

        cmd = SdEdit(scr);
        SdDestroy(scr);

        if (cmd == 30)
            DosBackupRestore("r");
        else if (cmd == 31) {
            rc = Spawn("stu check -c " . name);
            if (rc == 1) {
                MsgWait("System Startup", 
                        "Errors were found in " . name .
                        ".\nThe file has been left in its\noriginal (improperly closed) state."
                        );
                check = 0;
                val = "";
                continue;
            }
            Signal("");             /* will restart and try another time */
        }
        else if (cmd == 32)
            SpawnRestart("stu rebuild -c " . name);
        else if (cmd == 2 || cmd == 3)
            break;
    }
    Exit("System stopped at users request");
}

Define SysLockQuery(name) {
    if (MsgYesNo("System File Locking", name . " cannot be locked\n\
\n\
Do you wish to retry ?") != 1)
        return 1;
}
