If(0)
/*
    SYSTEM PARAMETERS IN PARM FILE

    system^mdir^threshold   = mdir memory limit

    system^date^format      = date format "u" for mm/dd/yyyy else dd/mm/yyyy
    system^text^browser     = name of the text mode browser program  eg. l.com
    system^gui^browser      = name of Windows browser  eg. notepad.exe
    system^word^Define      = if set, specifies alternative for Define keyword
    system^word^Eval        = ditto for Eval
    system^word^If          = ditto for If
    system^word^Elseif      = ditto for Elseif
    system^word^Else        = ditto for Else
    system^word^Endif       = ditto for Endif
*/
Endif
Define SysParm()
{
    scr = SdCreate(, -1, -1, 16, 72, "Nadir System Parameters");

    SdPrompt(scr, 1, 2, "Mdir Threshold  :", "m");
    SdInt   (scr, "",   1,  1, 20,  8, &parm^system^mdir^threshold);
    SdPrompt(scr, 3, 2, "Date Format     :", "d");
    SdRadio (scr, "",   1,  3, 20, 20, &parm^system^date^format, 
                                        "dd/mm/yy - Aust", "a");
    SdRadio (scr, "",   1,  4, 20, 20, &parm^system^date^format, 
                                        "mm/dd/yy - US", "u");
    SdPrompt(scr, 6, 2, "Text Browser    :", "t");
    SdString(scr, "",   1,  6, 20,  20, &parm^system^text^browser, 64);
    SdPrompt(scr, 7, 2, "Gui Browser     :", "g");
    SdString(scr, "",   1,  7, 20,  20, &parm^system^gui^browser, 64);

    SdPrompt(scr, 9, 2, "Words - ", "w");
    SdPrompt(scr, 9,10, "Define  :");
    SdString(scr, "w0",     1,  9, 20,  16, &parm^system^word^Define);
    SdPrompt(scr,10,10, "Eval    :");
    SdString(scr, "w1",     1, 10, 20,  16, &parm^system^word^Eval);
    SdPrompt(scr,11,10, "If      :");
    SdString(scr, "w2",     1, 11, 20,  16, &parm^system^word^If);
    SdPrompt(scr,12,10, "Elseif  :");
    SdString(scr, "w3",     1, 12, 20,  16, &parm^system^word^Elseif);
    SdPrompt(scr,13,10, "Else    :");
    SdString(scr, "w4",     1, 13, 20,  16, &parm^system^word^Else);
    SdPrompt(scr,14,10, "Endif   :");
    SdString(scr, "w5",     1, 14, 20,  16, &parm^system^word^Endif);

    SdButton(scr, "", 1,    14, 41, 10, "OK",     "", 1);
    SdButton(scr, "", 1,    14, 55, 10, "Cancel", "", 2);

    while (SdEdit(scr, cursor) == 1) {
        /* 
            validate special words
        */
        for (cnt = 0, err = ""; cnt < 6 && !err; cnt += 1) {
            cursor = StrCat("w", cnt);
            TokenScanCreate(SdFieldGet(scr, cursor));
            if (TokenNext() || TokenTerm())
                err = "No whitespace allowed";
            else if (TokenType() == "EOT")
                ;               /* null entry is ok */
            else if (TokenType() != "NAME")
                err = "Word entered not a name";
            else if (TokenNext() || TokenTerm())
                err = "No whitespace after word allowed";
            else if (TokenType() != "EOT")
                err = "More than one word entered";
            /*
                else its ok
            */
            TokenScanDestroy();
        }
        if (err) {
            MsgWait("", err);
            continue;
        }
        SdUpdate(scr);
        Signal("Restarting system to initialize with new parameters");
    }
    SdDestroy(scr);
}
Define SysSdParm()
{
    scr = SdCreate(, -1, -1, 16, 72, "Windows Dialogue Parameters");

    SdCheck (scr, "c0",   1, 1, 2, 36, &parm^dialog^option^chisel, 
                            "Chisel effects in dialogues", "c");
    SdCheck (scr, "c1",   1, 2, 2, 36, &parm^dialog^option^combo^dclick, 
                            "Double clicks in combo boxes", "d");
    SdCheck (scr, "c2",   1, 3, 2, 36, &parm^dialog^option^grid, 
                            "Draw grid lines in dialogues", "g");
    SdPrompt(scr, 5, 2, "Font");
    SdPrompt(scr, 5, 7, "Name:");
    SdString(scr, "fn",     1,  5, 16,  16, &parm^dialog^font^name, 32);
    SdPrompt(scr, 6, 7, "Height:");
    SdInt   (scr, "fh",     1,  6, 16,  4, &parm^dialog^font^height);
    SdPrompt(scr, 7, 7, "Weight:");
    SdRadio (scr, "fw1",    1,  7, 16, 12, &parm^dialog^font^weight, 
                                        "Bold", "b");
    SdRadio (scr, "fw2",    1,  8, 16, 12, &parm^dialog^font^weight, 
                                        "Normal", "n");
    SdRadio (scr, "fw3",    1,  9, 16, 12, &parm^dialog^font^weight, 
                                        "Default", "d");
    SdPrompt(scr, 11, 2, "Button Style:");
    SdRadio (scr, "bs1",    1, 11, 16, 12, &parm^dialog^option^button^style, 
                                        "Rounded", "r");
    SdRadio (scr, "bs2",    1, 12, 16, 12, &parm^dialog^option^button^style, 
                                        "Square", "s");
    SdRadio (scr, "bs3",    1, 13, 16, 12, &parm^dialog^option^button^style, 
                                        "Default", "d");

    SdButton(scr, "", 1,    14, 41, 10, "OK",     "", 1);
    SdButton(scr, "", 1,    14, 55, 10, "Cancel", "", 2);

    while (SdEdit(scr, cursor) == 1) {
        SdUpdate(scr);
        Signal("Restarting system to initialize with new parameters");
    }
    SdDestroy(scr);
}


