unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, VBXCtrl, Lgauge25, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    LGauge1: TLGauge;
    Button1: TButton;
    LGauge2: TLGauge;
    LGauge3: TLGauge;
    LGauge4: TLGauge;
    Timer1: TTimer;
    procedure LGauge1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure LGauge4Change(Sender: TObject);
    procedure LGauge3Change(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.LGauge1Change(Sender: TObject);

var
  value: real;

begin

    {get value of pointer(0)}
    LGauge1.PointerID := 0;
    value := LGauge1.PointerValue;

    {change band level}
    LGauge1.BandID := 1;
    LGauge1.BandStart := value;

    {check value of pointer(1)}
    LGauge1.PointerID := 1;
    If LGauge1.PointerValue > value Then
        LGauge1.PointerValue := value;

    {check value of pointer(2)}
    LGauge1.PointerID := 2;
    If LGauge1.PointerValue < value Then
        LGauge1.PointerValue := value;

end;

procedure TForm1.Button1Click(Sender: TObject);

var
  value: real;

begin

    {get value of pointer(0)}
    LGauge1.PointerID := 0;
    value := LGauge1.PointerValue;

    {set value of pointer(1)}
    LGauge1.PointerID := 1;
    LGauge1.PointerValue := value;

    {set value of pointer(2)}
    LGauge1.PointerID := 2;
    LGauge1.PointerValue := value;

end;

procedure TForm1.LGauge4Change(Sender: TObject);

var

   pstart: real;
   pstop: real;

begin

    if LGauge4.PointerID=0 then
       begin
        LGauge4.PointerID := 0;
        pstart := LGauge4.PointerStart;
        pstop := LGauge4.PointerStop;

        LGauge4.PointerID := 1;
        LGauge4.PointerValue := pstart;

        LGauge4.PointerID := 2;
        LGauge4.PointerValue := pstop;
       end
    else if LGauge4.PointerID=1 then
       begin
        LGauge4.PointerID := 1;
        pstart := LGauge4.PointerValue;

        LGauge4.PointerID := 0;
        If pstart > LGauge4.PointerStop - 5 Then
            pstart := LGauge4.PointerStop - 5;

        LGauge4.PointerStart := pstart;
        LGauge4.PointerID := 1;
        LGauge4.PointerValue := pstart;
       end
    else
       begin
        LGauge4.PointerID := 2;
        pstop := LGauge4.PointerValue;
        LGauge4.PointerID := 0;
        If pstop < LGauge4.PointerStart + 5 Then
                pstop := LGauge4.PointerStart + 5;

        LGauge4.PointerStop := pstop;
        LGauge4.PointerID := 2;
        LGauge4.PointerValue := pstop;
       End;

end;

procedure TForm1.LGauge3Change(Sender: TObject);

var
   a, b: real;

begin

    case LGauge3.PointerID of
        0: begin
            LGauge3.PointerID := 0;
            a := LGauge3.PointerValue;

            LGauge3.PointerID := 1;
            b := LGauge3.PointerValue;

            LGauge3.PointerID := 2;
            LGauge3.PointerValue := a * b;
           End;
        1: Begin
            LGauge3.PointerID := 0;
            a := LGauge3.PointerValue;

            LGauge3.PointerID := 1;
            b := LGauge3.PointerValue;

            LGauge3.PointerID := 2;
            LGauge3.PointerValue := a * b;
           End;
        2: Begin
            LGauge3.PointerID := 2;
            a := LGauge3.PointerValue;

            LGauge3.PointerID := 0;
            LGauge3.PointerValue := Sqrt(a);

            LGauge3.PointerID := 1;
            LGauge3.PointerValue := Sqrt(a);
           End;
    End;

End;

procedure TForm1.Timer1Timer(Sender: TObject);

var

   value: real;

begin

    LGauge1.PointerID := 0;
    LGauge1.PointerValue := LGauge1.PointerValue + 3*Random(1000)/1000-1.5;
    value := LGauge1.PointerValue;

    {change band level}
    LGauge1.BandID := 1;
    LGauge1.BandStart := value;

    {check value of pointer(1)}
    LGauge1.PointerID := 1;
    If LGauge1.PointerValue > value Then
        LGauge1.PointerValue := value;

    {check value of pointer(2)}
    LGauge1.PointerID := 2;
    If LGauge1.PointerValue < value Then
        LGauge1.PointerValue := value;

end;

end.
