// vcview.cpp : implementation of the CVcView class
//

#include "stdafx.h"
#include "vc.h"

#include "vcdoc.h"
#include "vcview.h"

#include "math.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVcView

IMPLEMENT_DYNCREATE(CVcView, CFormView)

BEGIN_MESSAGE_MAP(CVcView, CFormView)
	//{{AFX_MSG_MAP(CVcView)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_VBXEVENT(VBN_CHANGE, IDC_LGAUGE1, OnChangeLgauge1)
	ON_VBXEVENT(VBN_CHANGE, IDC_LGAUGE2, OnChangeLgauge2)
	ON_VBXEVENT(VBN_CHANGE, IDC_LGAUGE3, OnChangeLgauge3)
	ON_VBXEVENT(VBN_SLIDE, IDC_LGAUGE1, OnChangeLgauge1)
	ON_VBXEVENT(VBN_SLIDE, IDC_LGAUGE2, OnChangeLgauge2)
	ON_VBXEVENT(VBN_SLIDE, IDC_LGAUGE3, OnChangeLgauge3)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVcView construction/destruction

CVcView::CVcView()
	: CFormView(CVcView::IDD)
{
	//{{AFX_DATA_INIT(CVcView)
	m_lgauge3 = NULL;
	m_lgauge1 = NULL;
	m_lgauge2 = NULL;
	//}}AFX_DATA_INIT
	// TODO: add construction code here
}

CVcView::~CVcView()
{
}

void CVcView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVcView)
	DDX_VBControl(pDX, IDC_LGAUGE3, m_lgauge3);
	DDX_VBControl(pDX, IDC_LGAUGE1, m_lgauge1);
	DDX_VBControl(pDX, IDC_LGAUGE2, m_lgauge2);
	//}}AFX_DATA_MAP
	
	SetTimer(1,55,NULL);
}

/////////////////////////////////////////////////////////////////////////////
// CVcView diagnostics

#ifdef _DEBUG
void CVcView::AssertValid() const
{
	CFormView::AssertValid();
}

void CVcView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CVcDoc* CVcView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CVcDoc)));
	return (CVcDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CVcView message handlers


void CVcView::OnButton1()
{
float value;

    //get value of pointer(0)
    m_lgauge1->SetNumProperty("PointerID",0);
    value = m_lgauge1->GetFloatProperty("PointerValue");
    
    //set value of pointer(1)
    m_lgauge1->SetNumProperty("PointerID",1);
    m_lgauge1->SetFloatProperty("PointerValue",value);
    
    //set value of pointer(2)
    m_lgauge1->SetNumProperty("PointerID",2);
    m_lgauge1->SetFloatProperty("PointerValue",value);
}

void CVcView::OnDestroy()
{
	CFormView::OnDestroy();
	
	KillTimer(1);
	
}

void CVcView::OnTimer(UINT nIDEvent)
{
float max,min,value;
	
	//update thermometer example
    //get value of pointer(0)
    m_lgauge1->SetNumProperty("PointerID",0);
    value = m_lgauge1->GetFloatProperty("PointerValue");
    value = value + (float) 3.0*rand()/RAND_MAX - (float) 1.5;
    m_lgauge1->SetFloatProperty("PointerValue",value);
    value = m_lgauge1->GetFloatProperty("PointerValue");
    
    //change band level
    m_lgauge1->SetNumProperty("BandID",1);
    m_lgauge1->SetFloatProperty("BandStart",value);
    
    //check value of pointer(1)
    m_lgauge1->SetNumProperty("PointerID",1);
    min = m_lgauge1->GetFloatProperty("PointerValue");
    if (value<min) {
        m_lgauge1->SetFloatProperty("PointerValue",value);
        }
    
    //check value of pointer(2)
    m_lgauge1->SetNumProperty("PointerID",2);
    max = m_lgauge1->GetFloatProperty("PointerValue");
    if (value > max) {
        m_lgauge1->SetFloatProperty("PointerValue",value);
    	}


	CFormView::OnTimer(nIDEvent);
}

void CVcView::OnChangeLgauge1(UINT, int, CWnd*, LPVOID)
{
float max,min,value;
	
    //get value of pointer(0)
    m_lgauge1->SetNumProperty("PointerID",0);
    value = m_lgauge1->GetFloatProperty("PointerValue");
    
    //change band level
    m_lgauge1->SetNumProperty("BandID",1);
    m_lgauge1->SetFloatProperty("BandStart",value);
    
    //check value of pointer(1)
    m_lgauge1->SetNumProperty("PointerID",1);
    min = m_lgauge1->GetFloatProperty("PointerValue");
    if (value<min) {
        m_lgauge1->SetFloatProperty("PointerValue",value);
        }
    
    //check value of pointer(2)
    m_lgauge1->SetNumProperty("PointerID",2);
    max = m_lgauge1->GetFloatProperty("PointerValue");
    if (value > max) {
        m_lgauge1->SetFloatProperty("PointerValue",value);
    	}
	
}

void CVcView::OnChangeLgauge2(UINT, int, CWnd*, LPVOID)
{
int pointerid;
float a,b;

	pointerid = (int) m_lgauge2->GetNumProperty("PointerID");
	
	switch (pointerid) {
		case 0:
            m_lgauge2->SetNumProperty("PointerID",0);
            a = m_lgauge2->GetFloatProperty("PointerValue");
            
            m_lgauge2->SetNumProperty("PointerID",1);
            b = m_lgauge2->GetFloatProperty("PointerValue");
    		
            m_lgauge2->SetNumProperty("PointerID",2);
            m_lgauge2->SetFloatProperty("PointerValue",a * b);
            break;
        case 1:
        	m_lgauge2->SetNumProperty("PointerID",0);
            a = m_lgauge2->GetFloatProperty("PointerValue");
            
            m_lgauge2->SetNumProperty("PointerID",1);
            b = m_lgauge2->GetFloatProperty("PointerValue");
    		
            m_lgauge2->SetNumProperty("PointerID",2);
            m_lgauge2->SetFloatProperty("PointerValue",a * b);
            break;
        case 2:
        	m_lgauge2->SetNumProperty("PointerID",2);
            a = m_lgauge2->GetFloatProperty("PointerValue");
            b=(float) pow((double) a,0.5);
            
            m_lgauge2->SetNumProperty("PointerID",0);
            m_lgauge2->SetFloatProperty("PointerValue",b);
            
            m_lgauge2->SetNumProperty("PointerID",1);
            m_lgauge2->SetFloatProperty("PointerValue",b);
            break;
        }
	
}

void CVcView::OnChangeLgauge3(UINT, int, CWnd*, LPVOID)
{
int pointerid;
float b,pstart,pstop;

	pointerid = (int) m_lgauge3->GetNumProperty("PointerID");
	
	switch (pointerid) {
		case 0:
            m_lgauge3->SetNumProperty("PointerID",0);
            pstart = m_lgauge3->GetFloatProperty("PointerStart");
            pstop = m_lgauge3->GetFloatProperty("PointerStop");
            
            m_lgauge3->SetNumProperty("PointerID",1);
            m_lgauge3->SetFloatProperty("PointerValue",pstart);
    		
            m_lgauge3->SetNumProperty("PointerID",2);
            m_lgauge3->SetFloatProperty("PointerValue",pstop);
            break;
        case 1:
            m_lgauge3->SetNumProperty("PointerID",1);
            pstart = m_lgauge3->GetFloatProperty("PointerValue");
            
            m_lgauge3->SetNumProperty("PointerID",0);
            b = m_lgauge3->GetFloatProperty("PointerStop");
            if (pstart > b-5) 
            	pstart = b-5;
            
            m_lgauge3->SetFloatProperty("PointerStart",pstart);
    		m_lgauge3->SetNumProperty("PointerID",1);
            m_lgauge3->SetFloatProperty("PointerValue",pstart);
            break;
        case 2:
            m_lgauge3->SetNumProperty("PointerID",2);
            pstop = m_lgauge3->GetFloatProperty("PointerValue");
            
            m_lgauge3->SetNumProperty("PointerID",0);
            b = m_lgauge3->GetFloatProperty("PointerStart");
            if (pstop < b+5) 
            	pstop = b+5;
            
            m_lgauge3->SetFloatProperty("PointerStop",pstop);
    		m_lgauge3->SetNumProperty("PointerID",2);
            m_lgauge3->SetFloatProperty("PointerValue",pstop);
            break;
        }
}

