#ifndef __WPRBRWSE
#define WPRBRWSE


/***************************** Flag definitions ******************************/

#define PRF_NEWQUEUE		0x00000001L
#define PRF_CHANGEDQUEUE	0x00000002L
#define PRF_DELETEDQUEUE	0x00000004L

/***************************** Type definitions ******************************/

typedef struct {

   /* This structure is used to pass parameter values to the PrBrowsePrinters API.
      The calling application must provide buffers for all desired items and must
      assign the lpsz* pointers and buffer sizes accordingly. For all items that
      the calling application is not interested in, the relevant buffer pointer
      must be set to NULL.
   */

   int nStructSize;                 // Size of structure (for version recognition)
				    // Must be set by calling application (see
				    // sample given for call to PrBrowsePrinters
				    // below).
   DWORD dwFlags;                   // Flags, reserved for future use
   HWND hwndParentWindow;           // Parent window used for dialog all dialogs that
                                    // the called API might open.
   LPSTR lpszPrinterDescription;    // Buffer to receive a description string
   int nPrinterDescriptionSize;     // Size of above buffer
   LPSTR lpszLocalQueueName;        // Buffer to receive local queue name
   int nLocalQueueNameSize;         // Size of above buffer
   LPSTR lpszRemoteQueueName;       // Buffer to receive remote queue name
   int nRemoteQueueNameSize;        // Size of above buffer
   LPSTR lpszRemoteHostName;        // Buffer to receive remote host name
   int nRemoteHostNameSize;         // Size of above buffer
   LPSTR lpszProtocolDLL;           // Buffer to receive Protocol DLL name
   int nProtocolDLLSize;            // Size of above buffer
} PRBROWSEINFO, *PPRBROWSEINFO, FAR *LPPRBROWSEINFO;

typedef struct {

   /* This structure is used to pass parameter values to the PrPostQueueDefCallback API.
      Any of the string pointer can be NULL if the information is unavailable.
      The lpszOld* members are only present when dwFlags has the PRF_CHANGEDQUEUE bit set,
      otherwise they are NULL.
   */

   int nStructSize;                 // Size of structure (for version recognition)
				    // Must be set by calling application (see
				    // sample given for call to PrBrowsePrinters
				    // below).
   DWORD dwFlags;                   // either PRF_NEWQUEUE or PRF_CHANGEDQUEUE
   HWND hwndParentWindow;           // Parent window used for dialog all dialogs that
                                    // the called API might open.
   LPSTR lpszPrinterDescription;    // String containing the description
   LPSTR lpszLocalQueueName;        // String containing the local queue (spool file) name
   LPSTR lpszRemoteQueueName;       // String containing the remote queue name
   LPSTR lpszRemoteHostName;        // String containing the remote host name
   LPSTR lpszProtocolDLL;           // String containing the protocol DLL
   LPSTR lpszSpoolDirectory;        // String containing the spool directory
   LPSTR lpszOldPrinterDescription; // String containing the old description
   LPSTR lpszOldLocalQueueName;     // String containing the old local queue (spool file) name
   LPSTR lpszOldRemoteQueueName;    // String containing the old remote queue name
   LPSTR lpszOldRemoteHostName;     // String containing the old remote host name
   LPSTR lpszOldProtocolDLL;        // String containing the old protocol DLL
} PRPOSTQUEUEDEFCALLBACKINFO, *PPRPOSTQUEUEDEFCALLBACKINFO, far *LPPRPOSTQUEUEDEFCALLBACKINFO;

/*********** Prototypes for the exported functions in the browse DLL *********/

/* The following function displays a dialog where the user can select a remote
   printer from a given list of available printers. The function fills all
   buffer variables given in the argument structure up to the given buffer
   lengths. If one of the buffer pointers is NULL, the value will not be
   copied.

   An application calling this function must first initialize the nStructSize
   member with the size of the structure before calling the function:

	memset(&prBrowseInfo,0,sizeof(prBrowseInfo));
        prBrowseInfo.nStructSize = sizeof(prBrowseInfo);
	iret = PrBrowsePrinters(&prBrowseInfo);

   Return Code: IDOK when the Ok button was pressed
                IDCANCEL when the Cancel button was pressed
*/

int FAR PASCAL PrBrowsePrinters(LPPRBROWSEINFO lpPrBrowseInfo);

/* The following function is called by the Windows LPR Spooler when the user has either
   defined a new queue or changed the queue data.

   An application calling this function must first initialize the nStructSize
   member with the size of the structure before calling the function:

	memset(&prPostQueueDefCallbackInfo,0,sizeof(prPostQueueDefCallbackInfo));
	prPostQueueDefCallbackInfo.nStructSize = sizeof(prPostQueueDefCallbackInfo);
	iret = PrPostQueueDefCallback(&prPostQueueDefCallbackInfo);

   Return Code: IDOK when the Ok button was pressed
                IDCANCEL when the Cancel button was pressed
*/

int FAR PASCAL PrPostQueueDefCallback(LPPRPOSTQUEUEDEFCALLBACKINFO lpPrPostQueueDefCallbackInfo);

/******* Prototypes for dynamically linking to the functions in the DLL *****/

typedef int (FAR PASCAL *LPPRBROWSEPRINTERS) (LPPRBROWSEINFO);
typedef int (FAR PASCAL *LPPRPOSTQUEUEDEFCALLBACK) (LPPRPOSTQUEUEDEFCALLBACKINFO);


typedef struct {
   HANDLE hlprdll;
   char lprdllname[MAXPATH];
   LPPRBROWSEPRINTERS LPPrBrowsePrinters;
   LPPRPOSTQUEUEDEFCALLBACK LPPrPostQueueDefCallback;
} BROWSEDLLREC, *PBROWSEDLLREC, far *LPBROWSEDLLREC;

#endif